
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float g_time;


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  o.vTexcoord = (v.vTexcoord); 
 
  return o;
}

struct PS_OUT {
  float4 rt0 : COLOR0; 
};

texture g_tDiffuse;
sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVignette;
sampler smVignette =
sampler_state {
  Texture = <g_tVignette>;
  MipFilter = LINEAR;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = MIRROR;
  AddressV = MIRROR;
};



float g_amount = 1.0;
float4 g_color;

float g_zoom_x;
float g_zoom_y;

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float2 tcOfs = +float2(0.50/g_windowWidth, 0.50/g_windowHeight);

  float4 r = tex2D(smDiffuse, In.vTexcoord+tcOfs);
  float2 tcVign = (In.vTexcoord-float2(0.5, 0.5));
  tcVign.x *= g_zoom_x;
  tcVign.y *= g_zoom_y;
  tcVign += float2(0.5, 0.5);
  r.xyz *= ((1.0-g_amount)+g_amount*tex2D(smVignette, tcVign+tcOfs).xyz);
  o.rt0 = r;
  return o;
}

technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs();
        PixelShader  = compile ps_3_0 ps();
    }
}

