
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float4 g_blur_strength;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(1.0/g_windowWidth, 1.0/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);
float4 g_distort;
float4 g_distortDepth;
float4 g_distortFreqOfs;

float g_time;

texture g_tDepth;
texture g_tNormal;
texture g_tDiffuse;
texture g_tScreen;

sampler smDepth =
sampler_state {
  Texture = <g_tDepth>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smNormal =
sampler_state {
  Texture = <g_tNormal>;
  MipFilter = POINT;
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = POINT;
  MagFilter = POINT;  
  AddressU = BORDER;
  AddressV = BORDER;
};


sampler smScreen=
sampler_state {
  Texture = <g_tScreen>;
  MipFilter = LINEAR; // ANISOTROPIC, LINEAR, POINT, PYRAMIDALQUAD, GAUSSIANQUAD
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = MIRROR; // BORDER;
  AddressV = MIRROR; // BORDER;
};


PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;

  float4 depthIn = tex2D(smDepth, In.vTexcoord+float2((-0.5)/g_windowWidth, (-0.5)/g_windowHeight));  
  
  float depthus = smoothstep(0.0, g_distortDepth.z, (depthIn.x-g_distortDepth.x)*g_distortDepth.y);

  depthus *=depthus*g_distortDepth.w;  
  
  float2 distort = float2(sin(g_time*g_distortFreqOfs.x+In.vTexcoord.x*g_distort.z+g_distortFreqOfs.z), 
                          cos(g_time*g_distortFreqOfs.y+In.vTexcoord.y*g_distort.w+g_distortFreqOfs.w))*g_distort.xy;
  float4 colorIn = tex2D(smScreen, In.vTexcoord+distort*depthus+float2((-0.5)/g_windowWidth, (-0.5)/g_windowHeight));
 
  float4 result = 0;
  
  result = g_color*colorIn;
  
  o.rt0 = result;
  return o;
}



technique Render {
    pass P0 {          
        VertexShader = compile vs_2_a vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

