
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float4 g_blur_strength;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;


texture g_tDiffuse;

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};


texture g_tTonemap;

sampler smTonemap =
sampler_state {
  Texture = <g_tTonemap>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

  #define FXAA_PC 1
  #define FXAA_HLSL_3 1
  #define FXAA_QUALITY__PRESET 12
  #define FXAA_LINEAR 0
  #define FXAA_GREEN_AS_LUMA 0

#include "Fxaa3_11.h"

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;

  float4 result = 0;
  float2 pos = In.vTexcoord;
  float4 posPos;

  float2 rcpFrame = float2(1.0/g_windowWidth, 1.0/g_windowHeight);  
  posPos.xy = In.vTexcoord+float2((-0.50)/g_windowWidth, (0.50)/g_windowHeight);
  posPos.zx = In.vTexcoord+float2((0.50)/g_windowWidth, (-0.50)/g_windowHeight);
  
 // Fxaa3_8.h
/*
  float4 rcpFrameOpt = float4(2.0/g_windowWidth, 2.0/g_windowHeight, 0.5/g_windowWidth, 0.5/g_windowHeight);
  result = FxaaPixelShader(pos, posPos, smDiffuse, rcpFrame, rcpFrameOpt);
*/
 
 // Fxaa3_11.h
  float fxaaQualitySubpix = 0.75;
  float fxaaQualityEdgeThreshold = 0.166;
  float fxaaQualityEdgeThresholdMin = 0.0833;
  float fxaaConsoleEdgeSharpness = 8.0;
  float fxaaConsoleEdgeThreshold = 0.125;
  float fxaaConsoleEdgeThresholdMin = 0.05;
  float4 fxaaConsole360ConstDir = float4(0.0, 0.0, 0.0, 0.0);
  float n = 0.5;
  float4 rcpFrameOpt = float4(-n/g_windowWidth, -n/g_windowHeight, n/g_windowWidth, n/g_windowHeight);
  float4 rcpFrameOpt2 = float4(-2.0/g_windowWidth, -2.0/g_windowHeight, 2.0/g_windowWidth, 2.0/g_windowHeight);
  float4 rcpFrameOpt3 = float4(8.0/g_windowWidth, 8.0/g_windowHeight, -4.0/g_windowWidth, -4.0/g_windowHeight);
  result = FxaaPixelShader(pos, posPos, smDiffuse, smDiffuse, smDiffuse, rcpFrame, rcpFrameOpt, rcpFrameOpt2, rcpFrameOpt3,
                           fxaaQualitySubpix, fxaaQualityEdgeThreshold, fxaaQualityEdgeThresholdMin, fxaaConsoleEdgeSharpness,
						   fxaaConsoleEdgeThreshold, fxaaConsoleEdgeThresholdMin, fxaaConsole360ConstDir);

 result.a = 1.0;
  
  o.rt0 = result;
  return o;
}



technique Render {
    pass P0 {          
        VertexShader = compile vs_2_a vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

