
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float4 g_blur_strength;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(1.0/g_windowWidth, 1.0/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

texture g_tDiffuse;

float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord+float2((-0.5)/g_windowWidth, (-0.5)/g_windowHeight));
 
  float4 result = 0;
  
  float at = 1.0;
  
  result = 1.0*colorIn*at;

  for (int y=0; y<2; y++) {
    for (int x=0; x<2; x++) {
    
      float2 po = In.vTexcoord+g_blur_strength.r*float2((x-0.250-0.5)/g_windowWidth, (y-0.25-0.5)/g_windowHeight);
      float4 dd = tex2D(smDiffuse, po);
      result += dd;
      at += 1.0;
    }
  }
  
  result = result/at*1.0;
  result.a = clamp(result.r+result.g+result.b, 0.0, 1.0);
  
  result *= g_color;

  result.xyz *= g_grid.z;
  
  if (g_grid.y > 0.5) {
	  float4 kukko = float4(result.xyz, 0.5);
	  kukko.xy += In.vTexcoord.xy;
	  
	  result.xyz = (kukko-0.5)*g_grid.x;
	  result.a = 1.0;
  } else {
    result.xyz = clamp(result.xyz, 0.0, 10.0);
  }

  
  o.rt0 = result;
  return o;
}



technique Render {
    pass P0 {          
        VertexShader = compile vs_2_a vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

