
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;

float g_time;


texture g_tDiffuse;

sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float4 colorIn = tex2D(smDiffuse, In.vTexcoord+float2((-0.5)/g_windowWidth, (-0.5)/g_windowHeight));
  float4 result = colorIn;
  
  float pixIndex = In.vTexcoord.x*g_windowWidth + (int)(In.vTexcoord.y*g_windowHeight)*g_windowWidth;
  
  float pf = pixIndex*0.001;
  
  result.x = sin(7.7678*cos(pf*1.2348+g_time*0.01))*100.0;
  result.y = cos(6.28954*sin(pf*1.41243+0.012*g_time))*20.0;
  result.z = sin(pf*1.2442135+0.014*g_time)*100.0;
  result.w = 1.0;
    
  o.rt0 = result;
  return o;
} 



technique Render {
    pass P0 {          
        VertexShader = compile vs_2_a vs( );
        PixelShader  = compile ps_3_0 ps( );
    }
}

