
float4x4 g_mWorldViewProjection;
float4x4 g_mView;
float4x4 g_mViewBill;
float4x4 g_mProj;
float4x4 g_mWorld;

float g_windowWidth;
float g_windowHeight;

float2 g_texCoordScale;
float2 g_texCoordOfs;

float4 g_color;
float g_diffuse;
float g_specular;
float g_ambience;

float g_time;

float g_size;
float4 g_aspect;

float g_defHeight;
float g_defBumpness;
float g_depthClipMul;



struct VS_INPUT_PIX_PARTICLE {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
    float  Depth  : DEPTH;
};


texture g_texPartPos;
sampler smPartPos = sampler_state {
  Texture = <g_texPartPos>;
  MinFilter = POINT;
  MagFilter = POINT;
  MipFilter = NONE;
  AddressU = CLAMP;
  AddressV = CLAMP;
};


texture g_texPartVel;
sampler smPartVel = sampler_state {
  Texture = <g_texPartVel>;
  MinFilter = POINT;
  MagFilter = POINT;
  MipFilter = NONE;
  AddressU = CLAMP;
  AddressV = CLAMP;
};


float g_particleIndexOffset;

float4 rotateXZ(float4 p, float a) {
  float4 r = p;
  
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  
  return r;
}

float4 rotateXY(float4 p, float a) {
  float4 r = p;
  
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  
  return r;
}


struct VS_OUTPUT_PIX_PARTICLE {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
    float4  vTangent : TEXCOORD2;
    float4  vBiTangent : TEXCOORD3;
    float  Depth  : TEXCOORD4;
    float4  vColor : TEXCOORD5;
};


VS_OUTPUT_PIX_PARTICLE vs_float_to_onezero( const VS_INPUT_PIX_PARTICLE v ) {
  VS_OUTPUT_PIX_PARTICLE o = (VS_OUTPUT_PIX_PARTICLE)o;
  
  float4 vp = v.vPosition;
  float4 vpT;
  
  vpT.y = ((float)((int)((vp.z+g_particleIndexOffset)/g_windowWidth)));
  vpT.x = ((vp.z+g_particleIndexOffset)-vpT.y*g_windowWidth);
  
  vpT.x *= 1.0/g_windowWidth;
  vpT.y *= 1.0/g_windowHeight;
  vpT.z = 0;
  vpT.w = 0;
  
  vpT.x += 0.5/g_windowWidth;
  vpT.y += 0.5/g_windowHeight;
  
  vp = tex2Dlod(smPartPos, vpT);

  float4 vpVel = tex2Dlod(smPartVel, vpT);

  float ageLeft = clamp(vp.w, 0.0, 100000.0);
  
  vp.w = 1.0;   
  vp = mul(vp, g_mView);
  
  float4 bill = float4(v.vPosition.x*g_size*g_aspect.x, v.vPosition.y*g_size*g_aspect.y, 0.0, 1.0);
  
  float angle = vpVel.w;
  bill = rotateXY(bill, angle);
  
  bill = mul(bill, g_mViewBill);

  vp.x += bill.x;
  vp.y += bill.y;
  
  o.vPosition = mul(vp, g_mProj);
  o.vPosSS = o.vPosition;
  
  float2 tc = float2(v.vPosition.x+1.0, -v.vPosition.y+1.0)*0.5;
  
  
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = ((tc)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight))*g_texCoordScale+g_texCoordOfs; 
  
  float2 res = float2(512.0, 512.0);
  
  float3 normalResult;
  o.vTangent = float4(1.0, 0.0, 0.0, 1.0);
  o.vTangent = rotateXY(o.vTangent, angle);
  o.vTangent *= 1.0/res.x;
  
  o.vBiTangent = float4(0.0, 1.0, 0.0, 1.0);
  o.vBiTangent = rotateXY(o.vBiTangent, angle);
  o.vBiTangent *= 1.0/res.y;

  o.vColor = float4(1.0, 1.0, 1.0, ageLeft);
  
  o.Depth = v.Depth;
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

struct PS_OUT_DEF {
  float4 rt0 : COLOR0; // depth
  float4 rt1 : COLOR1; // normal
  float4 rt2 : COLOR2; // diffuse
  float4 rt3 : COLOR3; // ambspec
  float  Depth  : DEPTH;
};



texture g_texDiffuse;
texture g_texHeight;

sampler sm =
sampler_state {
  Texture = <g_texDiffuse>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smHeight =
sampler_state {
  Texture = <g_texHeight>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = WRAP;
  AddressV = WRAP;
};


PS_OUT ps_particle( VS_OUTPUT_PIX_PARTICLE In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
 
  result += tex2D(sm, In.vTexcoord);
  result = clamp(result*1.0, 0.0, 100000.0)*g_color;
   
  o.rt0 = result;
  return o;
}



PS_OUT_DEF ps_particle_deferred( VS_OUTPUT_PIX_PARTICLE In ) {

 
  float depthaa = tex2D(smHeight, In.vTexcoord).g;
  float depthi = (In.vPosSS.z-0.05f-depthaa*g_defHeight) / In.vPosSS.w;
  
  if (In.Depth > depthi)
    discard;

  float4 depthPart = depthaa*g_color*g_depthClipMul;


  float ageLeft = In.vColor.a;
  depthPart.a *= saturate(ageLeft*0.0010);

  if ((depthPart.a) < (1.0-depthPart.g)*1.0 || depthPart.a < 0.01)
    discard;
    
    
	
  PS_OUT_DEF o = (PS_OUT_DEF)0;
  float4 result = 0;
	
  float4 diffu = tex2D(sm, In.vTexcoord);
  result = diffu*g_color*g_diffuse;
  result = clamp(result, 0.0, 100000.0);
   
  // diffuse 
  result.a = 1.0;
  o.rt2 = result;
    
  // normal
  float4 bumpe = 0;
  bumpe.x = (tex2D(smHeight, In.vTexcoord+float2(In.vTangent.x, In.vTangent.y)).g - tex2D(smHeight, In.vTexcoord-float2(In.vTangent.x, In.vTangent.y)).g)*(-0.667);
  bumpe.y = (tex2D(smHeight, In.vTexcoord+float2(In.vBiTangent.x, In.vBiTangent.y)).g - tex2D(smHeight, In.vTexcoord-float2(In.vBiTangent.x, In.vBiTangent.y)).g)*(1.0);
  bumpe = bumpe*g_defBumpness; //*depthLerp;
  bumpe.z = -g_defHeight;
  bumpe = (normalize(bumpe)+1.0)*0.5;
 // bumpe = (bumpe+1.0)*0.5;
      
  o.rt1 = float4(bumpe.x, bumpe.y, bumpe.z, 0.0);  

  o.Depth = depthi;
  
  // depth
  o.rt0 = depthi;  
    
  o.rt3.x = g_ambience;
  o.rt3.y = g_specular;
  o.rt3.z = 32.0;
  
  return o;
}


technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_particle( );
    }
}

technique RenderDeferred {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_particle_deferred( );
    }
}




