

float2 height_func_march(float2 p) {
   float2 resx = float2(1.0/1024.0, 0.0);
   float2 resy = float2(0.0, 1.0/1024.0);
   float2 result = 0;
   result.x = tex2D(smHeight, p+resx).g-tex2D(smHeight, p-resx).g;
   result.y = tex2D(smHeight, p+resy).g-tex2D(smHeight, p-resy).g;
   return result;
}

float g_march_depth = 1.0;

float4 rotateXZ(float4 p, float a) {
  float4 r = p;
  
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  
  return r;
}

struct VS_OUTPUT_BASIC_KO {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
    float4  vPosSO : TEXCOORD6;
};


VS_OUTPUT_BASIC_KO vs_deferred_draw_march( const VS_INPUT v ) {
  VS_OUTPUT_BASIC_KO o;
  
  float4 vPosTrans = v.vPosition*2.0;
  
 // vPosTrans = rotateXZ(vPosTrans, 5.0*clamp(sin(vPosTrans.y*0.150+g_time*0.4),0.0,1.0));
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float4 possex = mul(vPosTrans, g_mWorld);
  o.vPosSO = mul(possex, g_mView);
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  o.vNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  

  float3 tan = v.vTangent;
  float3 bin = v.vBiNormal;
  float2 tc = v.vTexcoord;
  /*
 // float3 nra = abs(v.vNormal);
  float3 nra = abs(normalResult);
  
  if (nra.x > nra.y && nra.x > nra.z) {
   // maxX = 1;
    tan = float3(0.0, 1.0, 0.0);
    bin = float3(0.0, 0.0, 1.0);
   // tc = v.vPosition.yz*0.1;
    tc = possex.yz*0.1;
  } else if (nra.y > nra.x && nra.y > nra.z) {
   // maxY = 1;
    tan = float3(1.0, 0.0, 0.0);
    bin = float3(0.0, 0.0, 1.0);
    // tc = v.vPosition.xz*0.1;
    tc = possex.xz*0.1;
  } else {
    // maxZ = 1;
    tan = float3(1.0, 0.0, 0.0);
    bin = float3(0.0, 1.0, 0.0);
    // tc = v.vPosition.xy*0.1;
    tc = possex.xy*0.1;
  }
  */
  normalResult = mul(tan, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  normalResult = mul(bin, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
      
  o.vTexcoord = tc*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = tc*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = tc*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}

float zFar = 10000.0;
float zNear = 1.0;

float4 getPointV(float4 vPosSS, float depthV) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV-clipA);
  float4 pointV = float4(vPosSS.x*4.0/3.0, vPosSS.y*3.0/4.0, 1.0, 0.0)*pointDist;  
  return pointV;
}

MRT_OUT ps_deferred_draw_march( VS_OUTPUT_BASIC_KO In ) {
  MRT_OUT o=(MRT_OUT)0;

    
  float4 rayTan;

  float4 ray = In.vPosSO/In.vPosSO.z;
   
  rayTan.x = dot((In.vTangent), ray);
  rayTan.y = dot((In.vBiNormal), ray);
  rayTan.z = -dot((In.vNormal), ray);
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
  float2 tc = In.vTexcoord;
  
  float hd = 0.0;
  float steps = 16.0f;
  int onceIn = 0;
  float deptho = 1.0; // g_march_depth; //*rayTan.z;
  float dir = 1.0;
  for (int i=0; i<steps; i++) {
    tc += rayTan.xy*deptho*dir/steps*0.1*g_heightIntensity/rayTan.z;
    hd += g_march_depth*deptho*dir/steps;
    float hn = 1.0-tex2D(smHeight, tc).g;
    height = hn;
    if (hd > hn) {
      onceIn = 1;
	}
	if (onceIn) {
  	 // rayTan.xy *= 0.75;
	  deptho *= 0.75;
	  if (hd > hn) {
	    dir = -1.0;
	  } else {
	    dir = 1.0;
	  }
	}
  }
  tc += rayTan.xy*0.01;
  
 // if (tc.x < 0.01 || tc.x > 0.99 || tc.y > -0.01 || tc.y < -0.99) {
 //   discard;
 // }
   
  // float2 tc = In.vTexcoord+rayTan.xy*(0.04*height-0.02)*g_heightIntensity;
 
  //tc = ray.xy;
 
  float4 ort2 = tex2D(smDiffuse, tc)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
 // o.rt2.xyz = ray.xyz;
  
  if (o.rt2.a < 0.005)
    discard;  
  
 // o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  bumpe.xy = -height_func_march(tc);
  bumpe = bumpe*10.0*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z+0.04*height*g_heightIntensity) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  
 // o.rt3.z = 0.0;  
  
  return o;
}

technique march {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_march( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_march( );
    }
}
