

struct MRT_OUT {
  float4 rt0 : COLOR0; // depth
  float4 rt1 : COLOR1; // normal
  float4 rt2 : COLOR2; // diffuse
  float4 rt3 : COLOR3; // ambspec
};


float2 height_func_bump(float2 p) {
   float2 resx = float2(1.0/512.0, 0.0);
   float2 resy = float2(0.0, 1.0/512.0);
   float2 result = 0;
   result.x = tex2D(smHeight, p+resx).g-tex2D(smHeight, p-resx).g;
   result.y = tex2D(smHeight, p+resy).g-tex2D(smHeight, p-resy).g;
   return result;
}

MRT_OUT ps_deferred_draw_bump( VS_OUTPUT_BASIC In ) {
  MRT_OUT o=(MRT_OUT)0;
 
 
   float4 ort2 = tex2D(smDiffuse, In.vTexcoord)*g_materialDiffuse;
   ort2.xyz *= g_diffuseIntensity;
   o.rt2 = ort2;
  
  if (o.rt2.a < 0.005)
    discard;
    
  float4 bumpe = 0;
 
  bumpe.xy = height_func_bump(In.vTexcoordHS.xy);
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = In.vPosSS.z / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, In.vTexcoordHS.zw).g*g_specularIntensity;
  
  o.rt3.z = 0.0;  
  
  return o;
}

technique bump {
    pass P0 {          
        VertexShader = compile vs_2_a vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_bump( );
    }
}
