samplerCUBE SpecSampler : register(s0);
samplerCUBE PhongSampler : register(s1);
samplerCUBE DiffSampler : register(s2);
sampler2D TextureSampler : register(s3);

struct VS_IN
{
    float3 Position	: POSITION;
    float3 Normal	: NORMAL;
    float2 UV		: TEXCOORD0;
};

struct VS_OUT
{
    float4 HPosition	: POSITION;
    float2 TexCoord	: TEXCOORD0;
    float3 WorldNormal	: TEXCOORD1;
    float3 WorldView	: TEXCOORD2;
};


VS_OUT VS(VS_IN i,uniform float4x4 matWorldIT,uniform float4x4 matWorld,uniform float3 CamPos, uniform float4x4 matWVP)
{
    VS_OUT o;
    o.WorldNormal = mul(matWorld,i.Normal).xyz;
    float4 Po = float4(i.Position,1);
    float3 Pw = mul(matWorld,Po).xyz;
    o.TexCoord = i.UV;
    o.WorldView = normalize(CamPos - Pw);
    o.HPosition = mul(matWVP, Po);
    return o;
}

float4 PS(VS_OUT i,uniform float SpecIntensity,uniform float PhongIntensity,uniform float DiffIntensity,uniform float4 SurfColor) : COLOR 
{
    float3 specColor = float3(0,0,0);
    float3 phongColor = float3(0,0,0);
    float3 diffColor = float3(0,0,0);
	
    float3 Nn = normalize(i.WorldNormal);
    float3 Vn = normalize(i.WorldView);

    float3 reflVect = -reflect(Vn,Nn);
    
    //reflective lookups for specular contributions
    specColor = texCUBE(SpecSampler,reflVect).xyz*SpecIntensity;
    phongColor = texCUBE(PhongSampler,reflVect).xyz*PhongIntensity;
    
    //diffuse lookup is in normal direction
    diffColor = texCUBE(DiffSampler,Nn).xyz*DiffIntensity;
    
    float4 result = float4(specColor+SurfColor * (phongColor+diffColor), SurfColor.a);
	
	/*if (result.r < 0.5)
		result.r *= SurfColor.r;
	else
		result.r += SurfColor.r;
		
	if (result.g < 0.5)
		result.g *= SurfColor.g;
	else
		result.g += SurfColor.g;

	if (result.b < 0.5)
		result.b *= SurfColor.b;
	else
		result.b += SurfColor.b;		*/
    
	/*float4 texColor = tex2D(TextureSampler, i.TexCoord);
	
	result.r = result.r / 4.0 + ( result.r * (1.0-texColor.a) + texColor.r * texColor.a )*3.0/4.0;
	result.g = result.g / 4.0 + ( result.g * (1.0-texColor.a) + texColor.g * texColor.a )*3.0/4.0;
	result.b = result.b / 4.0 + ( result.b * (1.0-texColor.a) + texColor.b * texColor.a )*3.0/4.0;
	result.a = 0.2;*/
	
	/*if( texColor.a == 1.0 )
	{
		result = texColor;
		result.a = 0.5;
	}*/
	//float alpha = texColor.a;
	//result = result * (1.0-alpha) + texColor * alpha;
	//result = (result + texColor)/2.0;
	
    return result;
}