uniform sampler2D tex;
uniform float voima;
uniform float freq;
uniform float time;
uniform vec3 lpos;

void main(void) {
	vec2 texcoord = gl_TexCoord[0].xy;
	vec4 pier = texture2D(tex, texcoord);
	vec3 pos = pier.rgb; 
	vec3 pos2;
	float life=pier.a;
	float velo=1.0/length(pos)*(1.0/(life+(sin(pos.z)*0.01+0.02)));

  pos2.x = pos.x+sin(sin(pos.y*0.3127*freq+time*0.831+sin(pos.z*3.672*freq-time*0.512)*0.1))*voima;
  pos2.y = pos.y+sin(sin(pos.z*0.4824*freq-time*0.827+sin(pos.x*1.927*freq+time*0.672)*0.1))*voima;
  pos2.z = pos.z+sin(sin(pos.x*0.3761*freq+time*0.712+sin(pos.y*3.662*freq-time*0.278)*0.1))*voima;
  pos2 *= 1.0+velo*voima*length(pos2-pos)*0.5;
  
  life=life+voima*0.01;
  if (life>(1.0+sin(pos.z)*0.1) || length(pos)>1024.0) {
    pos2 = vec3(sin(pos.x*2.412+time*3.124), sin(pos.y*3.823+time*5.82143), sin(pos.z*6.421+time*2.8324));
    pos2 = normalize(pos2)*10.0;
    life=0.0;
  }
  
  gl_FragColor = vec4(pos2, life);
}
