package org.shiftone.jrat.util.time;

import org.shiftone.jrat.core.Settings;
import org.shiftone.jrat.util.log.Logger;

/**
 * @author $Author: jeffdrost $
 * @version $Revision: 1.9 $
 */
public class Clock {

	private static final Logger LOG = Logger.getLogger(Clock.class);
	private static final Movement MOVEMENT;
	private static final Class[] NOARG_TYPES = {};
	static {
		MOVEMENT = createBestAvalibleMovement();
	}

	private static Movement createBestAvalibleMovement() {

		if (Settings.isNanoSecondTimingEnabled()) {
			LOG.info("trying to use nanosecond timing resolution");
			try {
				Class systemClass = System.class;
				systemClass.getMethod("nanoTime", NOARG_TYPES);
				LOG.info("System.nanoTime() is available");
				return new SystemNanoTimeMovement();
			} catch (Throwable e) {
				LOG.debug("System.nanoTime() is not available");
			}
			try {
				Class perfClass = Class.forName("sun.misc.Perf");
				perfClass.getMethod("highResCounter", NOARG_TYPES);
				perfClass.getMethod("highResFrequency", NOARG_TYPES);
				LOG.info("sun.misc.Perf.highResCounter() and sun.misc.Perf.highResFrequency() are available");
				return new SunMiscPerfMovement();
			} catch (Throwable e) {
				LOG.debug("sun.misc.Perf timing is not available");
			}
		}
		LOG.debug("using System.currentTimeNanos() for timing");
		return new SystemCurrentTimeMillisMovement();
	}

	public static long currentTimeNanos() {

		return MOVEMENT.currentTimeNanos();
	}

	public static String getStrategyText() {

		return MOVEMENT.toString();
	}
}
