/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;

public class GBLayout {
    int _x;
    int _y;
    private Container _container;
    private GridBagConstraints _gbc = new GridBagConstraints();
    public static final int WEST = 17;
    public static final int EAST = 13;
    public static final int CENTER = 10;
    public static final int NORTH = 11;
    public static final int NORTHWEST = 18;
    public static final int NORTHEAST = 12;
    public static final int SOUTH = 15;
    public static final int SOUTHWEST = 16;
    public static final int SOUTHEAST = 14;
    public static final int RELATIVE = -1;
    public static final int REMAINDER = 0;
    private static final GBLayout gbLayout = new GBLayout();
    public static final GBDimensions DEFAULT_DIMENSIONS = gbLayout.new GBDimensions();
    public static final GBWeights DEFAULT_WEIGHTS = gbLayout.new GBWeights();
    public static final GBPadding DEFAULT_PADDING = gbLayout.new GBPadding();
    public static final Insets DEFAULT_INSETS = new Insets(5, 5, 5, 5);
    public static final int DEFAULT_ANCHOR = 10;

    public GBLayout(Container c) {
        this();
        this.setContainer(c);
    }

    private GBLayout() {
        this.initialise();
    }

    public static void centerOnScreen(Component c) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (d.width - c.getWidth()) / 2;
        int height = (d.height - c.getHeight()) / 2;
        c.setLocation(width, height);
    }

    public void initialise() {
        this._x = 0;
        this._y = 0;
        this.setContainer(null);
    }

    public void addComponent(Component comp) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, DEFAULT_PADDING, DEFAULT_INSETS, 10, false);
    }

    public void addComponent(Component comp, Insets insets) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, DEFAULT_PADDING, insets, 10, false);
    }

    public void addComponent(Component comp, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, DEFAULT_PADDING, DEFAULT_INSETS, 10, lastInRow);
    }

    public void addComponent(Component comp, Insets insets, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, DEFAULT_PADDING, insets, 10, lastInRow);
    }

    public void addComponent(Component comp, int anchor, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, DEFAULT_PADDING, DEFAULT_INSETS, anchor, lastInRow);
    }

    public void addComponent(Component comp, Insets insets, int anchor, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, DEFAULT_PADDING, insets, anchor, lastInRow);
    }

    public void addComponent(Component comp, int anchor) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, DEFAULT_PADDING, DEFAULT_INSETS, anchor, false);
    }

    public void addComponent(Component comp, Insets insets, int anchor) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, DEFAULT_PADDING, insets, anchor, false);
    }

    public void addComponent(Component comp, GBDimensions dimensions, int anchor, boolean lastInRow) {
        this.addComponent(comp, dimensions, DEFAULT_WEIGHTS, DEFAULT_PADDING, DEFAULT_INSETS, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBDimensions dimensions, Insets insets, int anchor, boolean lastInRow) {
        this.addComponent(comp, dimensions, DEFAULT_WEIGHTS, DEFAULT_PADDING, insets, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBPadding padding, int anchor, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, padding, DEFAULT_INSETS, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBPadding padding, Insets insets, int anchor, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, DEFAULT_WEIGHTS, padding, insets, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBDimensions dimensions, GBWeights weights, int anchor, boolean lastInRow) {
        this.addComponent(comp, dimensions, weights, DEFAULT_PADDING, DEFAULT_INSETS, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBDimensions dimensions, GBWeights weights, Insets insets, int anchor, boolean lastInRow) {
        this.addComponent(comp, dimensions, weights, DEFAULT_PADDING, insets, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBWeights weights, int anchor, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, weights, DEFAULT_PADDING, DEFAULT_INSETS, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBWeights weights, Insets insets, int anchor, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, weights, DEFAULT_PADDING, insets, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBDimensions dimensions, GBWeights weights, GBPadding padding, int anchor, boolean lastInRow) {
        this.addComponent(comp, dimensions, weights, padding, DEFAULT_INSETS, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBDimensions dimensions, GBPadding padding, int anchor, boolean lastInRow) {
        this.addComponent(comp, dimensions, DEFAULT_WEIGHTS, padding, DEFAULT_INSETS, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBDimensions dimensions, GBPadding padding, Insets insets, int anchor, boolean lastInRow) {
        this.addComponent(comp, dimensions, DEFAULT_WEIGHTS, padding, insets, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBWeights weights, GBPadding padding, int anchor, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, weights, padding, DEFAULT_INSETS, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBWeights weights, GBPadding padding, Insets insets, int anchor, boolean lastInRow) {
        this.addComponent(comp, DEFAULT_DIMENSIONS, weights, padding, insets, anchor, lastInRow);
    }

    public void addComponent(Component comp, GBDimensions dimensions, GBWeights weights, GBPadding padding, Insets insets, int anchor, boolean lastInRow) {
        block0: {
            this.getGbc().gridx = this._x++;
            this.getGbc().gridy = this._y++;
            this.getGbc().anchor = anchor;
            this.getGbc().gridwidth = dimensions.getWidth();
            this.getGbc().gridheight = dimensions.getHeight();
            this.getGbc().weightx = weights.getWeightX();
            this.getGbc().weighty = weights.getWeightY();
            this.getGbc().ipadx = padding.getIPadX();
            this.getGbc().ipady = padding.getIPadY();
            this.getGbc().insets = insets;
            this.getContainer().add(comp, this.getGbc());
            if (!lastInRow) break block0;
            this._x = 0;
        }
    }

    public Container getContainer() {
        return this._container;
    }

    public void setContainer(Container container) {
        this._container = container;
        if (container != null) {
            container.setLayout(new GridBagLayout());
        }
    }

    public GridBagConstraints getGbc() {
        return this._gbc;
    }

    public void setGbc(GridBagConstraints constraints) {
        this._gbc = constraints;
    }

    public Insets getInsets(int top, int left, int bottom, int right) {
        return new Insets(top, left, bottom, right);
    }

    public GBWeights getWeights(int weightx, int weighty) {
        return new GBWeights(weightx, weighty);
    }

    public GBDimensions getDimensions(int width, int height) {
        return new GBDimensions(width, height);
    }

    public GBPadding getPadding(int ipadx, int ipady) {
        return new GBPadding(ipadx, ipady);
    }

    public abstract class GBInts {
        int one;
        int two;

        public GBInts() {
            this(1, 1);
        }

        public GBInts(int one, int two) {
            this.setOne(one);
            this.setTwo(two);
        }

        protected int getOne() {
            return this.one;
        }

        protected void setOne(int one) {
            this.one = one;
        }

        protected int getTwo() {
            return this.two;
        }

        protected void setTwo(int two) {
            this.two = two;
        }
    }

    public class GBDimensions
    extends GBInts {
        public GBDimensions() {
        }

        public GBDimensions(int width, int height) {
            super(width, height);
        }

        public int getWidth() {
            return this.getOne();
        }

        public void setWidth(int width) {
            this.setOne(width);
        }

        public int getHeight() {
            return this.getTwo();
        }

        public void setHeight(int height) {
            this.setTwo(height);
        }
    }

    public class GBWeights
    extends GBInts {
        public GBWeights() {
            super(0, 0);
        }

        public GBWeights(int weightx, int weighty) {
            super(weightx, weighty);
        }

        public int getWeightX() {
            return this.getOne();
        }

        public void setWeightX(int weightx) {
            this.setOne(weightx);
        }

        public int getWeightY() {
            return this.getTwo();
        }

        public void setWeightY(int weighty) {
            this.setTwo(weighty);
        }
    }

    public class GBPadding
    extends GBInts {
        public GBPadding() {
            super(0, 0);
        }

        public GBPadding(int ipadx, int ipady) {
            super(ipadx, ipady);
        }

        public int getIPadX() {
            return this.getOne();
        }

        public void setIPadX(int ipadx) {
            this.setOne(ipadx);
        }

        public int getIPadY() {
            return this.getTwo();
        }

        public void setIPadY(int ipady) {
            this.setTwo(ipady);
        }
    }
}

