/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jogg;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.sourceforge.jogg.SongData;
import org.sourceforge.jogg.layout.GBLayout;

public class DataPanel
extends JPanel {
    private JTable _table;
    private SongData[] _rows;
    private static final String[][] BLANK_DATA = new String[20][SongData.COLUMN_NAMES.length];

    public DataPanel() {
        this.initialise();
    }

    public SongData getRow(int index) {
        SongData row;
        if (this._rows != null) {
            row = this._rows[index];
        } else {
            row = new SongData();
            row.setFile(this.getFile(index));
            row.setArtist(this.getArtist(index));
            row.setSongTitle(this.getTitle(index));
            row.setAlbum(this.getAlbum(index));
        }
        return row;
    }

    public void setRow(SongData row, int index) {
        this.setFile(row.hasFile() ? row.getFile() : "", index);
        this.setTitle(row.hasSongTitle() ? row.getSongTitle() : "", index);
        this.setArtist(row.hasArtist() ? row.getArtist() : "", index);
        this.setAlbum(row.hasAlbum() ? row.getAlbum() : "", index);
    }

    public void removeAll() {
        this._rows = null;
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < SongData.COLUMN_NAMES.length) {
                this._table.setValueAt("", i, j);
                ++j;
            }
            ++i;
        }
    }

    public int getRowCount() {
        return this._table.getRowCount();
    }

    public boolean isSelected(int index) {
        return this._table.isRowSelected(index);
    }

    public int getSelectedRowCount() {
        return this._table.getSelectedRowCount();
    }

    public int[] getSelectedRowIndex() {
        return this._table.getSelectedRows();
    }

    public void addListSelectionListener(ListSelectionListener e) {
        this._table.getSelectionModel().addListSelectionListener(e);
    }

    public SongData[] getAllRows() {
        if (this._rows == null) {
            this._table.setRowSelectionInterval(0, this.getRowCount() - 1);
            this._rows = this.getSelectedRows();
        }
        this._table.setRowSelectionInterval(0, 0);
        return this._rows;
    }

    public void setAllRows(SongData[] rows) {
        this.removeAll();
        int i = 0;
        while (i < rows.length) {
            this.setRow(rows[i], i);
            ++i;
        }
        this._rows = rows;
    }

    public void addRow(SongData row) {
        this.setRow(row, this.findNextRow());
    }

    private int findNextRow() {
        int blank = -1;
        int i = 0;
        while (i < this._table.getRowCount()) {
            if (this.getFile(i).trim().length() == 0 && this.getArtist(i).trim().length() == 0 && this.getTitle(i).trim().length() == 0 && this.getAlbum(i).trim().length() == 0) {
                blank = i;
                break;
            }
            ++i;
        }
        if (blank == -1) {
            blank = this._table.getRowCount() + 1;
        }
        return blank;
    }

    public SongData[] getSelectedRows() {
        int[] rows = this.getSelectedRowIndex();
        ArrayList<SongData> rList = new ArrayList<SongData>();
        int i = 0;
        while (i < rows.length) {
            if (this.getFile(rows[i]) != null && this.getFile(rows[i]).length() > 0) {
                rList.add(this.getRow(rows[i]));
            }
            ++i;
        }
        SongData[] data = new SongData[rList.size()];
        int i2 = 0;
        while (i2 < rList.size()) {
            data[i2] = (SongData)rList.get(i2);
            ++i2;
        }
        return data;
    }

    private void initialise() {
        this._table = new JTable();
        this._table.setSelectionMode(2);
        this._table.setColumnSelectionAllowed(false);
        this._table.setShowHorizontalLines(false);
        this._table.setModel(this.getTableModel());
        this.layoutComponents();
    }

    private DefaultTableModel getTableModel() {
        return new DefaultTableModel(BLANK_DATA, SongData.COLUMN_NAMES){

            public boolean isCellEditable(int row, int col) {
                return col != 0;
            }
        };
    }

    private void layoutComponents() {
        GBLayout layout = new GBLayout(this);
        layout.addComponent((Component)new JScrollPane(this._table), true);
    }

    private void setFile(String name, int index) {
        this.setData(name, index, 0);
    }

    private void setTitle(String title, int index) {
        this.setData(title, index, 1);
    }

    private void setArtist(String artist, int index) {
        this.setData(artist, index, 2);
    }

    private void setAlbum(String album, int index) {
        this.setData(album, index, 3);
    }

    private void setData(String text, int row, int col) {
        this._table.setValueAt(text, row, col);
    }

    private String getFile(int index) {
        return this.getData(index, 0);
    }

    private String getTitle(int index) {
        return this.getData(index, 1);
    }

    private String getArtist(int index) {
        return this.getData(index, 2);
    }

    private String getAlbum(int index) {
        return this.getData(index, 3);
    }

    private String getData(int row, int col) {
        return (String)this._table.getValueAt(row, col);
    }
}

