/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opencl;

import java.nio.ByteBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL11;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLDeviceCapabilities;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLEventCallback;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLMemObjectDestructorCallback;
import org.lwjgl.opencl.CLNativeKernel;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.api.CLBufferRegion;

public class HelloOpenCL {
    protected static void execute() {
        try {
            CL.create();
            List platforms = CLPlatform.getPlatforms();
            if (platforms == null) {
                throw new RuntimeException("No OpenCL platforms found.");
            }
            for (CLPlatform platform : platforms) {
                System.out.println("\n-------------------------");
                System.out.println("NEW PLATFORM: " + platform.getPointer());
                System.out.println(CLCapabilities.getPlatformCapabilities((CLPlatform)platform));
                System.out.println("-------------------------");
                HelloOpenCL.printPlatformInfo(platform, "CL_PLATFORM_PROFILE", 2304);
                HelloOpenCL.printPlatformInfo(platform, "CL_PLATFORM_VERSION", 2305);
                HelloOpenCL.printPlatformInfo(platform, "CL_PLATFORM_NAME", 2306);
                HelloOpenCL.printPlatformInfo(platform, "CL_PLATFORM_VENDOR", 2307);
                HelloOpenCL.printPlatformInfo(platform, "CL_PLATFORM_EXTENSIONS", 2308);
                System.out.println("");
                PointerBuffer ctxProps = BufferUtils.createPointerBuffer((int)3);
                ctxProps.put(4228L).put(platform.getPointer()).put(0L).flip();
                List devices = platform.getDevices(-1);
                for (CLDevice device : devices) {
                    long exec_caps;
                    CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities((CLDevice)device);
                    System.out.println("\n\tNEW DEVICE: " + device.getPointer());
                    System.out.println(caps);
                    System.out.println("\t-------------------------");
                    System.out.println("\tCL_DEVICE_TYPE = " + device.getInfoInt(4096));
                    System.out.println("\tCL_DEVICE_VENDOR_ID = " + device.getInfoInt(4097));
                    System.out.println("\tCL_DEVICE_MAX_COMPUTE_UNITS = " + device.getInfoInt(4098));
                    System.out.println("\tCL_DEVICE_MAX_WORK_ITEM_DIMENSIONS = " + device.getInfoInt(4099));
                    System.out.println("\tCL_DEVICE_MAX_WORK_GROUP_SIZE = " + device.getInfoSize(4100));
                    System.out.println("\tCL_DEVICE_MAX_CLOCK_FREQUENCY = " + device.getInfoInt(4108));
                    System.out.println("\tCL_DEVICE_ADDRESS_BITS = " + device.getInfoInt(4109));
                    System.out.println("\tCL_DEVICE_AVAILABLE = " + device.getInfoBoolean(4135));
                    System.out.println("\tCL_DEVICE_COMPILER_AVAILABLE = " + device.getInfoBoolean(4136));
                    HelloOpenCL.printDeviceInfo(device, "CL_DEVICE_NAME", 4139);
                    HelloOpenCL.printDeviceInfo(device, "CL_DEVICE_VENDOR", 4140);
                    HelloOpenCL.printDeviceInfo(device, "CL_DRIVER_VERSION", 4141);
                    HelloOpenCL.printDeviceInfo(device, "CL_DEVICE_PROFILE", 4142);
                    HelloOpenCL.printDeviceInfo(device, "CL_DEVICE_VERSION", 4143);
                    HelloOpenCL.printDeviceInfo(device, "CL_DEVICE_EXTENSIONS", 4144);
                    if (caps.OpenCL11) {
                        HelloOpenCL.printDeviceInfo(device, "CL_DEVICE_OPENCL_C_VERSION", 4157);
                    }
                    CLContext context = CL10.clCreateContext((PointerBuffer)ctxProps, (CLDevice)device, (CLContextCallback)new CLContextCallback(){

                        protected void handleMessage(String errinfo, ByteBuffer private_info) {
                            System.out.println("IN CLContextCallback :: " + errinfo);
                        }
                    }, null);
                    CLMem buffer = CL10.clCreateBuffer((CLContext)context, (long)4L, (long)128L, null);
                    if (caps.OpenCL11) {
                        CL11.clSetMemObjectDestructorCallback((CLMem)buffer, (CLMemObjectDestructorCallback)new CLMemObjectDestructorCallback(){

                            protected void handleMessage(long memobj) {
                                System.out.println("FIRST Buffer destructed: " + memobj);
                            }
                        });
                        CL11.clSetMemObjectDestructorCallback((CLMem)buffer, (CLMemObjectDestructorCallback)new CLMemObjectDestructorCallback(){

                            protected void handleMessage(long memobj) {
                                System.out.println("SECOND Buffer destructed: " + memobj);
                            }
                        });
                    }
                    if (caps.OpenCL11) {
                        CLMem subbuffer = buffer.createSubBuffer(4L, 4640, new CLBufferRegion(0, 64), null);
                        CL11.clSetMemObjectDestructorCallback((CLMem)subbuffer, (CLMemObjectDestructorCallback)new CLMemObjectDestructorCallback(){

                            protected void handleMessage(long memobj) {
                                System.out.println("Sub Buffer destructed: " + memobj);
                            }
                        });
                    }
                    CL10.clRetainMemObject((CLMem)buffer);
                    if (LWJGLUtil.getPlatform() != 2 && ((exec_caps = device.getInfoLong(4137)) & 2L) == 2L) {
                        System.out.println("-TRYING TO EXEC NATIVE KERNEL-");
                        CLCommandQueue queue = CL10.clCreateCommandQueue((CLContext)context, (CLDevice)device, (long)0L, null);
                        PointerBuffer ev = BufferUtils.createPointerBuffer((int)1);
                        CL10.clEnqueueNativeKernel((CLCommandQueue)queue, (CLNativeKernel)new CLNativeKernel(){

                            protected void execute(ByteBuffer[] memobjs) {
                                System.out.println("\tmemobjs.length = " + memobjs.length);
                                for (int k = 0; k < memobjs.length; ++k) {
                                    System.out.println("\tmemobjs[" + k + "].remaining() = " + memobjs[k].remaining());
                                    for (int l = memobjs[k].position(); l < memobjs[k].limit(); ++l) {
                                        memobjs[k].put(l, (byte)l);
                                    }
                                }
                                System.out.println("\tNative kernel done.");
                            }
                        }, (CLMem[])new CLMem[]{buffer}, (long[])new long[]{128L}, null, (PointerBuffer)ev);
                        CLEvent e = queue.getCLEvent(ev.get(0));
                        CL11.clSetEventCallback((CLEvent)e, (int)0, (CLEventCallback)new CLEventCallback(){

                            protected void handleMessage(CLEvent event, int event_command_exec_status) {
                                System.out.println("\t\tEvent callback status: " + HelloOpenCL.getEventStatusName(event_command_exec_status));
                            }
                        });
                        int status = e.getInfoInt(4563);
                        System.out.println("NATIVE KERNEL STATUS: " + HelloOpenCL.getEventStatusName(status));
                        CL10.clFlush((CLCommandQueue)queue);
                        do {
                            int newStatus;
                            if ((newStatus = e.getInfoInt(4563)) == status) continue;
                            status = newStatus;
                            System.out.println("NATIVE KERNEL STATUS: " + HelloOpenCL.getEventStatusName(status));
                        } while (status != 0);
                        CL10.clReleaseEvent((CLEvent)e);
                    }
                    CL10.clReleaseMemObject((CLMem)buffer);
                    CL10.clReleaseContext((CLContext)context);
                }
            }
        }
        catch (LWJGLException le) {
            HelloOpenCL.die("Init", le.getMessage());
        }
        CL.destroy();
    }

    private static void printPlatformInfo(CLPlatform platform, String param_name, int param) {
        System.out.println("\t" + param_name + " = " + platform.getInfoString(param));
    }

    private static void printDeviceInfo(CLDevice device, String param_name, int param) {
        System.out.println("\t" + param_name + " = " + device.getInfoString(param));
    }

    private static String getEventStatusName(int status) {
        switch (status) {
            case 3: {
                return "CL_QUEUED";
            }
            case 2: {
                return "CL_SUBMITTED";
            }
            case 1: {
                return "CL_RUNNING";
            }
        }
        return "CL_COMPLETE";
    }

    private static void die(String kind, String description) {
        System.out.println(kind + " error " + description + " occured");
    }

    public static void main(String[] args) {
        new HelloOpenCL();
        HelloOpenCL.execute();
    }
}

