Player@ cPlayer(Asset@ p)	// This function casts an Asset@ to a @Player
{
	Scripted @s = p.GetScripted();
	return cast<Player>(s);
}

class Player : Scripted, Actor
{
	Asset @asset;
	Peer @myPeer;
	
	// Input processing variables
	float speed;
	array<InputData@> inputsToProcess;
	array<vec2> pointsToGo;
	
	Timer keyboardInputTimer;
	Timer inputProcessTimer;
	Timer shootCooldown;
	Timer alphaTimer;
	
	vec2 moveTo;
	
	bool visible;
	int16 alpha;
	
	bool wasMoving;
	int health;
	uint64 guid;
	uint elapsed;
	
	void Hide()
	{
		if (visible == true && alpha < 255 && alphaTimer.GetElapsedTime() > 50)
		{
			if (alpha < 30)
			alpha += 2;
			else
			alpha += 10;
			
			if (alpha > 255)
			alpha = 255;
			asset.SetColor(255,255,255,alpha);
			alphaTimer.Reset();
		}
		else if (visible == false && alpha > 0 && alphaTimer.GetElapsedTime() > 50)
		{
			alpha -= 30;
			if (alpha < 0)
			alpha = 0;
			asset.SetColor(255,255,255,alpha);
			alphaTimer.Reset();
		}
	}
	
	void Shoot()
	{
		// Right mouse button should be pressed
		if (!input.IsMouseButtonDown(MouseButton::Left))
			return;
		if (shootCooldown.GetElapsedTime() < 250)
			return;
		vec2 mousePos(input.GetMRX(), input.GetMRY());
		vec2 direction = mousePos - asset.GetPosition();
		vec2 startPos = asset.GetPosition();// + vec2(direction.x / 3, direction.y / 3);
		// Parameters : Shape name, starting position, the script class the Asset implements - Bullet in this case.
		Bullet@ bullet = cBullet(CreateAsset("Bullet", startPos, "Bullet"));
		bullet.Shoot(direction, this);
		
		BitStream stream;
		stream.Write(uint8(NetworkMessages::ID_BULLET_FIRED));
		stream.Write(myPeer.guid);
		stream.Write(startPos.x);
		stream.Write(startPos.y);
		stream.Write(mousePos.x);
		stream.Write(mousePos.y);
		
		stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE,3,true);
		
		shootCooldown.Reset();
	}
	void SetAsset(Asset@ with)
	{
		@asset = @with;
		asset.SetLDamping(3.0f);
		asset.SetADamping(9.0f);
		speed = 3.0f;
		moveTo = vec2(0,0);
		wasMoving = false;
		health = 100;
		elapsed = 0;
		visible = true;
		alpha = 255;
	}
	void Move()
	{
		if (keyboardInputTimer.GetElapsedTime() >= 50)
		{
			elapsed = keyboardInputTimer.GetElapsedTime();
			keyboardInputTimer.Reset();
		}
		/*else if (keyboardInputTimer.GetElapsedTime() >= elapsed)
		{
			elapsed = keyboardInputTimer.GetElapsedTime();
			print(elapsed);
			print("\n");
			keyboardInputTimer.Reset();		
		}*/
		else
			return;
		if (wasMoving)	// Send input data packet with arrived position - This means 100 ms + ping delay between the client and server.
		{
		
			InputData iData;
			iData.direction = moveTo;
			iData.direction.Normalize();
			iData.positionArrived = asset.GetPosition();
			iData.miliseconds = elapsed;
			
			inputsToProcess.insertLast(iData);
		}
		wasMoving = false;
		
		//moveTo.Normalize();
		//moveTo *= speed;
		
		//asset.SetVelocity(moveTo.x, moveTo.y);
		moveTo = vec2(0,0);
		if (input.IsKeyDown(Code::W))
		{
			moveTo.y = -1;
			wasMoving = true;
		}
		else if(input.IsKeyDown(Code::S))
		{
			moveTo.y = 1;
			wasMoving = true;
		}
		if (input.IsKeyDown(Code::D))
		{
			moveTo.x = 1;
			wasMoving = true;
		}
		else if (input.IsKeyDown(Code::A))
		{
			moveTo.x = -1;
			wasMoving = true;
		}
	}
	void PositionUpdate(vec2 update)
	{
		pointsToGo.insertLast(update);
	}
	void Wander()
	{
		asset.SetVelocity(0,0);
		if (pointsToGo.length() == 0)
		{
			return;
		}
		if (pointsToGo.length() > 2)
		speed = 9.0f;
		else
		speed = 3.0f;
		vec2 direction = pointsToGo[0] - asset.GetPosition();
		if (direction.LengthSq() > 0.01f)
		{
			direction.Normalize();
			asset.SetVelocity(direction.x * speed, direction.y * speed);
		}
		else
		{
			pointsToGo.removeAt(0);
		}
	}
	void ProcessInput()
	{
		if (inputsToProcess[0].miliseconds <= inputProcessTimer.GetElapsedTime())
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_PLAYER_INPUT));
			stream.WriteCompressed(inputsToProcess[0].miliseconds);
			stream.Write(inputsToProcess[0].direction.x);
			stream.Write(inputsToProcess[0].direction.y);
			stream.Write(asset.GetPosition().x);
			stream.Write(asset.GetPosition().y);
			
			stream.SendUA(PP::HIGH_PRIORITY, PR::UNRELIABLE, 1, true);
			inputsToProcess.removeAt(0);
			inputProcessTimer.Reset();
			asset.SetVelocity(0,0);
			
			if (inputsToProcess.length() > 2)
			{
			while (inputsToProcess.length() > 2) {
			inputsToProcess.removeAt(inputsToProcess.length() - 1); 
			//print("deleting " + myPeer.myTeam.teamName + "\n");
			}
			}
			
			return;
		}
		if (inputsToProcess.length() > 0)
		asset.SetVelocity(inputsToProcess[0].direction.x * speed, inputsToProcess[0].direction.y * speed);
	}
	void Update()
	{
		if (myPeer is game.myPeer)
		{
			Move();
			Shoot();
			if (inputsToProcess.length() > 0)
			{
				ProcessInput();
			}
			else
			inputProcessTimer.Reset();
		}
		else
		{
			Wander();
			Hide();
		}
	}
}