#include "player.as"

class Peer
{
	Player@ player;
	uint64 guid;
	Team @myTeam;
	string peerName;
	
	bool setupRequested;
	
	Peer()
	{
		@player = null;
		setupRequested = false;
	}
	void OnLoop()
	{
		//	Try - Sending all player positions in a fixed interval
		if (player.health <= 0)
		{
			@player.asset = null;
			@player = null;
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_PLAYER_DIED));
			stream.WriteCompressed(guid);
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
		}
	}
	
	void SetupPlayer(vec2 startPos, Team@ team)
	{
		@player = cPlayer(CreateAsset(team.shapeName, startPos, "Player"));
		@player.myPeer = this;
		@myTeam = @team;
	}
	
	void ProcessInputData(InputData@ iData)
	{
		/*BitStream stream;
		stream.Write(uint8(NetworkMessages::ID_SNAPSHOT));
		stream.Write(guid);
		stream.Write(iData.positionArrived.x);
		stream.Write(iData.positionArrived.y);
		stream.Send(guid, PP::HIGH_PRIORITY, PR::UNRELIABLE, 2, true);*/
		
		//updateTimer.Reset();
		
		iData.direction.Normalize();
		player.inputsToProcess.insertLast(iData);
	}
	~Peer()
	{
		@player.myPeer = null;
		@player.asset = null;
		@player = null;
	}
	//void InitPlayer()
}