Player@ cPlayer(Asset@ p)	// This function casts an Asset@ to a @Player
{
	Scripted @s = p.GetScripted();
	return cast<Player>(s);
}

class Player : Scripted, Actor
{
	Asset @asset;
	Peer @myPeer;
	
	// Input processing variables
	float speed;						// The speed of the player
	array<InputData@> inputsToCorrect;	// The inputs already processed - but waiting confirmation from the server
	array<vec2> pointsToGo;				// If this player is not controlled, these are the sampled points to interpolate between.
	
	Timer keyboardInputTimer;
	//Timer inputTimer;	// Default is 20 Hz.
	Timer shootCooldown;
	Timer alphaTimer;
	uint8 lastInputID;
	
	bool visible;
	int16 alpha;
	
	bool inputEntered;
	
	int health;
	uint64 guid;
	uint elapsed;
	
	Player()
	{
		speed = 3.0f;
		inputEntered = true;
		health = 100;
		elapsed = 0;
		visible = true;
		alpha = 255;
		lastInputID = 0;
	}
	
	void Hide()
	{
		if (visible == true && alpha < 255 && alphaTimer.GetElapsedTime() > 50)
		{
			if (alpha < 30)
			alpha += 2;
			else
			alpha += 10;
			
			if (alpha > 255)
			alpha = 255;
			asset.SetColor(255,255,255,alpha);
			alphaTimer.Reset();
		}
		else if (visible == false && alpha > 0 && alphaTimer.GetElapsedTime() > 50)
		{
			alpha -= 30;
			if (alpha < 0)
			alpha = 0;
			asset.SetColor(255,255,255,alpha);
			alphaTimer.Reset();
		}
	}
	
	void Shoot()
	{
		// Right mouse button should be pressed
		if (!input.IsMouseButtonDown(MouseButton::Left))
			return;
		if (shootCooldown.GetElapsedTime() < 250)
			return;
		vec2 mousePos(input.GetMRX(), input.GetMRY());
		vec2 direction = mousePos - asset.GetPosition();
		vec2 startPos = asset.GetPosition();// + vec2(direction.x / 3, direction.y / 3);
		// Parameters : Shape name, starting position, the script class the Asset implements - Bullet in this case.
		Bullet@ bullet = cBullet(CreateAsset("Bullet", startPos, "Bullet"));
		bullet.Shoot(direction, this);
		
		BitStream stream;
		stream.Write(uint8(NetworkMessages::ID_BULLET_FIRED));
		stream.Write(myPeer.guid);
		stream.Write(startPos.x);
		stream.Write(startPos.y);
		stream.Write(mousePos.x);
		stream.Write(mousePos.y);
		
		stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE,3,true);
		
		shootCooldown.Reset();
	}
	void SetAsset(Asset@ with)
	{
		@asset = @with;
		asset.SetLDamping(3.0f);
		asset.SetADamping(9.0f);
	}
	void InputSample()
	{	
		InputData inputData;
		
		//moveTo.Normalize();
		//moveTo *= speed;
		
		//asset.SetVelocity(moveTo.x, moveTo.y);
		if (input.IsKeyDown(Code::W))
		{
			inputData.vely = -1;
			inputEntered = true;
		}
		else if(input.IsKeyDown(Code::S))
		{
			inputData.vely = 1;
			inputEntered = true;
		}
		if (input.IsKeyDown(Code::D))
		{
			inputData.velx = 1;
			inputEntered = true;
		}
		else if (input.IsKeyDown(Code::A))
		{
			inputData.velx = -1;
			inputEntered = true;
		}
		
		if (lastInputID < 250)
			lastInputID++;
		else
			lastInputID = 0;
		
		inputData.id = lastInputID;
		ProcessInput(inputData);
	}
	void PositionUpdate(vec2 update)
	{
		pointsToGo.insertLast(update);
		//asset.SetPosition(update);
	}
	void Wander()
	{
		asset.SetVelocity(0,0);
		if (pointsToGo.length() == 0)
		{
			return;
		}
		if (pointsToGo.length() > 2)
		speed = 9.0f;
		else
		speed = 3.0f;
		vec2 direction = pointsToGo[0] - asset.GetPosition();
		if (direction.LengthSq() > 0.01f)
		{
			direction.Normalize();
			asset.SetVelocity(direction.x * speed, direction.y * speed);
		}
		else
		{
			pointsToGo.removeAt(0);
		}
	}
	void ProcessInput(InputData @inputData)
	{
		// Set the assets velocity
		vec2 velocity(0,0);
		velocity.x = inputData.velx;
		velocity.y = inputData.vely;
		
		velocity.Normalize();
		inputData.direction = velocity;
		if (velocity.LengthSq() == 0)
		{
			asset.SetVelocity(0, 0);
			return;
		}
		
		velocity *= speed;
		
		asset.SetVelocity(velocity);
		
		inputsToCorrect.insertLast(inputData);
		
		// Send this input to the server for processing and store it for correction
		
		BitStream stream;
		stream.Write(uint8(NetworkMessages::ID_PLAYER_INPUT));
		stream.WriteCompressed(inputData.id);
		stream.WriteCompressed(inputData.velx);
		stream.WriteCompressed(inputData.vely);
		stream.Write(asset.GetPosition().x);
		stream.Write(asset.GetPosition().y);
		stream.WriteCompressed(keyboardInputTimer.GetElapsedTime());
		stream.SendUA(PP::HIGH_PRIORITY, PR::UNRELIABLE, 1, true);
	}
	void ApplyCorrection(uint8 id, vec2 correction)
	{
		int beginIndex = -1;
		for (uint it = 0; it < inputsToCorrect.length(); it++)
		{
			if (inputsToCorrect[it].id == id) {
				beginIndex = it;
			}
		}
		if (beginIndex == -1)
			return;
		for (;beginIndex - 1 >= 0; beginIndex--)
		{
		// Try - Nullify the object handle
			inputsToCorrect.removeAt(beginIndex);
		}
		vec2 beginPos = inputsToCorrect[0].position;
		vec2 velocity(0,0);
		for (uint it = 0; it < inputsToCorrect.length(); it++)
		{
			velocity.x = inputsToCorrect[it].velx;
			velocity.y = inputsToCorrect[it].vely;
			velocity.Normalize();
			velocity *= speed * inputsToCorrect[it].miliseconds / 1000;
			
			beginPos += velocity;
		}
		if ((beginPos - correction).Length() > 0.2f) {	// Correct within a treshold 
			asset.SetPosition(correction);
			//print((beginPos - asset.GetPosition()).Length());
			//print("\n");
			}
			// Birden fazla yuklenmesin setler
		else
		{
			vec2 interpolation = (beginPos - correction);
			interpolation *=  0.5f;
			vec2 currentPosition = asset.GetPosition();
			currentPosition += (beginPos - correction);
			asset.SetPosition(currentPosition);
		}
			//asset.SetPosition(beginPos);
	}
	void Update()
	{
		if (myPeer.myTeam.teamName == "blue")
			speed = 5.0f;
		else
			speed = 3.0f;
		if (myPeer is game.myPeer)
		{
			if (keyboardInputTimer.GetElapsedTime() >= 50) {
				InputSample();
				keyboardInputTimer.Reset();
			}
			Shoot();
		}
		else
		{
			Wander();
			Hide();
		}
	}
}
void CorrectionReceive(uint8 MessageID, uint64 guid, BitStream bit)
{
	bit.IgnoreBytes(1);
	vec2 update;
	uint8 id;
	
	bit.ReadCompressed(id);
	bit.Read(update.x);
	bit.Read(update.y);
	
	game.myPeer.player.ApplyCorrection(id, update);
}
void PlayerUpdate(uint8 MessageID, uint64 guid, BitStream bit)
{
	bit.IgnoreBytes(1);
	uint peerCount;
	uint64 uGUID;
	vec2 update;
	
	bit.ReadCompressed(peerCount);
	for (uint it = 0; it < peerCount; it++)
	{
		bit.ReadCompressed(uGUID);
		bit.Read(update.x);
		bit.Read(update.y);
		//print(update.x);
		if (uGUID == game.myPeer.guid)
		{
			//game.myPeer.player.asset.SetPosition(update);
		}
		else
		{
			if (game.GetPeerByGUID(uGUID).player !is null)	// Just to make sure :)
			{
				game.GetPeerByGUID(uGUID).player.PositionUpdate(update);
			}
		}
	}
}

class InputData
{
	int8 velx;
	int8 vely;
	vec2 direction;		// Normalized, so that it's not calculated over and over again
	
	uint8 id;
	
	vec2 position;		// This is the beginning position or the arrived position after processing the input before this.
	uint miliseconds;	// The duration of the processing of the input before this.
	
	InputData()
	{
		/*up = false;
		down = false;
		left = false;
		right = false;*/
		velx = 0;
		vely = 0;
		
		miliseconds = 0;
		
	}
}