///SERVER
enum HideAndSeek_State
{
	ROUND_IN_PROGRESS = 1,
	ROUND_COUNTDOWN
}
class HideAndSeek
{	
	array<vec2> spawnPoints;	// For each team different
	
	uint8 state;
	
	// Timers
	Timer countdown;
	Timer infoTimer;
	string timerStr;
	uint roundTime;
	uint waitTime;
	
	uint width;
	uint height;
	
	HideAndSeek()
	{
		state = 0;
		timerStr = "";
		
		waitTime = 8000;
		roundTime = 60000;
		
		GetWindowDimensions(width,height);
	}
	void RoundBegin()
	{
		state = ROUND_IN_PROGRESS;
		BitStream stream;
		stream.Write(uint8(ID_ROUND_BEGIN));
		stream.WriteCompressed(roundTime);
		stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
	}
	void CountdownBeforeNewRound()
	{
		timerStr = "New round begins in: ";
		timerStr += (waitTime - countdown.GetElapsedTime()) / 1000;
		DrawGUIText( timerStr, vec2(width / 2 - 50, 0), 18);	
		if (countdown.GetElapsedTime() > waitTime)
		{
			countdown.Reset();
			RoundBegin();
		}
		
		if (infoTimer.GetElapsedTime() > 2000)
		{
			BitStream stream;
			stream.Write(uint8(ID_GAME_INFO));
			stream.Write(state);
			stream.WriteCompressed(waitTime - countdown.GetElapsedTime());
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
			infoTimer.Reset();
		}
	}
	void RoundEnd()
	{
		state = ROUND_COUNTDOWN;
		countdown.Reset();
		
		string endReport = "Players " ;
		for (uint it = 0; it < game.connectedPeers.length(); it++)
		{
			if (game.connectedPeers[it].player.marked) {
				endReport += game.connectedPeers[it].peerName;
				endReport += " ";
				}
		}
		endReport += "have lost the game!";
		
		BitStream stream;
		stream.Write(uint8(ID_ROUND_END));
		stream.WriteCompressed(waitTime);
		stream.WriteCompressed(endReport);
		stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
	}
	void Logic()	// Will make additions later
	{
		if (state == ROUND_IN_PROGRESS)
		{
			timerStr = "Round ends in: ";
			timerStr += (roundTime - countdown.GetElapsedTime()) / 1000;
			DrawGUIText( timerStr, vec2(width / 2 - 50, 0), 18);	

			if (infoTimer.GetElapsedTime() > 2000)
			{
				BitStream stream;
				stream.Write(uint8(ID_GAME_INFO));
				stream.Write(state);
				stream.WriteCompressed(roundTime - countdown.GetElapsedTime());
				stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
				infoTimer.Reset();
			}
			if (countdown.GetElapsedTime() > roundTime)
			{
				print("Round ending...\n");
				RoundEnd();
			}
		}
		else
			CountdownBeforeNewRound();
	}
	
	void InitSpawns()
	{
		vec2 spawnPos(0,0);
		for (uint t = 1; GetPoint(0,t, spawnPos); t++)
		{
			spawnPoints.insertLast(spawnPos);
		}
	}
}
class Game
{
	array<Peer@> connectedPeers;

	vec2 cameraMoveTo;
	Timer cameraDelta;
	float cameraSpeed;
	
	HideAndSeek mod;
	
	Timer updateTimer;
	Game()
	{
		cameraSpeed = 10.0f;
	}
	void CameraControls()
	{
		cameraMoveTo = vec2(0,0);
		if (input.IsKeyDown(Code::W))
			cameraMoveTo.y = -1;
		else if(input.IsKeyDown(Code::S))
			cameraMoveTo.y = 1;
		if (input.IsKeyDown(Code::D))
			cameraMoveTo.x = 1;
		else if (input.IsKeyDown(Code::A))
			cameraMoveTo.x = -1;
		if (cameraMoveTo.LengthSq() > 0)
		{
		cameraMoveTo.Normalize();
		cameraMoveTo *= cameraSpeed * cameraDelta.GetElapsedTime() / 1000;
		cameraMoveTo += GetCameraPos();
		SetCameraTransformCentered( cameraMoveTo, 0);
		}
		
		cameraDelta.Reset();
	}
	void ShowPlayerInfo()
	{
		string infoText;
		uint maxLength;
		infoText = "Players:\n";
		maxLength = infoText.length();
		
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			infoText += connectedPeers[t].peerName + "\n";
		}
		uint x;
		uint y;
		GetWindowDimensions(x,y);
		DrawGUIText(infoText, vec2(x - 100, 0), 18);
	}
	void OnLoop()
	{
		if (input.IsKeyDown(Code::Tab))
			ShowPlayerInfo();
		mod.Logic();
		DrawGUIText("Seek and Tag v0.3", vec2(0, 50), 18);
		CameraControls();
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			connectedPeers[t].OnLoop();
		}
		if (updateTimer.GetElapsedTime() > 100)
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_SNAPSHOT));
			uint peerCount = 0;
			// Checking whether all peers have a player
			for (uint t = 0; t < connectedPeers.length(); t++)
			{
				if (connectedPeers[t].player !is null)
					peerCount++;
			}
			stream.WriteCompressed(peerCount);
			for (uint it = 0; it < connectedPeers.length(); it++)
			{
				if (connectedPeers[it].player is null)	// Offensichtlich
					continue;
				stream.WriteCompressed(connectedPeers[it].guid);
				stream.Write(connectedPeers[it].player.asset.GetPosition().x);
				stream.Write(connectedPeers[it].player.asset.GetPosition().y);
			}
			stream.SendUA(PP::HIGH_PRIORITY, PR::UNRELIABLE, 2, true);
			updateTimer.Reset();
		}
	}
	
	Peer@ GetPeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
				return connectedPeers[t];
		}
		return null;
	}
	
	void RemovePeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
			{
				@connectedPeers[t].player.myPeer = null;
				@connectedPeers[t] = null;
				connectedPeers.removeAt(t);
				return;
			}
		}
	}
}