///SERVER

class Team
{
	array<Peer@> members;
	string shapeName;
	string teamName;
	
	// This rounds
	uint8 deaths;
	uint8 escaped;
	uint8 points;
	uint8 frags;
	uint8 living;	// Total player count
	
	uint8 totalEscaped;
	uint8 totalDeaths;
	uint8 totalPoints;
	uint8 totalFrags;
	
	array<vec2> spawnPoints;	// For each team different
	
	bool nomore;
	
	Team()
	{
	// To be set every new round actually
		deaths = 0;
		escaped = 0;
		living = 0;
		points = 0;
		frags = 0;
		
		totalEscaped = 0;
		totalDeaths = 0;
		totalPoints = 0;
		totalFrags = 0;
		
		nomore = false;
	}
	void OnRoundBegin()
	{
	// Write the stream and send it across the network - Sets this particular team up.
		for (uint8 it = 0; it < members.length(); it++)
		{
			vec2 sp = spawnPoints[rand(0,spawnPoints.length() - 1)];
			//vec2 setupPos(rand(2,5), rand(2,5));
			members[it].SetupPlayer(sp, this);
			
			uint64 nid = members[it].player.asset.GetNetworkID();
	
			BitStream stream;
			stream.Write(uint8(ID_PLAYER_SETUP));
			stream.WriteCompressed(members[it].guid);
			stream.WriteCompressed(nid);
			stream.Write(sp.x);
			stream.Write(sp.y);
			stream.WriteCompressed(teamName);
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
		}
	// Do other stuff on round begin
	}
	void EndRoundCalculation()
	{
		totalEscaped += escaped;
		totalDeaths += deaths;
		totalPoints += points;
		totalFrags += frags;
		
		deaths = 0;
		escaped = 0;
		living = 0;
		points = 0;
		frags = 0;
		
		for (uint8 it = 0; it < members.length(); it++)
		{
			if (members[it].player is null)
				continue;
			@members[it].player.myPeer = null;
			@members[it].player.asset = null;
			@members[it].player = null;
		}
	}
	
	void TeamLogic()
	{
		// This code counts the living players + sends condolences to the other players.
		uint8 livingCount = 0;
		for (uint8 it = 0; it < members.length(); it++)
		{
			// Would check for exception handling whether Peer was null or not but that should be done automatically.
			if (members[it].player is null)
				continue;
			if (members[it].player.health <= 0)
			{
				BitStream stream;
				stream.Write(uint8(NetworkMessages::ID_PLAYER_DIED));
				stream.WriteCompressed(members[it].player.myPeer.guid);
				if (@members[it].player.pawner !is null)	// Pwner related code.
				{
					stream.WriteCompressed(members[it].player.pawner.myPeer.guid);
					members[it].player.pawner.myPeer.myTeam.points += 10;
					members[it].player.pawner.myPeer.myTeam.frags++;
					members[it].player.pawner.myPeer.frags++;
				}
				
				deaths++;	// Team loses one of its players.
				members[it].deaths++;	// This player died
				@members[it].player.asset = null;
				@members[it].player = null;
				
				stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
			}
		}
	}
}
enum HideAndSeek_State
{
	ROUND_IN_PROGRESS = 1,
	ROUND_COUNTDOWN
}
class HideAndSeek
{
	array<Team@> teams;
	
	uint8 seekingTeam;
	
	Team@ seekingTeamHandle;
	
	uint8 state;
	
	// Timers
	Timer countdown;
	Timer infoTimer;
	string timerStr;
	uint roundTime;
	uint waitTime;
	
	uint width;
	uint height;
	
	HideAndSeek()
	{
		seekingTeam = 0;
		state = 0;
		timerStr = "";
		TeamsInit();
		
		waitTime = 4000;
		roundTime = 8000;
		
		GetWindowDimensions(width,height);
	}
	
	void TeamsInit()
	{
		Team redTeam;
		redTeam.shapeName = "Circle 2";
		redTeam.teamName = "red";
		Team blueTeam;
		blueTeam.shapeName = "Circle 1";
		blueTeam.teamName = "blue";
		Team orangeTeam;
		orangeTeam.shapeName = "Circle 3";
		orangeTeam.teamName = "orange";	
		Team greenTeam;
		greenTeam.shapeName = "Circle 4";
		greenTeam.teamName = "green";	
		
		@seekingTeamHandle = @redTeam;
		
		teams.insertLast(@redTeam);
		teams.insertLast(@blueTeam);
		teams.insertLast(@orangeTeam);
		teams.insertLast(@greenTeam);
	}
	void RoundBegin()
	{
		state = ROUND_IN_PROGRESS;
		BitStream stream;
		stream.Write(uint8(ID_ROUND_BEGIN));
		stream.WriteCompressed(roundTime);
		stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
		for (uint8 it = 0; it < teams.length(); it++)
		{
			teams[it].OnRoundBegin();
		}
	}
	void CountdownBeforeNewRound()
	{
		timerStr = "New round begins in: ";
		timerStr += (waitTime - countdown.GetElapsedTime()) / 1000;
		DrawGUIText( timerStr, vec2(width / 2 - 50, 0), 18);	
		if (countdown.GetElapsedTime() > waitTime)
		{
			countdown.Reset();
			RoundBegin();
		}
		
		if (infoTimer.GetElapsedTime() > 250)
		{
			BitStream stream;
			stream.Write(uint8(ID_GAME_INFO));
			stream.Write(state);
			stream.WriteCompressed(waitTime - countdown.GetElapsedTime());
			stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
			infoTimer.Reset();
		}
	}
	void RoundEnd()
	{
		state = ROUND_COUNTDOWN;
		countdown.Reset();
		
		for (uint8 it = 0; it < teams.length(); it++)
		{
			teams[it].EndRoundCalculation();
		}
		
		BitStream stream;
		stream.Write(uint8(ID_ROUND_END));
		stream.WriteCompressed(waitTime);
		stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
	}
	void Logic()	// Will make additions later
	{
		if (state == ROUND_IN_PROGRESS)
		{
			timerStr = "Round ends in: ";
			timerStr += (roundTime - countdown.GetElapsedTime()) / 1000;
			DrawGUIText( timerStr, vec2(width / 2 - 50, 0), 18);	
			bool atLeastOneTeamAlive = false;
			if (infoTimer.GetElapsedTime() > 250)
			{
				BitStream stream;
				stream.Write(uint8(ID_GAME_INFO));
				stream.Write(state);
				stream.WriteCompressed(roundTime - countdown.GetElapsedTime());
				stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 0, true);
				infoTimer.Reset();
			}
			for (uint8 it = 0; it < teams.length(); it++)
			{
				teams[it].TeamLogic();
				if ( teams[it].nomore == false && it != seekingTeam && teams[it].living == 0)
				{
					if (teams[it].deaths > 0 && teams[it].escaped == 0)
					{
						//Say this team was pwnd!
						//Give seekers extra points	
						// Awww or HOLY SHIT!
					}
					else if(teams[it].escaped > 0 && teams[it].deaths > 0)
					{
						// Some comrades left behind
					}
					else if(teams[it].escaped > 0 && teams[it].deaths == 0)
					{
						// All escaped! Yeah!
						// Applause or HOLY SHIT!
					}
					
					teams[it].nomore == true;
				}
				if (!teams[it].nomore)
					atLeastOneTeamAlive = true;
			}
			if (!atLeastOneTeamAlive || countdown.GetElapsedTime() > roundTime)
			{
				print("Round ending...\n");
				RoundEnd();
			}
		}
		else
			CountdownBeforeNewRound();
	}
		
	Team@ GetTeamByName(string name)
	{
		for (uint t = 0; t < teams.length(); t++)
		{
			if (teams[t].teamName == name)
				return teams[t];
		}
		return null;	
	}
	
	void InitSpawns()
	{
		// There will be 4 teams in original Hide and Seek, so the maps are compatible, there are 4 types of spawn points
		// unique for each team.
		vec2 spawnPos(0,0);
		for (uint t = 1; GetPoint(0,t, spawnPos); t++)
		{
			teams[0].spawnPoints.insertLast(spawnPos);
		}
		for (uint t = 1; GetPoint(1,t, spawnPos); t++)
		{
			teams[1].spawnPoints.insertLast(spawnPos);
		}
		for (uint t = 1; GetPoint(2,t, spawnPos); t++)
		{
			teams[2].spawnPoints.insertLast(spawnPos);
		}
		for (uint t = 1; GetPoint(3,t, spawnPos); t++)
		{
			teams[3].spawnPoints.insertLast(spawnPos);
		}
	}
}
class Game
{
	array<Peer@> connectedPeers;

	vec2 cameraMoveTo;
	Timer cameraDelta;
	float cameraSpeed;
	
	HideAndSeek mod;
	
	Timer updateTimer;
	Game()
	{
		cameraSpeed = 10.0f;
	}
	void CameraControls()
	{
		cameraMoveTo = vec2(0,0);
		if (input.IsKeyDown(Code::W))
			cameraMoveTo.y = -1;
		else if(input.IsKeyDown(Code::S))
			cameraMoveTo.y = 1;
		if (input.IsKeyDown(Code::D))
			cameraMoveTo.x = 1;
		else if (input.IsKeyDown(Code::A))
			cameraMoveTo.x = -1;
		if (cameraMoveTo.LengthSq() > 0)
		{
		cameraMoveTo.Normalize();
		cameraMoveTo *= cameraSpeed * cameraDelta.GetElapsedTime() / 1000;
		cameraMoveTo += GetCameraPos();
		SetCameraTransformCentered( cameraMoveTo, 0);
		}
		
		cameraDelta.Reset();
	}
	void ShowPlayerInfo()
	{
		string infoText;
		uint maxLength;
		infoText = "Players:\n";
		maxLength = infoText.length();
		
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			infoText += connectedPeers[t].peerName + "\n";
		}
		uint x;
		uint y;
		GetWindowDimensions(x,y);
		DrawGUIText(infoText, vec2(x - 100, 0), 18);
	}
	void OnLoop()
	{
		if (input.IsKeyDown(Code::Tab))
			ShowPlayerInfo();
		mod.Logic();
		DrawGUIText("Seek and Tag v0.3", vec2(0, 50), 18);
		CameraControls();
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			connectedPeers[t].OnLoop();
		}
		
	/*	BitStream stream;
		print("sayhey");
		stream.Write(uint8(NetworkMessages::ID_SNAPSHOT));
		stream.Write(uint(connectedPeers.length());
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			stream.Write(connectedPeers[t].guid);
			stream.Write(connectedPeers[t].player.asset.GetPosition().x);
			stream.Write(connectedPeers[t].player.asset.GetPosition().y);
		}*/
		if (updateTimer.GetElapsedTime() > 100)
		{
			BitStream stream;
			stream.Write(uint8(NetworkMessages::ID_SNAPSHOT));
			uint peerCount = 0;
			// Checking whether all peers have a player
			for (uint t = 0; t < connectedPeers.length(); t++)
			{
				if (connectedPeers[t].player !is null)
					peerCount++;
			}
			stream.WriteCompressed(peerCount);
			for (uint it = 0; it < connectedPeers.length(); it++)
			{
				if (connectedPeers[it].player is null)	// Offensichtlich
					continue;
				stream.WriteCompressed(connectedPeers[it].guid);
				stream.Write(connectedPeers[it].player.asset.GetPosition().x);
				stream.Write(connectedPeers[it].player.asset.GetPosition().y);
			}
			stream.SendUA(PP::HIGH_PRIORITY, PR::UNRELIABLE, 2, true);
			updateTimer.Reset();
		}
	}
	
	Peer@ GetPeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
				return connectedPeers[t];
		}
		return null;
	}
	
	void RemovePeerByGUID( uint64 guid )
	{
		for (uint t = 0; t < connectedPeers.length(); t++)
		{
			if (connectedPeers[t].guid == guid)
			{
				for (uint it = 0; it < connectedPeers[t].myTeam.members.length(); it++) {
					if (connectedPeers[t].myTeam.members[it] is connectedPeers[t])
							connectedPeers[t].myTeam.members.removeAt(it);
						}
				@connectedPeers[t].player.myPeer = null;
				@connectedPeers[t] = null;
				connectedPeers.removeAt(t);
				return;
			}
		}
	}
}