///SERVER

Bullet@ cBullet(Asset@ p)	// This function casts an Asset@ to a @Player
{
	Scripted @s = p.GetScripted();
	return cast<Bullet>(s);
}
PowerB@ cPowerB(Asset@ p)	// This function casts an Asset@ to a @Player
{
	Scripted @s = p.GetScripted();
	return cast<PowerB>(s);
}
class PowerB : Bullet
{
	PowerB(vec2 pos)
	{
		super();
	}
	void Shoot(vec2 direction, Player@ shooter)
	{
		Bullet::Shoot(direction, shooter);
	}
	void Update()
	{
		Bullet::Update();
	}
	void BeginContact(Asset@ contacted)
	{
	}
	void EndContact(Asset@ contacted)
	{
	}
	bool PreSolve(Asset@ contacted)
	{
		return Bullet::PreSolve(contacted);
	}
}
class Bullet : Scripted, Contact, Actor
{
	Asset@ asset;
	Player@ shotBy;
	
	Timer deletion;
	
	int damage;
	float speed;
	bool active;
	
	Bullet()
	{
		damage = 20;
		speed = 20.0f;
		active = true;
	}
	void Shoot(vec2 direction, Player@ shooter)
	{
		direction.Normalize();
		direction *= speed;
		asset.SetVelocity(direction);
		asset.SetRotation(-atan2(direction.x, direction.y));
		@shotBy = @shooter;
	}
	void SetAsset(Asset@ with)
	{
		@asset = @with;
	}
	void Update()
	{
		if (deletion.GetElapsedTime() > 2000)
		{
			@shotBy = null;
			@asset = null;
		}
	}
	void BeginContact(Asset@ contacted)
	{
	}
	void EndContact(Asset@ contacted)
	{
	}
	bool PreSolve(Asset@ contacted)
	{
		if (shotBy.asset is contacted && active)
		{
			return true;
		}
		else if (contacted.GetClassName() == "Bullet")
		{
			if (shotBy !is cBullet(contacted).shotBy)
			return true;
			else
			return false;
		}
		else if (contacted.GetClassName() == "Player" && active) {	// Active means, the bullet hasn't touched any surface, capable of doing damage.
		Player@ player = cPlayer(contacted);
		player.health -= damage;
		
		if (player.health <= 0)
		{
			@player.pawner = shotBy;
		}
		
		BitStream stream;
		stream.Write(uint8(NetworkMessages::ID_PLAYER_HEALTH));
		stream.WriteCompressed(player.myPeer.guid);
		stream.WriteCompressed(player.health);
		
		stream.SendUA(PP::HIGH_PRIORITY, PR::RELIABLE, 3, true);
		
		@asset = null;	// This deletes the asset.(By deleting the reference)
		return true;
		}
	active = false;
	//@asset = null;	// This deletes the asset.(By deleting the reference)
	return false;
	}
}