unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Graphics, Controls, Forms, Classes,
  Dialogs, Menus, ExtCtrls, ShellApi, AppEvnts, ImgList, commctrl, PngUnit,
  IdTCPConnection, IdTCPClient, IdHTTP, IdBaseComponent,
  IdAntiFreezeBase, IdAntiFreeze, ClipBrd, XMLIntf, XMLDoc, ActiveX, IdFTP,
  StdCtrls, inifiles, ComCtrls, OleCtnrs, Registry, XPMan, IdComponent;

type
  THttpUploadThread = class(TThread)
  private
    FNameUpload: string;
    FSuccess: Boolean;
    FImageURL: string;
    FErr: Boolean;
    FErrName: string;
    FErrDesc: string;
    FMimeType: string;
    FDeleteAfterUpload: Boolean;
  protected
    procedure Execute; override;
  public
    property Success: Boolean read FSuccess;
    property ImageURL: string read FImageURL;
    property Err: boolean read FErr;
    property ErrName: string read FErrName;
    property ErrDesc: string read FErrDesc;
    constructor Create(Suspended: Boolean; AFileNameUpload: string);
end;

type
  TFtpUploadThread = class(TThread)
  private
    FNameUpload: string;
    FSuccess: Boolean;
    FImageURL: string;
    FErr: Boolean;
    FErrName: string;
    FErrDesc: string;
    FDeleteAfterUpload: Boolean;
  protected
    procedure Execute; override;
  public
    property Success: Boolean read FSuccess;
    property ImageURL: string read FImageURL;
    property Err: boolean read FErr;
    property ErrName: string read FErrName;
    property ErrDesc: string read FErrDesc;
    constructor Create(Suspended: Boolean; AFileNameUpload: string);
end;

const
  WM_ICONTRAY   = WM_USER + 1;
  NIF_INFO = $10;
  NIF_MESSAGE = 1;
  NIF_ICON = 2;
  NOTIFYICON_VERSION = 3;
  NIF_TIP = 4;
  NIM_SETVERSION = $00000004;
  NIM_SETFOCUS = $00000003;
  NIIF_INFO = $00000001;
  NIIF_WARNING = $00000002;
  NIIF_ERROR = $00000003;
  NIN_SELECT = WM_USER + 0;
  NINF_KEY = $1;
  NIN_KEYSELECT = NIN_SELECT or NINF_KEY;

  NIN_BALLOONSHOW = WM_USER + 2;
  NIN_BALLOONHIDE = WM_USER + 3;
  NIN_BALLOONTIMEOUT = WM_USER + 4;
  NIN_BALLOONUSERCLICK = WM_USER + 5;

type
  PNewNotifyIconData = ^TNewNotifyIconData;
  TDUMMYUNIONNAME    = record
    case Integer of
      0: (uTimeout: UINT);
      1: (uVersion: UINT);
  end;

  TNewNotifyIconData = record
    cbSize: DWORD;
    Wnd: HWND;
    uID: UINT;
    uFlags: UINT;
    uCallbackMessage: UINT;
    hIcon: HICON;
   //Version 5.0 is 128 chars, old ver is 64 chars
    szTip: array [0..127] of Char;
    dwState: DWORD; //Version 5.0
    dwStateMask: DWORD; //Version 5.0
    szInfo: array [0..255] of Char; //Version 5.0
    DUMMYUNIONNAME: TDUMMYUNIONNAME;
    szInfoTitle: array [0..63] of Char; //Version 5.0
    dwInfoFlags: DWORD;   //Version 5.0
end;

type
  TMainForm = class(TForm)
    PopupMenu1: TPopupMenu;
    popShowSettings: TMenuItem;
    popQuit: TMenuItem;
    popScreenshot: TMenuItem;
    popHideSettings: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    timerState: TTimer;
    animUpload: TImageList;
    Interwebs: TIdHTTP;
    popActiveScreenshot: TMenuItem;
    grpImageShack: TGroupBox;
    txtCode: TEdit;
    cmdClear: TButton;
    cmdVerify: TButton;
    lblVerify: TLabel;
    Label1: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    grpGeneral: TGroupBox;
    chkUploadToImageShack: TCheckBox;
    ActiveHotkey: THotKey;
    cmdSetHotkey: TButton;
    ScreenHotkey: THotKey;
    Label4: TLabel;
    Label3: TLabel;
    Label2: TLabel;
    optImageShack: TRadioButton;
    optFTP: TRadioButton;
    grpFTP: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    txtFTPHost: TEdit;
    txtFTPPort: TEdit;
    Label11: TLabel;
    txtFTPUsername: TEdit;
    txtFTPPassword: TEdit;
    XPManifest1: TXPManifest;
    Label12: TLabel;
    txtFTPPath: TEdit;
    Label13: TLabel;
    Label14: TLabel;
    txtFTPWebsiteURL: TEdit;
    cmdFTPSaveSettings: TButton;
    cmdHideWindow: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure timerStateTimer(Sender: TObject);
    procedure popShowSettingsClick(Sender: TObject);
    procedure popHideSettingsClick(Sender: TObject);
    procedure popQuitClick(Sender: TObject);
    procedure popScreenshotClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure cmdVerifyClick(Sender: TObject);
    procedure cmdSetHotkeyClick(Sender: TObject);
    procedure cmdClearClick(Sender: TObject);
    procedure popScreenshotDrawItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
    procedure popShowSettingsDrawItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
    procedure popHideSettingsDrawItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
    procedure popQuitDrawItem(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; Selected: Boolean);
    procedure popScreenshotMeasureItem(Sender: TObject; ACanvas: TCanvas;
      var Width, Height: Integer);
    procedure popActiveScreenshotClick(Sender: TObject);
    procedure popActiveScreenshotDrawItem(Sender: TObject;
      ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
    procedure chkUploadToImageShackClick(Sender: TObject);
    procedure JShotServerConvExecuteMacro(Sender: TObject; Msg: TStrings);
    procedure optImageShackClick(Sender: TObject);
    procedure optFTPClick(Sender: TObject);
    procedure cmdFTPSaveSettingsClick(Sender: TObject);
    procedure cmdHideWindowClick(Sender: TObject);
  private
    TrayIconData: TNewNotifyIconData;
    function  TakeScreenshot(DestBitmap: TBitmap; ActiveWindow: boolean = False; path: string = ''): string;
    procedure UploadFile(fname: string);
    procedure DrawItemText(X: integer; ACanvas: TCanvas; ARect: TRect; Text: string);
    procedure DrawBar(ACanvas: TCanvas);
    { Private declarations }
  public
    procedure TrayMessage(var Msg: TMessage); message WM_ICONTRAY;
    procedure WMHotkey(var Msg: TWMHotkey); message WM_HOTKEY;
    procedure ShowBalloonTips(TipText: string; TipTitle: string; TipType: cardinal = 0);
    procedure UpdateState;
    procedure UpdateIcon;
    procedure UploadComplete(Sender: TObject);
    procedure FTPUploadComplete(Sender: TObject);
    { Public declarations }
  end;
                                                                    
function  FTPDirExists(DirName : String; IdFTPComp : TIdFTP) : Boolean;

var
  MainForm: TMainForm;
  TrayTooltip: string;
  TrayIcon: HICON;
  TrayHidden: boolean;
  TrayAnim: short;
  AppState: string;
  hTooltip: Cardinal;
  ti: TToolInfo;
  buffer : array[0..255] of char;
  ISRegCode: string = '';
  HotKey_1: Integer;
  HotKey_2: Integer;
  num: Integer = 0;
  URL: string = '';
  HttpUploadThread: THttpUploadThread;
  FtpUploadThread: TFtpUploadThread;
  FTPPort: word;
  FTPHost, FTPUsername, FTPPassword, FTPPath, FTPWebsiteURL: string;
  UseFTP: Boolean;

implementation

uses DateUtils, IdMultiPartFormData, ComObj, Math;

{$R *.dfm}

{ Generic }

function RegisterFileTypeCommand(fileExtension, menuItemText, target: string) : boolean;
var
  reg: TRegistry;
  fileType: string;
begin
  result := false;
  reg := TRegistry.Create;
  with reg do
  try
    RootKey := HKEY_CLASSES_ROOT;
    if OpenKey('.' + fileExtension, True) then
    begin
      fileType := ReadString('') ;
      if fileType = '' then
      begin
        fileType := fileExtension + 'file';
        WriteString('', fileType) ;
      end;
      CloseKey;
      if OpenKey(fileType + '\shell\' + menuItemText + '\command', True) then
      begin
        WriteString('', target + ' "%1"') ;
        CloseKey;
        result := true;
      end;
    end;
  finally
    Free;
  end;
end;

function UnRegisterFileTypeCommand(fileExtension, menuItemText: string) : boolean;
var
  reg: TRegistry;
  fileType: string;
begin
  result := false;
  reg := TRegistry.Create;
  with reg do
  try
    RootKey := HKEY_CLASSES_ROOT;
    if OpenKey('.' + fileExtension, True) then
    begin
      fileType := ReadString('') ;
      CloseKey;
    end;
    if OpenKey(fileType + '\shell', True) then
    begin
      DeleteKey(menuItemText) ;
      CloseKey;
      result := true;
    end;
  finally
    Free;
  end;
end;

procedure RegisterShell;
begin
  RegisterFileTypeCommand('bmp','Upload using JShot',Application.ExeName);
  RegisterFileTypeCommand('png','Upload using JShot',Application.ExeName);
  RegisterFileTypeCommand('gif','Upload using JShot',Application.ExeName);
  RegisterFileTypeCommand('jpg','Upload using JShot',Application.ExeName);
  RegisterFileTypeCommand('jpeg','Upload using JShot',Application.ExeName);
  RegisterFileTypeCommand('tif','Upload using JShot',Application.ExeName);
  RegisterFileTypeCommand('tiff','Upload using JShot',Application.ExeName);
end;

procedure UnregisterShell;
begin
  UnregisterFileTypeCommand('bmp','Upload using JShot');
  UnregisterFileTypeCommand('png','Upload using JShot');
  UnregisterFileTypeCommand('gif','Upload using JShot');
  UnregisterFileTypeCommand('jpg','Upload using JShot');
  UnregisterFileTypeCommand('jpeg','Upload using JShot');
  UnregisterFileTypeCommand('tif','Upload using JShot');
  UnregisterFileTypeCommand('tiff','Upload using JShot');
end;

procedure WriteINIString(Section: string; Key: string; Value: string);
var
  INI: TIniFile;
begin
  INI := TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
  INI.WriteString(Section, Key, Value);
  INI.Destroy;
end;

procedure WriteINIInteger(Section: string; Key: string; Value: integer);
var
  INI: TIniFile;
begin
  INI := TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
  INI.WriteInteger(Section, Key, Value);
  INI.Destroy;
end;

function ReadINIString(Section: string; Key: string; Default: string): string;
var
  INI: TIniFile;
begin
  INI := TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
  Result := INI.ReadString(Section, Key, Default);
  INI.Destroy;
end;

function ReadINIInteger(Section: string; Key: string; Default: integer): integer;
var
  INI: TIniFile;
begin
  INI := TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
  Result := INI.ReadInteger(Section, Key, Default);
  INI.Destroy;
end;

procedure ShortCutToHotKey(HotKey: TShortCut; var Key : Word; var Modifiers: Uint);
var
  Shift: TShiftState;
begin
  ShortCutToKey(HotKey, Key, Shift);
  Modifiers := 0;
  if (ssShift in Shift) then
  Modifiers := Modifiers or MOD_SHIFT;
  if (ssAlt in Shift) then
  Modifiers := Modifiers or MOD_ALT;
  if (ssCtrl in Shift) then
  Modifiers := Modifiers or MOD_CONTROL;
end;

function HTTPEncode(const AStr: String): String;
const
  NoConversion = ['A'..'Z','0'..'9','a'..'z','.','_','-'];
var
  Sp, Rp: PChar;
begin
  SetLength(Result, Length(AStr) * 3);
  Sp := PChar(AStr);
  Rp := PChar(Result);
  while Sp^ <> #0 do
  begin
    if Sp^ in NoConversion then
      Rp^ := Sp^
    else
      if Sp^ = ' ' then
        Rp^ := '+'
      else
      begin
        FormatBuf(Rp^, 3, '%%%.2x', 6, [Ord(Sp^)]);
        Inc(Rp,2);
      end;
    Inc(Rp);
    Inc(Sp);
  end;
  SetLength(Result, Rp - PChar(Result));
end;

function FTPDirExists(DirName : String; IdFTPComp : TIdFTP) : Boolean;
Var
 DirList : TStringList;
begin
 Result := False;
 DirList := TStringList.Create;
 IdFTPComp.List(DirList, DirName, True);
 if DirList.Count > 0 then
  Result := True;
 DirList.Free;
end;

{ THttpUploadThread }

constructor THttpUploadThread.Create(Suspended: Boolean; AFileNameUpload: string);
begin
  inherited Create(Suspended);
  FNameUpload := AFileNameUpload;
  FErr := false;
  FMimeType := 'image/png';
end;

procedure THttpUploadThread.Execute;
var
  Http: TIdHTTP;
  formData : TIdMultiPartFormDataStream;
  Lol: string;
  XMLDoc: IXMLDocument;
  URL: string;
begin
  try
    FSuccess := false;
    CoInitialize(nil);
    formData := TIdMultiPartFormDataStream.Create;
    formData.AddFile('fileupload', FNameUpload, FMimeType);
    formData.AddFormField('xml','yes');
    if ISRegCode <> '' then formData.AddFormField('cookie',ISRegCode);
    Http := TIdHTTP.Create(nil);
    try
      Http.ReadTimeout := 180000; // 10000
      Http.ConnectTimeout := 10000;
      Http.AllowCookies := False;
      Http.HandleRedirects := False;
      Http.Request.Accept := '*/*';
      Http.Request.ContentLength := -1;
      Http.Request.UserAgent := 'Mozilla/3.0 (compatible; Jdbye''s JShot)';
      Http.ProtocolVersion := pv1_1;

      Lol := Http.Post('http://www.imageshack.us/index.php', formData);
      XMLDoc := LoadXMLData(Lol);
      XMLDoc.Active := True;
      URL := XMLDoc.Node.ChildNodes.FindNode('links').ChildNodes.FindNode('image_link').Text;
      XMLDoc.Active := False;
      FImageURL := URL;
      FSuccess := True;
    except
      on E: Exception do begin
        URL := '';
        FErrName := E.ClassName;
        FErrDesc := E.Message;
        FErr     := True;
        FSuccess := False;
      end;
    end;
  finally
    try
      formData.Free;
      Http.Free;
      CoUninitialize;
    except end;
  end;
end;

{ TFtpUploadThread }

constructor TFtpUploadThread.Create(Suspended: Boolean; AFileNameUpload: string);
begin
  inherited Create(Suspended);
  FNameUpload := AFileNameUpload;
  FErr := false;
end;

procedure TFtpUploadThread.Execute;
var
  Ftp: TIdFTP;
  Lol: string;
  URL: string;
begin
    FSuccess := false;
    CoInitialize(nil);

    Ftp := TIdFTP.Create(nil);
  try try
  with Ftp do begin
    Username := FTPUsername;
    Password := FTPPassword;
    Host := FTPHost;
    Port := FTPPort;
    Passive := True;
    Connect;

    if Connected then begin
      // Connected

      if ((FTPPath <> '') and (FTPPath <> '-')) then begin
        if not FTPDirExists(FTPPath, Ftp) then MakeDir(FTPPath);
        ChangeDir(FTPPath);
      end;

      Put(FNameUpload, ExtractFileName(FNameUpload));
      FImageURL := FTPWebsiteURL+HTTPEncode(ExtractFileName(FNameUpload));
      FSuccess := True;

    end else begin
      FErr := True;
      FErrName := 'Connection Error';
      FErrDesc := 'Unable to connect to the FTP server.';
    end;
  end;
  except on E: Exception do begin
    FErr := True;
    FErrName := E.ClassName;
    FErrDesc := E.Message;
  end; end;
  finally begin
    try
      FTP.Disconnect;
    except end;
    try
      FTP.Free;
      CoUninitialize;
    except end;
  end; end;
end;

{ TMainForm }

procedure TMainForm.UploadComplete(Sender: TObject);
begin
  with HttpUploadThread do begin
    if Success then begin
      URL := ImageURL;
      ShowBalloonTips(ImageURL,'Upload Complete! (Click here to copy URL)',NIIF_INFO);
    end else begin
      if Err then ShowBalloonTips(ErrDesc,'Failed to upload image ('+ErrName+')',NIIF_ERROR);
    end;
    if FDeleteAfterUpload then DeleteFile(FNameUpload);
  end;
  AppState := 'Idle';
  HttpUploadThread := nil;
end;

procedure TMainForm.FTPUploadComplete(Sender: TObject);
begin
  with FtpUploadThread do begin
    if Success then begin
      URL := ImageURL;
      ShowBalloonTips(ImageURL,'Upload Complete! (Click here to copy URL)',NIIF_INFO);
    end else begin
      if Err then ShowBalloonTips(ErrDesc,'Failed to upload image ('+ErrName+')',NIIF_ERROR);
    end;
    if FDeleteAfterUpload then DeleteFile(FNameUpload);
  end;
  AppState := 'Idle';
  FtpUploadThread := nil;
end;

{ShowBalloonTips procedure carry out the new feature: Balloon Tips}
procedure TMainForm.ShowBalloonTips(TipText: string; TipTitle: string; TipType: cardinal = 0);
begin
  TrayIconData.uFlags := NIF_MESSAGE + NIF_INFO;
  strPLCopy(TrayIconData.szInfo, TipText, SizeOf(TrayIconData.szInfo) - 1);
  TrayIconData.DUMMYUNIONNAME.uTimeout := 10000;
  strPLCopy(TrayIconData.szInfoTitle, TipTitle, SizeOf(TrayIconData.szInfoTitle) - 1);
  TrayIconData.dwInfoFlags := TipType;   //NIIF_INFO;  //NIIF_ERROR;  //NIIF_WARNING;
  Shell_NotifyIcon(NIM_MODIFY, @TrayIconData);
  {in my testing, the following code has no use}
  TrayIconData.DUMMYUNIONNAME.uVersion := NOTIFYICON_VERSION;
  if not Shell_NotifyIcon(NIM_SETVERSION, @TrayIconData) then
    ShowMessage('setversion fail');
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  Key1: Word;
  Modifiers1: UINT;
  Key2: Word;
  Modifiers2: UINT;
  AddShellExt: integer;
  iUseFTP: Integer;
begin
  AddShellExt := 0;
  AppState := 'Idle';
  TrayTooltip := 'JShot - ' + AppState;
  TrayIcon := Application.Icon.Handle;
  TrayHidden := True;
  with TrayIconData do
  begin
    cbSize := SizeOf(TrayIconData);
    Wnd := Handle;
    uID := 0;
    uFlags := NIF_MESSAGE + NIF_ICON + NIF_TIP;
    uCallbackMessage := WM_ICONTRAY;
    hIcon := TrayIcon;
    StrPCopy(szTip, TrayTooltip);
  end;
  Shell_NotifyIcon(NIM_ADD, @TrayIconData);
  ISRegCode := ReadINIString('Account','Regcode','');
  lblVerify.Caption := ReadINIString('Account','Email','          ');
  txtCode.Text := ISRegCode;
  ScreenHotkey.HotKey := TextToShortCut(ReadINIString('Hotkey','Full','Shift+Alt+1'));
  ActiveHotkey.HotKey := TextToShortCut(ReadINIString('Hotkey','Active','Shift+Alt+2'));
  AddShellExt := ReadINIInteger('Settings', 'AddShellExt', 0);
  iUseFTP := ReadINIInteger('FTP', 'UseFTP', 0);
  FTPHost := ReadINIString('FTP', 'Host', '');
  FTPPort := ReadINIInteger('FTP', 'Port', 21);
  FTPUsername := ReadINIString('FTP', 'Username', '');
  FTPPassword := ReadINIString('FTP', 'Password', '');
  FTPPath := ReadINIString('FTP', 'Path', '');
  FTPWebsiteURL := ReadINIString('FTP', 'WebsiteURL', '');
  txtFTPHost.Text := FTPHost;
  txtFTPPort.Text := IntToStr(FTPPort);
  txtFTPUsername.Text := FTPUsername;
  txtFTPPassword.Text := FTPPassword;
  txtFTPPath.Text := FTPPath;
  txtFTPWebsiteURL.Text := FTPWebsiteURL;

  if AddShellExt > 0 then begin
    chkUploadToImageShack.Checked := True;
    RegisterShell;
  end else chkUploadToImageShack.Checked := False;
  if iUseFTP > 0 then begin
    optFTP.Checked := True;
    grpFTP.Enabled := True;
    optImageShack.Checked := False;
    grpImageShack.Enabled := False;
    UseFTP := True;
  end
  else begin
    optImageShack.Checked := True;
    grpImageShack.Enabled := True;
    optFTP.Checked := False;
    grpFTP.Enabled := False;
    UseFTP := False;
  end;
If ParamCount = 0 then begin
  if ShortCutToText(ScreenHotkey.HotKey) <> 'None' then begin
    ShortCutToHotKey(ScreenHotkey.HotKey, Key1, Modifiers1);
    HotKey_1 := GlobalAddAtom('ScreenHotKey_1');
    if not RegisterHotKey(Handle, HotKey_1, Modifiers1, Key1) then
      ShowMessage('Unable to assign '+ShortCutToText(ScreenHotkey.HotKey)+' as full screenshot hotkey.');
  end;

  if ShortCutToText(ActiveHotkey.HotKey) <> 'None' then begin
    ShortCutToHotKey(ActiveHotkey.HotKey, Key2, Modifiers2);
    HotKey_2 := GlobalAddAtom('ScreenHotKey_2');
    if not RegisterHotKey(Handle, HotKey_2, Modifiers2, Key2) then
      ShowMessage('Unable to assign '+ShortCutToText(ScreenHotkey.HotKey)+' as active window screenshot hotkey.');
  end;
end else UploadFile(ParamStr(1));
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  if HttpUploadThread <> nil then begin
    HttpUploadThread.FSuccess := False;
    HttpUploadThread.Terminate;
  end;
  if FtpUploadThread <> nil then begin
    FtpUploadThread.FSuccess := False;
    FtpUploadThread.Terminate;
  end;
    DeallocateHWnd(TrayIconData.Wnd);
    Shell_NotifyIcon(NIM_DELETE, @TrayIconData);
end;

procedure TMainForm.TrayMessage(var Msg: TMessage);
var
p: TPoint;
begin
  case Msg.lParam of
    WM_LBUTTONDBLCLK:
    begin
      if (ParamCount > 0) then exit;
      if TrayHidden then begin
        MainForm.Show;
        TrayHidden := False;
      end
      else begin
        MainForm.Hide;
        TrayHidden := True;
      end;
    end;
    WM_RBUTTONDOWN:
    begin
      if ParamCount > 0 then exit;
      SetForegroundWindow(Handle);
      GetCursorPos(p);
      PopUpMenu1.Popup(p.x, p.y);
      PostMessage(Handle, WM_NULL, 0, 0);
    end;
    NIN_BALLOONUSERCLICK: begin
      if URL <> '' then Clipboard.AsText := URL;
      if (ParamCount > 0) then Close;
    end;
    NIN_BALLOONTIMEOUT:
      if (ParamCount > 0) then Close;
  end;
end;

procedure TMainForm.WMHotkey(var msg: TWMHotkey);
var
  b: TBitmap;
  fname: string;
begin
  if ParamCount > 0 then exit;
  if Msg.Hotkey = HotKey_1 then begin
    if AppState = 'Idle' then begin
      b := TBitmap.Create;
      fname := TakeScreenshot(b);
      AppState := 'Uploading...';
      TrayAnim := animUpload.Count - 1;
      UpdateState;
      if UseFTP then begin
        FtpUploadThread := TFtpUploadThread.Create(true, fname);
        with FtpUploadThread do
        begin
          FDeleteAfterUpload := False;
          FreeOnTerminate := true;
          OnTerminate := FTPUploadComplete;
          Resume;
        end;
      end
      else begin
        HttpUploadThread := THttpUploadThread.Create(true, fname);
        with HttpUploadThread do
        begin
          FMimeType := 'image/png';
          FDeleteAfterUpload := False;
          FreeOnTerminate := true;
          OnTerminate := UploadComplete;
          Resume;
        end;
      end;
    end;
  end
  else if Msg.Hotkey = HotKey_2 then begin
    if AppState = 'Idle' then begin
      b := TBitmap.Create;
      fname := TakeScreenshot(b,True);
      AppState := 'Uploading...';
      TrayAnim := animUpload.Count - 1;
      UpdateState;
      if UseFTP then begin
        FtpUploadThread := TFtpUploadThread.Create(true, fname);
        with FtpUploadThread do
        begin
          FDeleteAfterUpload := False;
          FreeOnTerminate := true;
          OnTerminate := FTPUploadComplete;
          Resume;
        end;
      end
      else begin
        HttpUploadThread := THttpUploadThread.Create(true, fname);
        with HttpUploadThread do
        begin
          FMimeType := 'image/png';
          FDeleteAfterUpload := False;
          FreeOnTerminate := true;
          OnTerminate := UploadComplete;
          Resume;
        end;
      end;
    end;
  end;
end;

procedure TMainForm.timerStateTimer(Sender: TObject);
begin
  UpdateState;
end;

function TMainForm.TakeScreenshot(DestBitmap: TBitmap; ActiveWindow: boolean = False; path: string = ''): string;
var
  DC : HDC;
  Stamp: string;
  Month, Day, Hour, Minute, Second: string;
  hWin : Cardinal;
  r : TRect;
begin
  if path = '' then path := ExtractFilePath(Application.ExeName);
  if ActiveWindow then begin
    hWin := GetForegroundWindow;
    DC := GetWindowDC(hWin);
    try try
      GetWindowRect(hWin,r) ;
      DestBitmap.Width := r.Right - r.Left;
      DestBitmap.Height := r.Bottom - r.Top;
      BitBlt(DestBitmap.Canvas.Handle, 0, 0, DestBitmap.Width, DestBitmap.Height, DC, 0, 0, SRCCOPY) ;
      except on E: Exception do ShowMessage('An error occurred in Screenshot Creation ('+E.ClassName+'):'#13#10+E.Message); end;
    finally
      ReleaseDC (hWin, DC) ;
    end;
  end else begin
    DC := GetDC (GetDesktopWindow);
    try try
      DestBitmap.Width := GetDeviceCaps (DC, HORZRES) ;
      DestBitmap.Height := GetDeviceCaps (DC, VERTRES) ;
      BitBlt(DestBitmap.Canvas.Handle, 0, 0, DestBitmap.Width, DestBitmap.Height, DC, 0, 0, SRCCOPY) ;
      except on E: Exception do ShowMessage('An error occurred in Screenshot Creation ('+E.ClassName+'):'#13#10+E.Message); end;
    finally
      ReleaseDC (GetDesktopWindow, DC) ;
    end;
  end;
  try
  if not DirectoryExists('.\screenshots') then CreateDir('.\screenshots');

  if MonthOf(Date) < 10 then Month := '0'+IntToStr(MonthOf(Date))
  else Month := IntToStr(MonthOf(Date));
  if DayOfTheMonth(Date) < 10 then Day := '0'+IntToStr(DayOfTheMonth(Date))
  else Day := IntToStr(DayOfTheMonth(Date));
  if HourOf(Time) < 10 then Hour := '0'+IntToStr(HourOf(Time))
  else Hour := IntToStr(HourOf(Time));
  if MinuteOf(Time) < 10 then Minute := '0'+IntToStr(MinuteOf(Time))
  else Minute := IntToStr(MinuteOf(Time));
  if SecondOf(Time) < 10 then Second := '0'+IntToStr(SecondOf(Time))
  else Second := IntToStr(SecondOf(Time));

  Stamp :=  IntToStr(CurrentYear)+'_'+
            Month+'_'+
            Day+'_'+
            Hour+'_'+
            Minute+'_'+
            Second;
  except on E: Exception do ShowMessage('An error occurred in TimeStamp Creation ('+E.ClassName+'):'#13#10+E.Message); end;
  try PngUnit.WriteBitmapToPngFile(path+'screenshots\JShot_'+Stamp+'.png',DestBitmap,RGB(255,0,255));
  except on E: Exception do ShowMessage('An error occurred in PNG Conversion ('+E.ClassName+'):'#13#10+E.Message+#13#10#13#10'Stamp: '+Stamp+#13#10#13#10+'PngUnit.WriteBitmapToPngFile('+path+'screenshots\JShot_'+Stamp+'.png'+',DestBitmap'+','+IntToStr(RGB(255,0,255))+')'); end;
  Result := path+'screenshots\JShot_'+Stamp+'.png';
end;

procedure TMainForm.UploadFile(fname: string);
var
  MimeType: string;
  b: TBitmap;
  ext, path, myfile, TargetFile: string;
  DeleteAfterUpload: boolean;
begin
  DeleteAfterUpload := False;
  myfile := fname;
  ext := ExtractFileExt(fname);
  path := ExtractFilePath(Application.ExeName);
  if (ext = 'bmp') or (ext = '.bmp') then begin
    try try
      TargetFile := ChangeFileExt(ExtractFileName(ParamStr(1)),'.png');
      b := TBitmap.Create;
      b.LoadFromFile(fname);
      if FileExists(path+TargetFile) then DeleteFile(path+TargetFile);
      PngUnit.WriteBitmapToPngFile(path+TargetFile,b,RGB(255,0,255));
      myfile := path+TargetFile;
      MimeType := 'image/png';
      DeleteAfterUpload := True;
    except on E: Exception do
      MimeType := 'image/bmp';
    end;
    finally
      b.Free;
    end;
  end else if (ext = 'jpg') or (ext = 'jpeg') or (ext = '.jpg') or (ext = '.jpeg') then
    MimeType := 'image/jpeg'
  else if (ext = 'tif') or (ext = 'tiff') or (ext = '.tif') or (ext = '.tiff') then
    MimeType := 'image/tiff'
  else if (ext = 'png') or (ext = '.png') then
    MimeType := 'image/png'
  else if (ext = 'gif') or (ext = '.gif') then
    MimeType := 'image/gif';
  AppState := 'Uploading...';
  TrayAnim := animUpload.Count - 1;
  UpdateState;
  if UseFTP then begin
    FtpUploadThread := TFtpUploadThread.Create(true, fname);
    with FtpUploadThread do
    begin
      FreeOnTerminate := true;
      OnTerminate := FTPUploadComplete;
      FDeleteAfterUpload := DeleteAfterUpload;
      Resume;
    end;
  end
  else begin
    HttpUploadThread := THttpUploadThread.Create(true, fname);
    with HttpUploadThread do
    begin
      FreeOnTerminate := true;
      OnTerminate := UploadComplete;
      FMimeType := MimeType;
      FDeleteAfterUpload := DeleteAfterUpload;
      Resume;
    end;
  end;
end;

procedure TMainForm.UpdateIcon;
begin
  TrayIconData.uFlags := NIF_MESSAGE + NIF_ICON + NIF_TIP;
  TrayIconData.hIcon := TrayIcon;
  StrPCopy(TrayIconData.szTip, TrayTooltip);
  Shell_NotifyIcon(NIM_Modify, @TrayIconData);
end;

procedure TMainForm.UpdateState;
var
  Icon: TIcon;
begin
  TrayIcon := Application.Icon.Handle;
  TrayTooltip := 'JShot - ' + AppState;
  if AppState = 'Uploading...' then begin
    Icon:=TIcon.Create;
    try try
      animUpload.GetIcon(TrayAnim,Icon);
      TrayIcon := Icon.Handle;
      UpdateIcon;
      Inc(TrayAnim);
      if TrayAnim >= animUpload.Count then TrayAnim := 0;
    except on E: Exception do begin
      ShowMessage(E.ClassName+' error raised, with message: '#13#10+E.Message);
      Application.Terminate;
    end; end;
    finally
      Icon.Free;
    end;
  end else begin
    TrayAnim := 0;
    UpdateIcon;
  end;
  Refresh;
end;


procedure TMainForm.popShowSettingsClick(Sender: TObject);
begin
  MainForm.Show;
  TrayHidden := False;
end;

procedure TMainForm.popHideSettingsClick(Sender: TObject);
begin
  MainForm.Hide;
  TrayHidden := True;
end;

procedure TMainForm.popQuitClick(Sender: TObject);
begin
  MainForm.Close;
end;

procedure TMainForm.popScreenshotClick(Sender: TObject);
var
  b: TBitmap;
  fname: string;
begin
  if AppState = 'Idle' then begin
    b := TBitmap.Create;
    fname := TakeScreenshot(b);
    AppState := 'Uploading...';
    TrayAnim := animUpload.Count - 1;
    UpdateState;
    if UseFTP then begin
      FtpUploadThread := TFtpUploadThread.Create(true, fname);
      with FtpUploadThread do
      begin
        FDeleteAfterUpload := False;
        FreeOnTerminate := true;
        OnTerminate := FTPUploadComplete;
        Resume;
      end;
    end
    else begin
      HttpUploadThread := THttpUploadThread.Create(true, fname);
      with HttpUploadThread do
      begin
        FMimeType := 'image/png';
        FDeleteAfterUpload := False;
        FreeOnTerminate := true;
        OnTerminate := UploadComplete;
        Resume;
      end;
    end;
  end;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  UnRegisterHotkey(Handle, HotKey_1);
  GlobalDeleteAtom(HotKey_1);
  HotKey_1 := 0;
  UnRegisterHotkey(Handle, HotKey_2);
  GlobalDeleteAtom(HotKey_2);
  HotKey_2 := 0;
end;

procedure TMainForm.cmdVerifyClick(Sender: TObject);
var
  formData: TIdMultiPartFormDataStream;
  Lol: string;
  XMLDoc: IXMLDocument;
  AccountData: IXMLNode;
begin
  if txtCode.Text = '' then ShowMessage('Please enter your registration code.')
  else begin
    formData := TIdMultiPartFormDataStream.Create;
    formData.AddFormField('login',txtCode.Text);
    formData.AddFormField('xml','yes');
    try
      Lol := Interwebs.Post('http://www.imageshack.us/setlogin.php', formData);
      XMLDoc := LoadXMLData(Lol);
      AccountData := XMLDoc.Node.ChildNodes.FindNode('account_data');
      if AccountData.ChildNodes.FindNode('exists').Text = 'no' then begin
        lblVerify.Caption := 'Bogus registration code!';
        ShowMessage('Settings NOT saved - Invalid registration code.');
      end
      else begin
        WriteINIString('Account','Regcode',txtCode.Text);
        WriteINIString('Account','Email',AccountData.ChildNodes.FindNode('email').Text);
        ISRegCode := txtCode.Text;
        lblVerify.Caption := AccountData.ChildNodes.FindNode('email').Text + ' verified. Saved to configuration.';
        ShowMessage('Settings Saved!');
      end;
    except on E: Exception do
      lblVerify.Caption := 'Unable to verify regcode: '+E.Message+')';
    end;
  end;
end;

procedure TMainForm.cmdClearClick(Sender: TObject);
begin
  lblVerify.Caption := '          ';
  ISRegCode := '';
  txtCode.Text := '';
  WriteINIString('Account','Regcode','');
  WriteINIString('Account','Email','');
end;


procedure TMainForm.cmdFTPSaveSettingsClick(Sender: TObject);
begin
  if  (txtFTPHost.Text <> '')
  and (txtFTPPort.Text <> '')
  and (txtFTPUsername.Text <> '')
  and (txtFTPPassword.Text <> '')
  and (txtFTPWebsiteURL.Text <> '')
  then begin
    WriteINIInteger('FTP', 'UseFTP', 1);
    WriteINIString('FTP', 'Host', txtFTPHost.Text);
    WriteINIInteger('FTP', 'Port', StrToInt(txtFTPPort.Text));
    WriteINIString('FTP', 'Username', txtFTPUsername.Text);
    WriteINIString('FTP', 'Password', txtFTPPassword.Text);
    WriteINIString('FTP', 'Path', txtFTPPath.Text);
    WriteINIString('FTP', 'WebsiteURL', txtFTPWebsiteURL.Text);
    ShowMessage('Settings Saved!'#13#10#13#10'Make sure to test uploading so you know they''re correct.'#13#10'If uploading fails, and you know your username and password are correct, chances are you entered the wrong path.');
  end
  else begin
    ShowMessage('You forgot to fill in some required details. Please check your FTP settings and make sure everything is correct.');
  end;

end;

procedure TMainForm.cmdHideWindowClick(Sender: TObject);
begin
  MainForm.Hide;
  TrayHidden := True;
end;

procedure TMainForm.cmdSetHotkeyClick(Sender: TObject);
var
  Key : Word;
  Modifiers: UINT;
begin
  if ReadINIString('Hotkey','Full','Shift+Alt+1') <> 'None' then begin
    UnRegisterHotkey(Handle, HotKey_1);
    GlobalDeleteAtom(HotKey_1);
    HotKey_1 := 0;
  end;
  if ReadINIString('Hotkey','Active','Shift+Alt+2') <> 'None' then begin
    UnRegisterHotkey(Handle, HotKey_2);
    GlobalDeleteAtom(HotKey_2);
    HotKey_2 := 0;
  end;

  WriteINIString('Hotkey','Full',ShortCutToText(ScreenHotkey.HotKey));
  WriteINIString('Hotkey','Active',ShortCutToText(ActiveHotkey.HotKey));
  ShowMessage('Settings Saved!');

  if ShortCutToText(ScreenHotkey.HotKey) <> 'None' then begin
    ShortCutToHotKey(ScreenHotkey.HotKey, Key, Modifiers);
    HotKey_1 := GlobalAddAtom('ScreenHotKey_1');
    if not RegisterHotKey(Handle, HotKey_1, Modifiers, Key) then begin
      ShowMessage('Failed to assign full screenshot hotkey:'#13#10#13#10'Unable to assign '+ShortCutToText(ScreenHotkey.HotKey)+' as hotkey.');
      URL := '';
    end;
  end;

  if ShortCutToText(ActiveHotkey.HotKey) <> 'None' then begin
    ShortCutToHotKey(ActiveHotkey.HotKey, Key, Modifiers);
    HotKey_2 := GlobalAddAtom('ScreenHotKey_2');
    if not RegisterHotKey(Handle, HotKey_2, Modifiers, Key) then begin
      ShowMessage('Failed to assign active window screenshot hotkey:'#13#10#13#10'Unable to assign '+ShortCutToText(ActiveHotkey.HotKey)+' as hotkey.');
      URL := '';
    end;
  end;
end;

procedure TMainForm.DrawBar(ACanvas: TCanvas);
var
  lf1 : TLogFont;
  tf1 : TFont;
  lf2 : TLogFont;
  tf2 : TFont;
begin
  with ACanvas do begin
    Brush.Color := clNavy;
    FillRect(Rect(0,0,20,150));
    Font.Name := 'Tahoma';
    Font.Style := Font.Style + [fsBold];
    Font.Color := clWhite;
    tf1 := TFont.Create;
    try
      tf1.Assign(Font);
      GetObject(tf1.Handle, sizeof(lf1), @lf1);
      lf1.lfEscapement := 900;
      lf1.lfHeight := Font.Height - 2;
      tf1.Handle := CreateFontIndirect(lf1);
      Font.Assign(tf1);
    finally
      tf1.Free;
    end;
    TextOut(2, 105, 'JShot');
  end;

  with ACanvas do begin
    Font.Name := 'Tahoma';
    Font.Style := [fsItalic];
    Font.Color := clWhite;
    Font.Size := 6;
    tf2 := TFont.Create;
    try
      tf2.Assign(Font);
      GetObject(tf2.Handle, sizeof(lf2), @lf2);
      lf2.lfEscapement := 900;
      lf2.lfHeight := Font.Height - 2;
      tf2.Handle := CreateFontIndirect(lf2);
      Font.Assign(tf2);
    finally
      tf2.Free;
    end;
    TextOut(6, 44, 'by Jdbye');
  end;
end;

procedure TMainForm.DrawItemText(X: integer; ACanvas: TCanvas; ARect: TRect; Text: string);
begin
 ARect.Left := X;
 DrawText(ACanvas.Handle, PChar(Text), -1, ARect, DT_LEFT or DT_VCENTER or DT_SINGLELINE or DT_NOCLIP);
end;

procedure TMainForm.popScreenshotDrawItem(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
begin
 if Selected then
   ACanvas.Brush.Color := clHighlight
 else
   ACanvas.Brush.Color := clMenu;

 ARect.Left := 20;
 ACanvas.FillRect(ARect);
 DrawItemText(25,ACanvas,ARect,popScreenshot.Caption);
end;

procedure TMainForm.popShowSettingsDrawItem(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
begin
 if Selected then
   ACanvas.Brush.Color := clHighlight
 else
   ACanvas.Brush.Color := clMenu;

 ARect.Left := 20;
 ACanvas.FillRect(ARect);
 DrawItemText(25,ACanvas,ARect,popShowSettings.Caption);
end;

procedure TMainForm.popHideSettingsDrawItem(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
begin
 if Selected then
   ACanvas.Brush.Color := clHighlight
 else
   ACanvas.Brush.Color := clMenu;

 ARect.Left := 20;
 ACanvas.FillRect(ARect);
 DrawItemText(25,ACanvas,ARect,popHideSettings.Caption);
end;

procedure TMainForm.popQuitDrawItem(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
begin
 if Selected then
   ACanvas.Brush.Color := clHighlight
 else
   ACanvas.Brush.Color := clMenu;

 ARect.Left := 20;
 ACanvas.FillRect(ARect);
 DrawItemText(25,ACanvas,ARect,popQuit.Caption);

 DrawBar(ACanvas); // draw that fucker!
end;

procedure TMainForm.popScreenshotMeasureItem(Sender: TObject;
  ACanvas: TCanvas; var Width, Height: Integer);
begin
 Width := 140;
end;

procedure TMainForm.popActiveScreenshotClick(Sender: TObject);
var
  b: TBitmap;
  fname: string;
begin
  if AppState = 'Idle' then begin
    b := TBitmap.Create;
    fname := TakeScreenshot(b,True);
    AppState := 'Uploading...';
    TrayAnim := animUpload.Count - 1;
    UpdateState;
    if UseFTP then begin
      FtpUploadThread := TFtpUploadThread.Create(true, fname);
      with FtpUploadThread do
      begin
        FDeleteAfterUpload := False;
        FreeOnTerminate := true;
        OnTerminate := FTPUploadComplete;
        Resume;
      end;
    end
    else begin
      HttpUploadThread := THttpUploadThread.Create(true, fname);
      with HttpUploadThread do
      begin
        FMimeType := 'image/png';
        FDeleteAfterUpload := False;
        FreeOnTerminate := true;
        OnTerminate := UploadComplete;
        Resume;
      end;
    end;
  end;
end;

procedure TMainForm.popActiveScreenshotDrawItem(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
begin
 if Selected then
   ACanvas.Brush.Color := clHighlight
 else
   ACanvas.Brush.Color := clMenu;

 ARect.Left := 20;
 ACanvas.FillRect(ARect);
 DrawItemText(25,ACanvas,ARect,popActiveScreenshot.Caption);
end;

procedure TMainForm.chkUploadToImageShackClick(Sender: TObject);
begin
  if chkUploadToImageShack.Checked then begin
    WriteINIInteger('Settings', 'AddShellExt', 1);
    RegisterShell;
  end
  else begin
    WriteINIInteger('Settings', 'AddShellExt', 0);
    UnregisterShell;
  end;
end;

procedure TMainForm.JShotServerConvExecuteMacro(Sender: TObject;
  Msg: TStrings);
begin
  if AppState <> 'Idle' then Exit;
  ShowMessage(Msg.Text);
end;

procedure TMainForm.optFTPClick(Sender: TObject);
begin
  optFTP.Checked := True;
  grpFTP.Enabled := True;
  optImageShack.Checked := False;
  grpImageShack.Enabled := False;
  if  (FTPHost <> '')
  and (FTPPort > 0)
  and (FTPUsername <> '')
  and (FTPPassword <> '')
  and (FTPWebsiteURL <> '')
  then begin
    UseFTP := True;
  end;
end;

procedure TMainForm.optImageShackClick(Sender: TObject);
begin
  optImageShack.Checked := True;
  grpImageShack.Enabled := True;
  optFTP.Checked := False;
  grpFTP.Enabled := False;
  WriteINIInteger('FTP', 'UseFTP', 0);
  UseFTP := False;
end;

end.
