#version 120
// #extension ARB_draw_buffers : enable

uniform samplerCube cubemap;

varying vec2 pos_zw;
varying vec3 normal;
varying vec3 uv;

#include <geometry_include.frag>

void main()
{
	vec4 diff = textureCube(cubemap, uv)*2.0;

	WRITE_DIFFUSE( diff.rgb );
	WRITE_SPECULAR( diff.a );

	WRITE_NORMAL( normalize(normal) );
	WRITE_DEPTH( pos_zw.x/pos_zw.y );
}
