#version 120

//#define VIEW_GBUFFERS
//#define VIEW_SSAO
//#define VIEW_VSM

uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform sampler2D light_accumulation;
uniform sampler2D ssao_buffer;
uniform sampler2D vsm_buffer;
uniform sampler2D lightstreaks;

varying vec2 uv;


void main()
{
#ifdef VIEW_GBUFFERS
	if ( uv.x < 0.5 )
	{
		vec2 uv2 = fract(uv*2.0);
		vec4 ds = texture2D(diffuse_specular, uv2);
		if ( uv.y < 0.5 )
		{
			gl_FragColor = vec4(ds.rgb, 1.0);
		}
		else
		{
			gl_FragColor = vec4(ds.a);
		}
	}
	else
	{
		vec2 uv2 = fract((uv - vec2(0.5))*2.0);
		vec4 nd = texture2D(normal_depth, uv2);
		if ( uv.y < 0.5 ) gl_FragColor = vec4(nd.rgb*0.5 + vec3(0.5), 1.0);
		else gl_FragColor = vec4(nd.a*0.5 + 0.5);
	}
#endif // VIEW_GBUFFERS
#ifdef VIEW_SSAO
	vec2 uv2 = fract(uv*2.0);
	if ( uv.x < 0.5 )
	{
		vec4 sb = texture2D(ssao_buffer, uv2);
		if ( uv.y < 0.5 ) gl_FragColor = vec4(sb.rgb, 1.0);
		else gl_FragColor = vec4(sb.a);
	}
	else
	{
		if ( uv.y < 0.5 )
		{
			gl_FragColor = texture2D(lightstreaks, uv2);
		}
		else
		{
			gl_FragColor = texture2D(light_accumulation, uv2);
		}
	}
#endif // VIEW_SSAO

#if !defined(VIEW_GBUFFERS) && !defined(VIEW_SSAO) //&& !defined(VIEW_VSM) 
	vec4 la = texture2DLod(light_accumulation, uv, 0.0);
	vec4 sb = texture2D(ssao_buffer, uv);
	vec4 ls = texture2D(lightstreaks, uv);
	//gl_FragColor = vec4(la.rgb*sb.a + sb.rgb + ls.rgb, 1.0);
	gl_FragColor = vec4((la.rgb + sb.rgb)*sb.a + ls.rgb, 1.0);
	//gl_FragColor = vec4(sb.rgb + sb.aaa, 1.0);
	//gl_FragColor = vec4(la.rgb + ls.rgb, 1.0);
#endif

#ifdef VIEW_VSM
	vec2 uv2 = fract(uv*2.0);
	vec4 sd = texture2D(vsm_buffer, uv2);
	/*
	sd.x /= 254.0;
	sd.y /= 65503.0;
	sd.z /= 254.0;
	sd.w /= 65503.0;
	*/
	if ( uv.x < 0.5 && uv.y < 0.5 )
	{
		gl_FragColor = mix(vec4(abs(sd.xxx), 1.0), gl_FragColor, 0.5);
	}
	/*else
	{
		gl_FragColor = vec4(abs(sd.yyy), 1.0);
	}*/
#endif // VIEW_VSM
}
