#version 120
//#extension ARB_draw_buffers : enable

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform samplerCube cubemap;

varying vec2 pos_zw;
varying vec3 normal;
varying vec3 cube_uv;
varying vec2 uv;

#include <geometry_include.frag>

void main()
{
	vec3 color = texture2D(diffuse, uv).rgb + textureCube(cubemap, cube_uv).rgb;

	WRITE_DIFFUSE( color );
	WRITE_SPECULAR( texture2D(specular, uv).r );

	WRITE_NORMAL( normalize(normal) );
	WRITE_DEPTH( pos_zw.x/pos_zw.y );
}
