function WorldObject_h(h)
{
	this.handle = h;

	this.Cull = function(face)
	{
		return fsWorldObject_Cull(this.handle, face);
	}

	this.SetDefaultProgram = function()
	{
		return fsWorldObject_SetDefaultProgram(this.handle);
	}

	this.SetParameters = function(parameters)
	{
		return fsWorldObject_SetParameters(this.handle, parameters);
	}

	this.SetScale = function(x, y, z)
	{
		return fsWorldObject_SetScale(this.handle, x, y, z);
	}

	this.SetRotation = function(angleDeg, axisX, axisY, axisZ)
	{
		return fsWorldObject_SetRotation(this.handle, angleDeg, axisX, axisY, axisZ);
	}

	this.SetPosition = function(x, y, z)
	{
		return fsWorldObject_SetPosition(this.handle, x, y, z);
	}

	this.SetAnimationTime = function(time)
	{
		return fsWorldObject_SetAnimationTime(this.handle, time);
	}

	this.SetProgram = function(shader)
	{
		return fsWorldObject_SetProgram(this.handle, shader);
	}

	this.Delete = function()
	{
		return fsWorldObject_Delete(this.handle);
	}

}
function WorldObject(world, sceneGraph)
{
	return new WorldObject_h(fsWorldObject_Create(world.handle, sceneGraph));
}
