
#define AMBOCC
const int amboccsteps = 20;
const int amboccsubsteps = 4;

const float STEP = 1.0/6.0;
const float MAXSTEPS = 10.0;
const float NDIST = 1.0/32.0;
const float pi = 3.1415926535897932;

varying vec3 p, e;
varying vec4 wp, wv;
varying vec3 params;
varying vec3 params2;
varying vec4 vcolor;

uniform float t;
uniform sampler2D texture;
uniform vec3 lightDir;

struct mResult {
	vec4 color;
	vec3 pos;
};

float saw(float a) {
	return abs(mod(a, 2.0)-1.0);
}

vec2 vec3toxy(in vec3 v) {
	return 1.0-(0.5+vec2(atan(v.x, v.z), atan(v.y, length(v.xz))*2.0)/(pi*2.0));
}

vec3 randomi(vec2 co, float ti) {
    float noiseR = (fract(sin(dot(co ,vec2(12.9898,78.233))+ti) * 43758.5453));
    float noiseG = (fract(sin(dot(co ,vec2(12.9898,78.233)*2.0)+ti) * 43758.5453));
    float noiseB = (fract(sin(dot(co ,vec2(12.9898,78.233)*3.0)+ti) * 43758.5453));
    return vec3(noiseR,noiseG,noiseB)*0.3;
}

float distToVec(vec3 pos, vec3 dir) {
	float t = dot(pos, dir);
	float d2;
	if (t <= 0.0f) {
		d2 = dot(pos, pos);
	} else {
		vec3 q = t/dot(dir, dir)*dir;
		pos = pos-q;
		d2 = dot(pos, pos);
	}
	return d2;
}

float K(in vec3 p) {
	float tpi = t*pi*2.0;

	float add = max((params.z)*0.125, 0.0);
	float l = pow(1.25-length(p), 1.5) + add;

	float phase = 2.0+params.x;
	float phase2 = 5.0- 3.0*sin(tpi+add*8.0+wv.x*0.5);
	//params.z = 1.0;
	p += l*params.z*(sin(p.x*phase2+(wv.x+params2.x)*phase+tpi*0.13)+
	                 sin(p.y*phase2+(wv.y)          *phase+tpi*0.65)+
	                 sin(p.z*phase2+(wv.z)          *phase+tpi*0.87));

	float val = 1.75-length(p);

/*	vec3 n = normalize(p);
	float pha = 2.0;
	float size = 0.1*params.x;
/	val += size*(saw(n.x*pha*pi + wp.x + tpi*8.0)+
	             saw(n.y*pha*pi + wp.y + tpi*8.0)+
	             saw(n.z*pha*pi + wp.z + tpi*8.0));*/

	//float val = 1.5-distToVec(p, normalize(params2));

	return max(val, 0.0);
}

vec3 N(in vec3 p) {
	vec3 n = vec3(
		K(vec3(p.x-NDIST,p.y,p.z)) - K(vec3(p.x+NDIST,p.y,p.z)),
		K(vec3(p.x,p.y-NDIST,p.z)) - K(vec3(p.x,p.y+NDIST,p.z)),
		K(vec3(p.x,p.y,p.z-NDIST)) - K(vec3(p.x,p.y,p.z+NDIST)));

	return normalize(n);
}

mResult march(vec3 ey, vec3 dir, float maxSteps) {
	float k = 0.0;
	float s = 1.0;
	vec3 pos = vec3(0.0);

	mResult result;

	for (; s < 22.0; ) {
		pos = ey+dir*s;
		if (min(pos.x, min(pos.y, pos.z)) < -1.0 || max(pos.x, max(pos.y, pos.z)) > 1.0) {
			result.color = vec4(0.0);
			return result;
		}
		k = K(pos);
		if (k > 1.0) break;
		s = s+max(1.0-k, 0.3);
	}

	if (s < maxSteps) {
		for (int i = 0; i < 9; i++){
			dir = dir*0.5;
			if (k > 1.0)  pos = pos-dir;
			else pos = pos+dir;
			k = K(pos);
		}
	} else {
		k = 0.0;
	}

	vec3 normal = N(pos);

	float alpha = 0.0;
	if (k >= 0.0) alpha = 1.0;

	//vec3 lightDir = normalize(vec3(1.0, 0.0, 0.0));
	float bri = 0.35+0.65*dot(normalize(lightDir), normal);
//	bri = 1.0;

	vec2 tc = 0.5+0.5*reflect(normalize(dir), normal).xy;

	//result.color = vec4(normal, alpha);

	vec3 evec = normalize(e);

	vec3 reflVec = reflect(-evec, normal);
	vec2 xy = vec3toxy(reflVec);
	vec3 reflColor = texture2D(texture, xy).rgb;
	float fresnel = 1.0-dot(evec, normal);


//	result.color = vec4(bri*texture2D(texture, tc).xyz, alpha);
	result.color = vec4(bri*reflColor.xyz, alpha);
	result.pos = pos;

	#ifdef AMBOCC
		float ambbri = 1.0;
		for (int i = 0; i < amboccsteps; i++) {
			vec3 ambdir = normalize(randomi(vec2(i*1.139, i*1.554), i*1.327));
			//ambdir = reflect(ambdir, normal);
			ambdir *= 0.15*sign(dot(ambdir, normal));
			vec3 ambstep = ambdir;
			ambdir += ambstep*4.0;

			for (int j = 0; j < amboccsubsteps; j++) {
				float ambval = K(pos+ambdir);
				if (ambval > 1.0) {
					ambbri -= 1.0/amboccsteps*2.5 ;//** ((amboccsubsteps-j)/amboccsubsteps);
					break;
				}
				ambdir += ambstep;
			}
		}
		result.color.xyz *= 0.5+0.5*ambbri;
	#endif

	return result;
}

mResult fogmarch(vec3 e, vec3 dir) {
	float k = 0.0;
	float s = 1.0;
	vec3 pos = vec3(0.0);

	mResult result;

	for (; s < 10.0; ) {
		pos = e+dir*s;
		result.pos = pos;
/*		if (min(pos.x, min(pos.y, pos.z)) < -1.0 || max(pos.x, max(pos.y, pos.z)) > 1.0) {
			result.color.x /= result.color.a;
			return result;
		}*/
		k = K(pos);
		result.color.a += 0.75;
		result.color.x += max(min(k-1.0, 1.0), 0.0);
		s += 0.5;
	}

	result.color.x /= result.color.a;

	return result;
}

void main(void) {
	float fog = params.y;

	if (vcolor.a < 0.011) discard;

	//e = -e;
	vec3 eye = normalize(e);
/*	if (eye.x == 0.0) eye.x = 0.01;
	if (eye.y == 0.0) eye.y = 0.01;
	if (eye.z == 0.0) eye.z = 0.01;*/

	float tx = max((1.0-p.x)/eye.x, (-1.0-p.x)/eye.x);
	float ty = max((1.0-p.y)/eye.y, (-1.0-p.y)/eye.y);
	float tz = max((1.0-p.z)/eye.z, (-1.0-p.z)/eye.z);
	float tlen = min(tx, min(ty, tz));
	vec3 pos = p + tlen*eye;

	vec3 dir = -eye;

	vec4 fcol = vec4(0.0, 0.0, 0.0, 1.0);
	vec3 finalPos = pos;

	if (fog < 0.99) {
		mResult m = march(pos, dir*STEP, MAXSTEPS);
		fcol = m.color;
		finalPos = m.pos;
	}
	if (fcol.a < 1.0) discard;

	if (fog > 0.01) {
		mResult f = fogmarch(pos, dir*STEP);
		fcol = mix(fcol.xyza, vec4(f.color.xxx, 1.0-pow(fog, 1.5)), fog);
	} else {
		// depth
		vec4 iproj = gl_ModelViewProjectionMatrix * (wv+vec4(finalPos-p.xyz, 0.0));
		iproj.z /= iproj.w;
		gl_FragDepth = (iproj.z+1.0)/2.0;
	}

	gl_FragColor = vcolor*fcol;

	//gl_FragDepth = wp.z;

//	gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
//	gl_FragColor = vec4(e.xyz, 1.0);
//	gl_FragColor = vec4(pos.xyz, 1.0);
//	gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
}


