
const float STEP = 1.0/8.0;
const float MAXSTEPS = 10.0;
const float NDIST = 1.0/32.0;
const float pi = 3.1415926535897932;

varying vec3 p, e;
varying vec4 wp, wv;
varying vec3 params;

uniform float t;

struct mResult {
	vec4 color;
	vec3 pos;
	vec3 normal;
};

float saw(float a) {
	return abs(mod(a, 2.0)-1.0);
}

float K(in vec3 p) {
	float val = 1.75-length(p);

	vec3 n = normalize(p);
	float pha = 4.0;
	float size = 0.1;
	val += size*(sin(n.x*pha*pi+t*0.65*pi)+sin(n.y*pha*pi+t*0.75*pi)+sin(n.z*pha*pi+t*pi));

	return max(val, 0.0);
}

vec3 N(in vec3 p) {
	vec3 n = vec3(
		K(vec3(p.x-NDIST,p.y,p.z)) - K(vec3(p.x+NDIST,p.y,p.z)),
		K(vec3(p.x,p.y-NDIST,p.z)) - K(vec3(p.x,p.y+NDIST,p.z)),
		K(vec3(p.x,p.y,p.z-NDIST)) - K(vec3(p.x,p.y,p.z+NDIST)));

	return normalize(n);
}

mResult march(vec3 e, vec3 dir, float maxSteps) {
	float k = 0.0;
	float s = 1.0;
	vec3 pos = vec3(0.0);

	mResult result;

	for (; s < 25.0; ) {
		pos = e+dir*s;
		if (pos.x < -1.0 || pos.y < -1.0 || pos.z < -1.0 || pos.x > 1.0 || pos.y > 1.0 || pos.z > 1.0) {
			result.color = vec4(0.0);
			return result;
		}
		k = K(pos);
		if (k > 1.0) break;
		s = s+max(1.0-k, 0.25);
	}

	if (s < maxSteps)
		for (int i = 0; i < 9; i++){
			dir = dir*0.5;
			if (k > 1.0)  pos = pos-dir;
			else pos = pos+dir;
			k = K(pos);
		}

	vec3 normal = N(pos);

	float alpha = 0.0;
	if (k >= 0.0) alpha = 1.0;

	vec3 lightDir = vec3(0.0, 1.0, 0.0);
	float bri = dot(lightDir, normal);
//	bri = 1.0;

	//return vec4(normal, alpha);
	result.color = vec4(bri, bri, bri, alpha);
	result.pos = pos;
	result.normal = normal;
	return result;
}


void main(void) {
//	vec3 pos = vec3(0.0, 0.0, 0.0);

	//e = -e;
	vec3 eye = normalize(e);
/*	if (eye.x == 0.0) eye.x = 0.01;
	if (eye.y == 0.0) eye.y = 0.01;
	if (eye.z == 0.0) eye.z = 0.01;*/

	float tx = max((1.0-p.x)/eye.x, (-1.0-p.x)/eye.x);
	float ty = max((1.0-p.y)/eye.y, (-1.0-p.y)/eye.y);
	float tz = max((1.0-p.z)/eye.z, (-1.0-p.z)/eye.z);
	float tlen = min(tx, min(ty, tz));
	vec3 pos = p + tlen*eye;

	vec3 dir = -eye;

	mResult m = march(pos, dir*STEP, MAXSTEPS);
	vec4 fcol = m.color;
	if (fcol.a < 1.0) discard;
//	gl_FragColor = fcol;
	gl_FragData[0] = fcol;


	vec4 iproj = gl_ModelViewProjectionMatrix * (wv+vec4(m.pos-p.xyz, 0.0));
	gl_FragData[1] = iproj.z;
	iproj.z /= iproj.w;
	gl_FragDepth = (iproj.z+1.0)/2.0;
	//gl_FragDepth = wp.z;


//	gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
//	gl_FragColor = vec4(e.xyz, 1.0);
//	gl_FragColor = vec4(pos.xyz, 1.0);
//	gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
}


