
#define AMBOCC
const float amboccsteps = 30.0;

const float STEP = 1.0/25.0;
const float MAXSTEPS = 100.0;
const float NDIST = 1.0/64.0;
const float pi = 3.1415926535897932;
const vec3 obuColor = vec3(0.17*1.2, 0.16*1.2, 0.18*1.2);


varying vec3 p, e;
varying vec4 wp, wv;
varying vec3 params;
// params0 = distortpower
// params2 = xoffs

uniform float t;
uniform float distortpower;
uniform float obumorph;
uniform sampler3D tex3d;//,tex3d2;
//uniform samplerCube texcube;
uniform sampler2D texsphere;
uniform sampler2D texmap;

const vec3 obupos = vec3(0.292, 0.5, 0.35);

struct mResult {
	vec4 color;
	vec3 pos;
	vec3 normal;
};

float saw(float a) {
	return abs(mod(a, 2.0)-1.0);
}

vec3 randomi(vec2 co, float ti) {
    float noiseR = (fract(sin(dot(co ,vec2(12.9898,78.233))+ti) * 43758.5453));
    float noiseG = (fract(sin(dot(co ,vec2(12.9898,78.233)*2.0)+ti) * 43758.5453));
    float noiseB = (fract(sin(dot(co ,vec2(12.9898,78.233)*3.0)+ti) * 43758.5453));
    return vec3(noiseR,noiseG,noiseB)*0.3;
}

float K(in vec3 p) {
	float side = sign(params.z);
	float tpi = t*pi*pi;

	float pha = 4.0;
	vec3 wpos = wv.xyz;
	float v = 0.0;
	if (distortpower > 0.0)
		v = side*(sin(wpos.x*pha*side+tpi+sin((wpos.y+wpos.z)*0.5*side+tpi*0.25))+
	              sin(wpos.y*pha     +tpi+sin((wpos.x+wpos.z)*0.5*side+tpi*0.45))+
	              sin(wpos.z*pha*side+tpi+sin((wpos.x+wpos.y)*0.5*side+tpi*0.65)));

	pha = 8.0;
	pha += pha*0.5*sin(p.x+p.y+p.z);
	vec3 v2 = vec3(0.0, 0.0, 0.0);
	if (params.y > 0.0) v2 = params.y*vec3(sin(p.x*pha*2.13+tpi*pi+sin(p.y*pha*4.34+tpi*pi)),
	                                       sin(p.y*pha*2.65+tpi*pi+sin(p.z*pha*4.34+tpi*pi)),
	                                       sin(p.z*pha*2.87+tpi*pi+sin(p.x*pha*4.34+tpi*pi)));
	p.xyz += v2*0.05;

/*	const float cutoff = 0.00;
	float minv = -cutoff, maxv = params.z*side*2.5;
	if (side > 0.0) { minv = -maxv; maxv = cutoff; }
	float power = max(abs(p.x-cutoff*side), 0.0);*/
	float power = distortpower;
	p.x -= power*v*0.2;

	float val1=0.0, val2=0.0;
	pha = 16.0;
	float texmix = (obumorph)+min(min(saw(p.x*pha), saw(p.y*pha)), saw(p.z*pha));
	vec2 model = texture3D(tex3d, p+obupos).rg*5.0;
	float val = mix(model.x, model.y, clamp(texmix, 0.0, 1.0));

	return max(val, 0.0);
}

vec3 N(in vec3 p) {
	vec3 n = vec3(
		K(vec3(p.x-NDIST,p.y,p.z)) - K(vec3(p.x+NDIST,p.y,p.z)),
		K(vec3(p.x,p.y-NDIST,p.z)) - K(vec3(p.x,p.y+NDIST,p.z)),
		K(vec3(p.x,p.y,p.z-NDIST)) - K(vec3(p.x,p.y,p.z+NDIST)));

	return normalize(n);
}

vec2 vec3toxy(in vec3 v) {
	return 1.0-(0.5+vec2(atan(v.x, v.z), atan(v.y, length(v.xz))*2.0)/(pi*2.0));
}

mResult march(vec3 ey, vec3 dir, float maxSteps) {
	float k = 0.0;
	float s = 1.0;
	vec3 pos = vec3(0.0);
	vec3 odir = dir;

	mResult result;

	for (; s < maxSteps; ) {
		pos = ey+dir*s;
		if (pos.x < -1.0 || pos.y < -1.0 || pos.z < -1.0 || pos.x > 1.0 || pos.y > 1.0 || pos.z > 1.0) {
			result.color = vec4(0.0);
			return result;
		}
		k = K(pos);
		if (k > 1.0) break;
		s = s+max(1.0-k, 0.5);
	}

	if (s < maxSteps)
		for (int i = 0; i < 5; i++){
			dir = dir*0.5;
			if (k > 1.0)  pos = pos-dir;
			else pos = pos+dir;
			k = K(pos);
		}

	vec3 normal = N(pos);

	float alpha = 0.0;
	if (k >= 0.0) alpha = 1.0;

	vec3 lightDir = vec3(1.0, 1.0, 1.0);
	float bri = dot(lightDir, normal);
	//bri = 1.0;

	//return vec4(normal, alpha);
	vec4 tcol = texture2D(texmap, vec2(pos.x+pos.z, pos.y+pos.z));
	result.color = vec4(tcol.xyz, alpha);
	result.pos = pos;
	result.normal = normal;


	// refraction
	if (k >= 0.0) {
		vec3 evec = normalize(e);

		vec3 reflVec = reflect(-evec, normal);
		vec2 xy = vec3toxy(reflVec);
		vec3 reflColor = texture2D(texsphere, xy).rgb;

		float fresnel = 1.0-dot(evec, normal);
/*
		const float refrIndex = 0.85;
		dir = refract(-evec, normal, refrIndex)*STEP;
		//dir = odir;
		s = 1.0;
		float dist = 0.0;
		vec3 orige = ey;
		ey = pos;
		for (; s < maxSteps; ) {
			pos = ey+dir*s;
			k = K(pos);
			if (k < 1.0) break;
			float d = max(1.0-k, 0.25);
			dist += d;
			s = s+d;
		}

		s = 1.0-clamp(dist/maxSteps*6.0, 0.0, 1.0);

		normal = N(pos);

		vec3 refl = refract(normalize(dir), -normal, refrIndex);
		//refl = normalize(dir);
		vec3 fr = refl*vec3(1.0, 1.0, -1.0);
		xy = vec3toxy(fr);
		vec3 refrColor = texture2D(texsphere, xy).rgb;
		//result.color.xyz = textureCube(texcube, refl*vec3(1.0, 1.0, -1.0)).xyz;

		//vec3 refl = normalize(dir);
		//result.color.xyz = mix(result.color.xyz, reflColor, 0.5);
		//reflColor = mix(vec3(1.0, 0.0, 0.0), reflColor, 0.5);
		//reflColor = vec3(1.0, 0.0, 0.0);
		//result.color.xyz = mix(reflColor, refrColor, fresnel);
		result.color.xyz = refrColor;*/

		result.color.xyz = mix(obuColor, reflColor, fresnel);
	}

/*	float amb = 0.65;
	result.color.xyz = mix(result.color.xyz*bri, result.color.xyz, amb);*/

	#ifdef AMBOCC
		if (params.x < 4.0) {
			float ambbri = 1.0;
			for (float i = 0.0; i < amboccsteps; i += 1.0) {
				vec3 ambdir = normalize(randomi(vec2(i*0.139, i*0.554), i*10.324));
				ambdir = reflect(ambdir, normal);
				ambdir *= 0.2*sign(dot(ambdir, normal));

				float ambval = K(pos+ambdir);
				if (ambval > 1.0) ambbri -= 1.0/amboccsteps*2.5;
			}
			result.color.xyz = mix(result.color.xyz*(0.5+0.5*ambbri), result.color.xyz, max(params.x-3.0, 0.0));
		}
	#endif

	return result;
}


void main(void) {
//	vec3 pos = vec3(0.0, 0.0, 0.0);

	//e = -e;
	vec3 eye = normalize(e);
/*	if (eye.x == 0.0) eye.x = 0.01;
	if (eye.y == 0.0) eye.y = 0.01;
	if (eye.z == 0.0) eye.z = 0.01;*/

	float tx = max((1.0-p.x)/eye.x, (-1.0-p.x)/eye.x);
	float ty = max((1.0-p.y)/eye.y, (-1.0-p.y)/eye.y);
	float tz = max((1.0-p.z)/eye.z, (-1.0-p.z)/eye.z);
	float tlen = min(tx, min(ty, tz));
	vec3 pos = p + tlen*eye;

	vec3 dir = -eye;

	float addstep = max(min(pow(length(e)*0.25, 2.0), 128.0), 0.0);
	float totmul = min(params.x+addstep, 12.0);
	params.x = totmul;

	mResult m = march(pos, dir*STEP*totmul, MAXSTEPS);
	vec4 fcol = m.color;
	if (fcol.a < 1.0) discard;
	//discard;
	gl_FragColor = fcol;
	//gl_FragData[0] = fcol;


	vec4 iproj = gl_ModelViewProjectionMatrix * (wv+vec4(m.pos-p.xyz, 0.0));
	//gl_FragData[1] = iproj.z;
	iproj.z /= iproj.w;
	gl_FragDepth = (iproj.z+1.0)/2.0;
	//gl_FragDepth = wp.z;


//	gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
//	gl_FragColor = vec4(e.xyz, 1.0);
//	gl_FragColor = vec4(pos.xyz, 1.0);
//	gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
}


