
#define AMBOCC
const float amboccsteps = 25.0;
const float amboccsubsteps = 4.0;

const float STEP = 1.0/50.0;
const float MAXSTEPS = 150.0;
const float NDIST = 1.0/32.0;
const float pi = 3.1415926535897932;

varying vec3 p, e;
varying vec4 wp, wv;
varying vec3 params;
varying vec3 params2;
// params0 = texture offs
// params1 = fog
// params2 = realfogmix

#define distort    params.y
#define realfogmix params.z
#define fog        params2.x

uniform float t;
//uniform sampler3D tex3d;
uniform sampler3D tex3d;
//uniform sampler2D noisetex;
uniform sampler2D tex2d;
//uniform float fog;
//uniform float realfogmix;
//uniform float distort;
uniform float zdiv;

const vec3 obupos = vec3(0.5, 0.5, 0.35);

struct mResult {
	vec4 color;
	vec3 pos;
	vec3 normal;
};

float saw(float a) {
	return abs(mod(a, 2.0)-1.0);
}

vec2 vec3toxy(in vec3 v) {
	return 1.0-(0.5+vec2(atan(v.x, v.z), atan(v.y, length(v.xz))*2.0)/(pi*2.0));
}

vec3 randomi(vec2 co, float ti) {
    float noiseR = (fract(sin(dot(co ,vec2(12.9898,78.233))+ti) * 43758.5453));
    float noiseG = (fract(sin(dot(co ,vec2(12.9898,78.233)*2.0)+ti) * 43758.5453));
    float noiseB = (fract(sin(dot(co ,vec2(12.9898,78.233)*3.0)+ti) * 43758.5453));
    return vec3(noiseR,noiseG,noiseB)*0.3;
}

//vec3 nois(vec3 xyz) {
/*	vec4 v4 = texture2D(noisetex, sin(xyz.xy*xyz.z)).rgba;
	return normalize(-1.0+2.0*vec3(v4.xyz*v4.a));*/

/*	return normalize(-1.0+2.0*vec3(texture2D(noisetex, sin(xyz.xy*1.0)).r,
	                               texture2D(noisetex, sin(xyz.yz*1.0)).g,
	                               texture2D(noisetex, sin(xyz.zx*1.0)).b));*/
//}

float K(in vec3 p) {
	vec3 origp = p;
	float tpi = t*pi;

	float pha = 16.0;
	float fogger = (sin((p.x)*pha+tpi*2.13/*+wv.x*2.0*/)+
	                sin((p.y)*pha+tpi*2.65/*+wv.y*2.0*/)+
	                sin((p.z)*pha+tpi*2.87/*+wv.z*2.0*/));


	//p += realfogmix*nois(p+vec3(sin(tpi*0.01), sin(tpi*0.015), sin(tpi*0.02)))*0.05*vec3(1.0, 1.0, 0.0);

	p += fogger*distort*0.05;

	p.z *= zdiv*0.5;
	p.z -= 0.28;
	p.z += params.x;
	float val = texture3D(tex3d, p+obupos).a*1.5;


/*	float mul = max(1.0-abs(p.z)*1.0, 0.0);
	float val = 0.0;
	//p = 0.5+0.5*p;
	p.xy = 0.5+0.5*p.xy;
	p.y *= zdiv;
	p.y += params.x;
	if (mul > 0.0) val = mul*texture2D(tex3d, p.xy).a*1.5;*/

/*	float realfog = 1.95-length(origp+fogger*0.51);
	val += realfog*realfogmix;
	//val = mix(val, clamp(realfog, 0.0, 1.0), realfogmix);*/

	return max(val, 0.0);
}

vec3 N(in vec3 p) {
	vec3 n = vec3(
		K(vec3(p.x-NDIST,p.y,p.z)) - K(vec3(p.x+NDIST,p.y,p.z)),
		K(vec3(p.x,p.y-NDIST,p.z)) - K(vec3(p.x,p.y+NDIST,p.z)),
		K(vec3(p.x,p.y,p.z-NDIST)) - K(vec3(p.x,p.y,p.z+NDIST)));

	return normalize(n);
}

mResult march(vec3 ey, vec3 dir, float maxSteps) {
	float k = 0.0;
	float s = 1.0;
	vec3 pos = vec3(0.0);

	mResult result;

	for (; s < maxSteps; ) {
		pos = ey+dir*s;
		if (min(pos.x, min(pos.y, pos.z)) < -1.0 || max(pos.x, max(pos.y, pos.z)) > 1.0) {
			result.color = vec4(0.0);
			return result;
		}
		k = K(pos);
		if (k > 1.0) break;
		s = s+max(1.0-k, 0.25);
	}

	if (s < maxSteps) {
		for (int i = 0; i < 9; i++){
			dir = dir*0.5;
			if (k > 1.0)  pos = pos-dir;
			else pos = pos+dir;
			k = K(pos);
		}
	} else {
		result.color = vec4(0.0, 0.0, 0.0, 0.0);
		result.pos = pos;
	}

	vec3 normal = N(pos);

	float alpha = 0.0;
	if (k >= 0.0) alpha = 1.0;

	vec3 lightDir = vec3(0.5, 0.65, 1.0);
	float bri = dot(normalize(lightDir), normal);
//	bri = 1.0;

	vec3 evec = normalize(e);
	vec3 reflVec = reflect(-evec, normal);
	vec2 xy = vec3toxy(reflVec);
	vec3 reflColor = 1.0-texture2D(tex2d, xy).rgb;

	//return vec4(normal, alpha);
	result.color = vec4(reflColor*bri, alpha);
	result.pos = pos;
	result.normal = normal;

	#ifdef AMBOCC
		if (alpha >= 0.0) {
			float ambbri = 1.0;
			for (float i = 0.0; i < amboccsteps; i += 1.0) {
				vec3 ambdir = normalize(randomi(vec2(i*1.139, i*1.554), i*1.327));
				//ambdir = reflect(ambdir, normal);
				ambdir *= 0.02*sign(dot(ambdir, normal));
				vec3 ambstep = ambdir;
				ambdir += ambstep*4.0;

				for (float j = 0.0; j < amboccsubsteps; j += 1.0) {
					float ambval = K(pos+ambdir);
					if (ambval > 1.0) {
						ambbri -= 1.0/amboccsteps*1.5 ;//** ((amboccsubsteps-j)/amboccsubsteps);
						break;
					}
					ambdir += ambstep;
				}
			}
			result.color.xyz *= 0.5+0.5*ambbri;
		}
	#endif

	return result;
}


mResult fogmarch(vec3 e, vec3 dir) {
	float k = 0.0;
	float s = 1.0;
	vec3 pos = vec3(0.0);

	mResult result;
	result.normal = vec3(0.0, 1.0, 0.0);

	for (; s < MAXSTEPS; ) {
		pos = e+dir*s;
		result.pos = pos;
/*		if (min(pos.x, min(pos.y, pos.z)) < -1.0 || max(pos.x, max(pos.y, pos.z)) > 1.0) {
			result.color.x /= result.color.a;
			return result;
		}*/
		k = K(pos);
		result.color.a += 0.125*0.75;
		result.color.x += k;
		s += 1.0;
	}

	result.color.x /= result.color.a;
	result.color.a = result.color.x*realfogmix;
	return result;
}



void main(void) {
//	vec3 pos = vec3(0.0, 0.0, 0.0);

	//e = -e;
	vec3 eye = normalize(e);
/*	if (eye.x == 0.0) eye.x = 0.01;
	if (eye.y == 0.0) eye.y = 0.01;
	if (eye.z == 0.0) eye.z = 0.01;*/

	float tx = max((1.0-p.x)/eye.x, (-1.0-p.x)/eye.x);
	float ty = max((1.0-p.y)/eye.y, (-1.0-p.y)/eye.y);
	float tz = max((1.0-p.z)/eye.z, (-1.0-p.z)/eye.z);
	float tlen = min(tx, min(ty, tz));
	vec3 pos = p + tlen*eye;

	vec3 dir = -eye;
	vec3 finalPos = p;

	vec4 fcol = vec4(0.0, 0.0, 0.0, 1.0);
/*	if (fog < 0.99)*/ {
		mResult m = march(pos, dir*STEP, MAXSTEPS);
		fcol = m.color;
		finalPos = m.pos;
	}

	if (fcol.a < 1.0) discard;

	if (fog > 0.01) {
		mResult f = fogmarch(pos, dir*STEP*0.75);
		fcol = mix(fcol.rgba, f.color.xxxa*fcol.rgba, fog);
	}

/*	vec4 iproj = gl_ModelViewProjectionMatrix * (wv+vec4(finalPos-p.xyz, 0.0));
	gl_FragData[1] = vec4(iproj.z);
	iproj.z /= iproj.w;
	gl_FragDepth = (iproj.z+1.0)/2.0;*/
	//gl_FragDepth = wp.z;

	gl_FragData[0] = fcol;

}


