#include version.txt

varying vec2 Texcoord;
uniform sampler2D vu_values;
uniform float num_values;
uniform float multiplier;

void main()
{
	vec4 color = vec4(0.0);
	float tex_step = 1.0 / num_values;

	for(float i = 0.0; i < 1.0; i += tex_step) {
		if(Texcoord.x > i && Texcoord.x < (i + tex_step)) {
			if(Texcoord.y <= texture2D(vu_values, vec2(i, 0.0)).r * multiplier) {
//				color = vec4(texture2D(vu_values, vec2(i, 0.0)).r, 0.0, 0.0, 1.0);
				color = vec4(1.0, 0.0, 0.0, 1.0);
			}
			else {
				color = vec4(0.0, 0.0, 0.0, 1.0);
			}
		}
	}

	gl_FragColor = color;
}
