#include version.txt

uniform sampler2D Texture;
varying vec2 texCoord;
uniform float viewportStep;

void main(void)
{
	vec4 sum;
	sum = texture2D(Texture, texCoord.xy);
	// Right
	sum += texture2D(Texture, texCoord.xy + vec2(viewportStep, 0.0));
	sum += texture2D(Texture, texCoord.xy + vec2(viewportStep*2.0, 0.0));
	sum += texture2D(Texture, texCoord.xy + vec2(viewportStep*3.0, 0.0));
	sum += texture2D(Texture, texCoord.xy + vec2(viewportStep*4.0, 0.0));
	// Left
	sum += texture2D(Texture, texCoord.xy + vec2(-viewportStep, 0.0));
	sum += texture2D(Texture, texCoord.xy + vec2(-viewportStep*2.0, 0.0));
	sum += texture2D(Texture, texCoord.xy + vec2(-viewportStep*3.0, 0.0));
	sum += texture2D(Texture, texCoord.xy + vec2(-viewportStep*4.0, 0.0));
	gl_FragColor = sum / 9.0;
}
