varying vec3 lightVec;
varying vec3 eyeVec;
varying vec2 texCoord,texCoord2,texCoord3;
uniform sampler2D t1,t2,t3,ao_texture;
uniform float v1; 
uniform float dist;
uniform float texturescale;
uniform float uv_map;
uniform sampler2D reflection;
uniform float reflect_amount;
varying vec3 normal;
varying vec4 v_position;
varying vec3 v_normal;

uniform int AO_ENABLED;
vec3 packFloatToVec3i(const float value)
{
	const vec3 bitSh = vec3( 256.0 * 256.0, 256.0, 1.0);
	const vec3 bitMsk = vec3( 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0);
	vec3 res = fract(value * bitSh);
	res -= res.xxy * bitMsk;
	return res;
}

float unpackFloatFromVec4i(const vec3 value)
{
	const vec3 bitSh = vec3( 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);
	return(dot(value, bitSh));
}

vec4 shade(vec2 txcoord)
{
	vec4 ret;
	float invRadius=.1/(1.0+dist);
	float distSqr = dot(lightVec, lightVec),a;
	float att = clamp(1.0 - invRadius * sqrt(distSqr), 0.0, 1.0);
	vec3 lVec = lightVec * inversesqrt(distSqr);
	vec3 vVec = normalize(eyeVec);
	vec4 base = texture2D(t1, txcoord);
	vec3 bump = normalize( texture2D(t2, txcoord).xyz * 2.0 - 1.0);
	vec4 vAmbient = gl_LightSource[0].ambient * gl_FrontMaterial.ambient;
	float diffuse = max( dot(lVec, bump), 0.0 );
	vec4 vDiffuse = gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse * diffuse;	
	float specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess );
	vec4 vSpecular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specular;	
	a=float(texture2D(t3,texCoord.xy).xyz);
	ret=vec4((( vAmbient*base + vDiffuse*base + vSpecular) * att).rgb,a);
	return ret;
}

vec4 reflect_shade(vec2 xy)
{
vec4 ret;
vec3 nor;
	nor=(texture2D(t2,xy).rgb-.5)/4.0;
	
	ret=texture2D(reflection,(normal.xy/2.0-.5)+nor.xy)+texture2D(t1,xy)/2.0;
return ret;
}

void main ()
{

	if(AO_ENABLED==0)
	{
	vec4 col=uv_map*shade(texCoord);
	col+=(1.0-uv_map)*vec4(1.0-reflect_amount)*(shade(texCoord2*texturescale)+shade(texCoord3*texturescale));
	
	col+=(1.0-uv_map)*vec4(reflect_amount)*(+reflect_shade(texCoord2*texturescale)+reflect_shade(texCoord3*texturescale));

	col/=1.5;
	if(col.a<v1)
	discard;
	else
	gl_FragColor = texture2D(ao_texture,texCoord)*col;
	}
	if(AO_ENABLED==1)
	{
		gl_FragColor=vec4(packFloatToVec3i(float(v_position.z)/500.0),1.0);
	}
	if(AO_ENABLED==2)
	{
		gl_FragColor=vec4(vec3(.5)*(v_normal+vec3(1)),1.0);
	}
}
