    #version 120 
    #extension GL_EXT_bindable_uniform : enable 
    #extension GL_EXT_gpu_shader4 : enable 
#define tex2D texture2D
uniform mat4 ProjectionMatrix;


varying vec3 normal;
uniform float PosY;
uniform float ttimer1;
uniform float ttimer2;
uniform float ttime;
uniform float randomize;
uniform float Offset;
uniform float IsBox;
uniform float IsBird;

varying vec4 projection_position;

varying vec4 ShadowPosZ;
varying vec4 Color;
uniform sampler2D texture2d_1;
varying vec2 UVcoordinates;

varying vec4 projection_from_camera;
varying vec4 TheGoodPosition;

void main()
{
mat4 Billboard;


TheGoodPosition=gl_Vertex.xyzz;
vec4 glVertex= gl_Vertex;
vec2 TheUV;




// interpolant based on vertex
float ffup=(-0.9+6.0*ttimer1)-(gl_Vertex.z)*0.327;
ffup=clamp (ffup,0.0,1.0);
if (IsBox<0.5)
{ 
// vertex transformations
///{ 
vec2 TheUV1=gl_Vertex.zx*Offset*0.0015*vec2 (1.0,5.0)+0.008*vec2 (ttime);
//vec2 (PosY)*PosY*0.01;

//float displacement=clamp (abs(ffup*(tex2D (texture2d_1,TheUV1).x-0.11)*131.0),0.0,1.0);
float displacement=clamp ((ffup*(tex2D (texture2d_1,TheUV1).x-0.44)*3.2),-1.0,1.0)*0.65;
float displacement2=ffup;
displacement=displacement+(displacement2-displacement)*ttimer2;

glVertex.y*=displacement;
//glVertex.y+=-(1.0-displacement)*1.9;


 TheUV1=gl_Vertex.zx*Offset*0.0015*vec2 (1.0,1.0)+0.007*vec2 (ttime);
 displacement=clamp ((ffup*(tex2D (texture2d_1,TheUV1).x-0.20)*2.5),-1.0,1.0)*1.00;
displacement2=ffup;
displacement=displacement+(displacement2-displacement)*ttimer2;

glVertex.z*=displacement;

TheUV1=gl_Vertex.zy*Offset*0.0015*vec2 (1.0,1.0)+0.005*vec2 (ttime);
 displacement=clamp ((ffup*(tex2D (texture2d_1,TheUV1).x-0.20)*2.5),-1.0,1.0)*0.65;
displacement2=ffup;
displacement=displacement+(displacement2-displacement)*ttimer2;

glVertex.x*=displacement;

//glVertex.z+=-(1.0-displacement)*12.9;
}



if (IsBird>0.5)
{
vec3 TPos=glVertex.xyz;

float Ttheta=(abs(glVertex.x)+0.00)*0.06;
Ttheta=clamp (Ttheta,0.0,1.0);
//Ttheta*=Ttheta;
float mult=1.0;
if (glVertex.x<0.0) mult=-1.0;

float ttimee=float(int(ttime*12.0))/12.0;

float Rot=2.35*sin(ttimee*3.5)+0.5;
Ttheta*=Rot*mult;

float Tth1=cos (Ttheta);
float Tth2=-sin (Ttheta);
float Tth3=sin (Ttheta);
float Tth4=cos (Ttheta);


vec3 NTPos;
NTPos.x=Tth1*TPos.x+Tth2*TPos.y;
NTPos.y=Tth3*TPos.x+Tth4*TPos.y;

glVertex.x=NTPos.x;
glVertex.y=NTPos.y;

}




// Object transf
glVertex= gl_TextureMatrix[0] * glVertex;




///}


// scale / vectorize normals

///	vec3 normalB=normalize (gl_Normal);
///float nx=normalB.x; float ny=normalB.y; float nz=normalB.z;
///for (int r=0;r<4;r++) { 
///if (nx>0.0) nx=nx*nx; else nx=-nx*nx;
///if (ny>0.0) ny=ny*ny; else ny=-ny*ny;
///if (nz>0.0) nz=nz*nz; else nz=-nz*nz ;
///}
///normalB=vec3 (nx,ny,nz);





projection_position=glVertex;
gl_Position =  glVertex;


// texture coordinates
UVcoordinates=gl_Position.xz*0.2;






	vec3 Tnormal=normalize (gl_Normal);
Tnormal=abs (Tnormal);
UVcoordinates=gl_Position.zx*0.11;

if ((Tnormal.x>Tnormal.y) && (Tnormal.x>Tnormal.z)) {
	{
		UVcoordinates=gl_Position.zy*0.21;
	}

	
	
	}
	if ((Tnormal.y>Tnormal.z) && (Tnormal.y>Tnormal.x)) UVcoordinates=gl_Vertex.zx*0.31;
if ((Tnormal.z>Tnormal.x) && (Tnormal.z>Tnormal.y)) UVcoordinates=gl_Vertex.xy*0.61;


if (IsBox>1.5)
UVcoordinates=gl_Vertex.xy*1.2*vec2 (10.0,1.0);


	//UVcoordinates=gl_Position.xy*0.21;


///UVcoordinates = vec2(gl_MultiTexCoord0);

// discretize vertices
///{ 
gl_Position.y=float (int (3.7*gl_Position.y))/3.7+gl_Position.y*0.001;
gl_Position.z=float (int (3.7*gl_Position.z))/3.7+gl_Position.z*0.001;
gl_Position.x=float (int (3.7*gl_Position.x))/3.7+gl_Position.x*0.001;
///}



// final projection
gl_Position = gl_ModelViewProjectionMatrix * gl_Position;
projection_from_camera=gl_Position;



// instancing
///gl_Position.y+=1.0*gl_InstanceID;

// vertex instancing
///if (gl_VertexID==244) gl_Position.y+=1.0;



// Transforming The Normal To ModelView-Space
normal = gl_NormalMatrix *  gl_Normal; 

// color pass
Color=gl_Color;


ShadowPosZ= ProjectionMatrix *glVertex;
ShadowPosZ=gl_TextureMatrix[2]*glVertex;

// point size
///gl_PointSize =120.0/gl_Position.w;
}











