#version 330 core

uniform sampler2D normal_depth;
uniform sampler2D particle;
uniform sampler2D lut;

uniform vec2 viewport;

in vec3 wpos;
in vec3 params; // alpha, radius, energy
in vec2 uv;

layout (location = 0) out vec4 frag_color;

#include <gbuffer_include.frag>

void main()
{
	vec4 pcolor = texture(particle, uv) * vec4(params.xxx, 1.0);
	if ( pcolor.a < 0.0001 ) discard;

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);

	if ( pos.z > wpos.z ) discard;

	float alpha = clamp(wpos.z - pos.z, 0.0, 1.0);
	frag_color = pcolor*texture(lut, params.zx)*alpha;
}
