#version 330 core

uniform sampler2D diffuse_specular;
uniform vec2 viewport;

in vec3 color;

layout (location = 0) out vec4 frag_color;


void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture2D(diffuse_specular, uv_pos);

	vec3 lit = ds.rgb*color;
	frag_color = vec4(lit, length(lit));
}
