#glInterface = "pyopengl"
glInterface = "pyglet"
if glInterface == "pyopengl":
  print "ready"
  from OpenGL.GL import *
elif glInterface == "pyglet":

  import pyglet
  pyglet.options['debug_gl'] = False
  from pyglet.gl import *
  import pyglet.gl as gl
  import pyglet.gl as raw
  import pyglet.gl as fbo
  import pyglet.gl as pds
  from ctypes import *

  def glTexCoord2dv(l):
      gl.glTexCoord2d(l[0], l[1])

  def glTexCoord3dv(l):
      gl.glTexCoord3d(l[0], l[1], l[2])

  def glTexCoord2fv(l):
      gl.glTexCoord2f(l[0], l[1])

  def glTexCoord3fv(l):
      gl.glTexCoord3f(l[0], l[1], l[2])

  def glGenTextures(x):
    l = c_ulong()
    gl.glGenTextures(x, byref(l))
    return l.value

  def glGenBuffers(x):
    l = c_ulong()
    gl.glGenBuffers(x, byref(l))
    return l.value

  def glBufferData(t, d, u):
    gl.glBufferData(t, len(d), d, u)

  def glTranslate(x,y,z):
    gl.glTranslatef(x,y,z)

  def glColor(r,g,b,a=None):
    if a is not None:
      gl.glColor4f(r,g,b,a)
    else:
      gl.glColor3f(r,g,b)

  glRotate = gl.glRotatef
  glScale = gl.glScalef
  #def glRotate(a,x,y,z):
  #  glRotatef(a,x,y,z)
  
  def glShaderSourceARB(handle, source):
    #l = source[0].split('\n')
    buffer = create_string_buffer(source[0])
    src = cast(pointer(pointer(buffer)), POINTER(POINTER(GLchar)))
    gl.glShaderSourceARB(handle, 1, src, None)

  def glGetObjectParameterivARB(handle, type):
    i = c_long(0)
    gl.glGetObjectParameterivARB(handle, type, byref(i))
    return i.value

  def glGetInfoLogARB(handle):
    s = c_char_p("")
    slength = c_int()
    gl.glGetInfoLogARB(handle, c_int(100000), byref(slength), s) 
    return s.value
      
  def glGenFramebuffersEXT(n):
    l = c_ulong()
    gl.glGenFramebuffersEXT(n, byref(l))
    return l.value
    
  def glMaterial(face, pname, param):
    if pname == GL_SHININESS:
      glMaterialf(face, pname, param)
    elif pname in (GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_EMISSION, GL_SHININESS, GL_AMBIENT_AND_DIFFUSE, GL_COLOR_INDEXES):
      a = pointer((GLfloat*4)(*param))
      glMaterialfv(face, pname, cast(a, POINTER(GLfloat)))
 
  def glLight(n, pname, param):
    if pname in (GL_SPOT_EXPONENT, GL_SPOT_CUTOFF, GL_CONSTANT_ATTENUATION, GL_LINEAR_ATTENUATION, GL_QUADRATIC_ATTENUATION):
      glLightf(n, pname, param)
    elif pname in (GL_AMBIENT, GL_DIFFUSE, GL_SPECULAR, GL_POSITION, GL_SPOT_CUTOFF, GL_SPOT_DIRECTION, GL_SPOT_EXPONENT, GL_CONSTANT_ATTENUATION,GL_LINEAR_ATTENUATION, GL_QUADRATIC_ATTENUATION):
      a = pointer((GLfloat*4)(*param))
      glLightfv(n, pname, cast(a, POINTER(GLfloat)))

else:
  raise "No glInterface specified"