# -*- coding: utf-8 -*-
'''

Mögylööri by Rage Manifesto

Greets:

Jonathan Hartley
pyglet tutorial at http://tartley.com/?p=250 - A good tutorial & example, utilized here

Alex Holkner and Richard Jones
(space invaders in 40mins tutorial) - though I did not have enough time to utilize any tricks from it


'''

from __future__ import division
from random import uniform
import math
import time
from pyglet import clock, font, image, window
from pyglet.gl import *

#vilkuttimen importit
from socket import *
from struct import *
import math
import time



class GradientTriangle(object):

    frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
    rotationParameter = 0.0
    levitationParameter = 0.0
    sinkingSpeed = 1.0 * frameRateModifier

    def __init__(self, id, size, x, y, rot, color_a = 1.0, color_b = 1.0, color_c = 1.0):
        self.cornerColor_a = color_a
        self.cornerColor_b = color_b
        self.cornerColor_c = color_c
        self.id = id
        self.size = size
        self.x = x
        self.y = y
        self.rot = rot 
        
        if ( self.id < EffectWorld1.maxNumberOfTriangles-1 ):
            self.sinkingSpeed = uniform(0.2, 1.5) * self.frameRateModifier
        if ( self.id >= EffectWorld1.maxNumberOfTriangles-1 ):
            self.sinkingSpeed = -0.3 * self.frameRateModifier
            
        self.levitationParameter = uniform(-1.0, 1.0)
        
    def tick(self):
        
        if ( math.fabs(self.y) > 156 ):
            if ( self.id < EffectWorld1.maxNumberOfTriangles-1 ): #Normal triangle respawn parameters
                self.x = uniform(-15, 15)
                self.y = 150
                self.rotationParameter = uniform(0, 360)
                self.levitationParameter = uniform(-1.0, 1.0)
                self.sinkingSpeed = uniform(0.2, 1.0) * self.frameRateModifier
            if ( self.id >= EffectWorld1.maxNumberOfTriangles-1 ): #Blinking last triangle respawn parameters
                self.x = 0
                self.y = -150
                self.rotationParameter = uniform(0, 360)
                self.levitationParameter = uniform(-0.5, 0.5)
                self.sinkingSpeed = -0.3 * self.frameRateModifier
            
        if ( self.id >= EffectWorld1.maxNumberOfTriangles-1 ):
            self.cornerColor_a = uniform(0.0, 1.0)
            self.cornerColor_b = uniform(0.0, 1.0)
            self.cornerColor_c = uniform(0.0, 1.0)
                           
        #Changes in rotation
        self.rotationParameter += 0.03
        self.rot = 600 * math.sin(self.rotationParameter) * self.frameRateModifier
        
        #Vertical sinking speed
        if ( self.id < EffectWorld1.maxNumberOfTriangles-1 ): #Bahavior for norman triangles
            self.sinkingSpeed += 0.01
            self.y -= self.sinkingSpeed
            
        if ( self.id >= EffectWorld1.maxNumberOfTriangles-1 ): #Behavior for the last special triangle
            self.sinkingSpeed -=0.01
            self.y -= self.sinkingSpeed  * self.frameRateModifier
                   
        #Changes in horizontal movement
        rand = uniform(0, 30)
        if (rand == 0):
            self.levitationParameter = self.levitationParameter * -1
        self.x += self.levitationParameter * 1.5  * self.frameRateModifier
        
    def draw(self):
        self.tick() #Calculates changes in object's movement and orientation before drawing
        glLoadIdentity() #Reset the matrix
        glTranslatef(self.x, self.y, 0.0) 
        glRotatef(self.rot * self.frameRateModifier, 0, 0, 10) 
        glScalef(self.size, self.size, 1.0)
        glBegin(GL_TRIANGLES)
        glColor4f(self.cornerColor_a, self.cornerColor_b, self.cornerColor_c, 0.0)
        glVertex2f(0.0, 0.6)
        glColor4f(self.cornerColor_b, self.cornerColor_a, self.cornerColor_c, 1.0)
        glVertex2f(0.6, -0.4)
        glColor4f(self.cornerColor_c, self.cornerColor_b, self.cornerColor_a, 1.0)
        glVertex2f(-0.6, -0.4)        
        glEnd()
              


class EffectWorld1(object):   #raining triangles
  
    maxNumberOfTriangles = 30

    def __init__(self, winWidthHeight):
        
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
        self.winWidthHeight = winWidthHeight
        self.triangles = {}
        self.nextTriangleId = 0
        clock.schedule_interval(self.spawnTriangle, 0.25)
               
    def spawnTriangle(self, dt):
        triangleCornerColor_a = uniform(0.0, 1.0)
        triangleCornerColor_b = uniform(0.0, 1.0)
        triangleCornerColor_c = uniform(0.0, 1.0)
        
        size = uniform(20.0, 50.0)
        x = uniform( (self.winWidthHeight[0]/2)-25, (self.winWidthHeight[0]/2)+25 )
        y = uniform( (self.winWidthHeight[1]/2)-25, (self.winWidthHeight[1]/2)+25 )
        rot = uniform(0.0, 360.0)
        ent = GradientTriangle(self.nextTriangleId, size, x, y, rot, triangleCornerColor_a, triangleCornerColor_b, triangleCornerColor_c)
        self.triangles[ent.id] = ent
        self.nextTriangleId += 1

    def draw(self):
        #print('drawing effect1')       
        glClear(GL_COLOR_BUFFER_BIT) #Clears the color buffer to preset values
        glMatrixMode(GL_MODELVIEW) #Select the projection matrix
        glLoadIdentity() #Reset the projection matrix
        glClearColor(0, 0, 0, 0) #black background color
        
        if ( self.nextTriangleId >= self.maxNumberOfTriangles ):
            clock.unschedule(self.spawnTriangle);
        
        for ent in self.triangles.values():
            ent.draw()


class EffectWorld2(object):  #helloworld
    
    def __init__(self, winWidthHeight, picture):
        
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
        
        self.pictureToView = picture
        
        self.color_red = 254;
        self.color_green = 254;
        self.color_blue = 254;
             
        self.colorfuckupswitch = 0;
        self.colorAddition = -1;
        self.colorList = [self.color_red, self.color_green, self.color_blue]
                
        self.winWidthHeight = winWidthHeight
        self.kuva_helloworld = pyglet.image.load(self.pictureToView)
        self.kuva_helloworld.anchor_x = self.kuva_helloworld.width // 2
        self.kuva_helloworld.anchor_y = self.kuva_helloworld.height // 2
        self.kuva01sprite = pyglet.sprite.Sprite(self.kuva_helloworld)
        
        self.kuva01sprite._set_scale(0.50)
        self.kuva01sprite.set_position(0,0)

        self.sineinput = 0.0
        self.sineinput2 = 0.0
        self.sineresult = 0.0
        
        self.pictureMovementFactor_x = 0
        self.pictureMovementFactor_y = 0

        self.pictureRotation = 0


    def fuckupcolors(self):
    

        if (self.colorList[self.colorfuckupswitch] >= 128):
            self.colorList[self.colorfuckupswitch] = self.colorList[self.colorfuckupswitch] + self.colorAddition
        if (self.colorList[self.colorfuckupswitch] == 128):
            self.colorAddition = 1 
        if (self.colorList[self.colorfuckupswitch] == 255):
            self.colorAddition = -1
            if (self.colorfuckupswitch < 3):
                self.colorfuckupswitch = self.colorfuckupswitch + 1
            if (self.colorfuckupswitch == 3):
                self.colorList[0] = 254
                self.colorList[1] = 254
                self.colorList[2] = 254
                self.colorfuckupswitch = 0
    
               
        
    def draw(self):
        glClearColor(0, 0, 0, 0) #black background color
        glMatrixMode(GL_PROJECTION)
        glTranslatef(0.0,0.0,0.0)
        
        self.sineinput = self.sineinput + 0.025
        self.sineinput2 = self.sineinput2 + 0.01
                
        self.kuva01sprite._set_scale( math.sin(self.sineinput) ) 
        
        self.fuckupcolors()       
        self.kuva01sprite._set_color(self.colorList)
        
        self.pictureRotation += ( 1.5 + ( math.sin(self.sineinput) * 5 )  * self.frameRateModifier ) 
        self.kuva01sprite._set_rotation( self.pictureRotation )
        if ( self.pictureRotation >= 360 ):
            self.pictureRotation = 0
        
        
        self.pictureMovementFactor_x = math.sin(self.sineinput) * (200 + math.sin(self.sineinput2))
        self.pictureMovementFactor_y = math.sin(self.sineinput2) * (160)
        self.kuva01sprite.set_position(self.pictureMovementFactor_x  * self.frameRateModifier, self.pictureMovementFactor_y  * self.frameRateModifier)
        
        self.kuva01sprite.draw()   



class SprCircle():
    
    def __init__(self, rot, pos_x, pos_y, mov_x, mov_y, color_r, color_g, color_b, winWidthHeight):
        
        self.rotation = 0
        self.rotationSpeed = rot
        self.color_rgb = [color_r, color_g, color_b]
        self.position_x = pos_x
        self.position_y = pos_y
        self.movement_x = mov_x
        self.movement_y = mov_y
        self.initialScale = 0.1
        self.scaleChangeFactor = 0.01
        self.scale = self.initialScale      
        
        
        self.kuva_circle = pyglet.image.load('data/circle.png')
        self.kuva_circle.anchor_x = self.kuva_circle.width // 2
        self.kuva_circle.anchor_y = self.kuva_circle.height // 2
        self.circleSprite = pyglet.sprite.Sprite(self.kuva_circle)
        
        self.circleSprite._set_scale(self.initialScale) 
        self.circleSprite.set_position(self.position_x, self.position_y)
        self.circleSprite._set_color(self.color_rgb)


    def tick(self):
        self.position_x += self.movement_x
        self.position_y += self.movement_y
        self.rotation = self.rotationSpeed + self.rotation
        self.scale += self.scaleChangeFactor
        self.circleSprite._set_scale(self.scale)
        
        self.circleSprite.set_position(self.position_x, self.position_y)
        self.circleSprite._set_rotation(self.rotation*10)
        


    def draw(self):
        self.tick() #Calculates changes in object's movement and orientation before drawing
        
       # if ( self.rotationSpeed < 990 ):
        #    glClear(GL_COLOR_BUFFER_BIT)
        
        #glLoadIdentity() #Reset the matrix
        #glTranslatef(self.x, self.y, 0.0) 

        self.circleSprite.draw() 

   

class EffectWorld6(object):  #greetz circles
    
    def __init__(self, winWidthHeight):
        
        self.greetCircleDistFromCenter = 100
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
                        
        self.winWidthHeight = winWidthHeight
        self.kuva_greetz0 = pyglet.image.load('data/greetz0circle.png')
        self.kuva_greetz1 = pyglet.image.load('data/greetz1circle.png')
        self.kuva_greetz2 = pyglet.image.load('data/greetz2circle.png')
        self.kuva_greetz3 = pyglet.image.load('data/greetz3circle.png')
        self.kuva_greetz4 = pyglet.image.load('data/greetz4circle.png')
        
        self.kuva_greetz0.anchor_x = self.kuva_greetz1.width // 2
        self.kuva_greetz0.anchor_y = self.kuva_greetz1.height // 2
        self.kuva_greetz1.anchor_x = self.kuva_greetz1.width // 2
        self.kuva_greetz1.anchor_y = self.kuva_greetz1.height // 2
        self.kuva_greetz2.anchor_x = self.kuva_greetz1.width // 2
        self.kuva_greetz2.anchor_y = self.kuva_greetz1.height // 2
        self.kuva_greetz3.anchor_x = self.kuva_greetz1.width // 2
        self.kuva_greetz3.anchor_y = self.kuva_greetz1.height // 2
        self.kuva_greetz4.anchor_x = self.kuva_greetz1.width // 2
        self.kuva_greetz4.anchor_y = self.kuva_greetz1.height // 2
        
        self.greetz00sprite = pyglet.sprite.Sprite(self.kuva_greetz0)
        self.greetz01sprite = pyglet.sprite.Sprite(self.kuva_greetz1)
        self.greetz02sprite = pyglet.sprite.Sprite(self.kuva_greetz2)
        self.greetz03sprite = pyglet.sprite.Sprite(self.kuva_greetz3)
        self.greetz04sprite = pyglet.sprite.Sprite(self.kuva_greetz4)
        
        self.greetz00sprite._set_scale(0.35)
        self.greetz01sprite._set_scale(0.5)
        self.greetz02sprite._set_scale(0.5)
        self.greetz03sprite._set_scale(0.5)
        self.greetz04sprite._set_scale(0.5)
        
        
        self.greetz00sprite.set_position(0 ,0)
        self.greetz01sprite.set_position(self.greetCircleDistFromCenter , self.greetCircleDistFromCenter)
        self.greetz02sprite.set_position(-self.greetCircleDistFromCenter , self.greetCircleDistFromCenter)
        self.greetz03sprite.set_position(self.greetCircleDistFromCenter , -self.greetCircleDistFromCenter)
        self.greetz04sprite.set_position(-self.greetCircleDistFromCenter , -self.greetCircleDistFromCenter)
        
        self.greetz0_rotationAmount = 0
        self.greetz1_rotationAmount = 0
        self.greetz2_rotationAmount = 0
        self.greetz3_rotationAmount = 0
        self.greetz4_rotationAmount = 0
        
        greetz00colors = (255,255,255)
        greetz01colors = (255,255,0)
        greetz02colors = (0,255,255)
        greetz03colors = (255,0,255)
        greetz04colors = (128,255,128)
        
        
        
        self.greetz00sprite._set_color(greetz00colors)
        self.greetz01sprite._set_color(greetz01colors)
        self.greetz02sprite._set_color(greetz02colors)
        self.greetz03sprite._set_color(greetz03colors)
        self.greetz04sprite._set_color(greetz04colors)
        
        self.rotationAmountModifierInput = 0
        self.baseRotationAmount = 0
        
              
        
    def draw(self):
        
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        glClearColor(0, 0, 0, 0) #black background color
        glMatrixMode(GL_PROJECTION)
        glTranslatef(0.0,0.0,0.0)
              
        #self.greetz01sprite.set_position(self.winWidthHeight[0] / 2, self.winWidthHeight[1] / 2)
        #self.greetz01sprite.set_position(self.winWidthHeight[0] / 5, self.winWidthHeight[1] / 4)
        #self.greetz01sprite._set_scale(0.75)
        
        self.rotationAmountModifierInput += 0.01
        
        
        self.greetz0_rotationAmount = self.baseRotationAmount + self.greetz0_rotationAmount + (math.fabs(math.sin(self.rotationAmountModifierInput)))
        self.greetz00sprite._set_rotation(self.greetz0_rotationAmount)      
        self.greetz00sprite.draw()   
        
        self.greetz1_rotationAmount = self.baseRotationAmount + self.greetz1_rotationAmount + (math.fabs(math.sin(self.rotationAmountModifierInput + 0.5)))
        self.greetz01sprite._set_rotation(self.greetz1_rotationAmount)      
        self.greetz01sprite.draw() 
        
        self.greetz2_rotationAmount = self.baseRotationAmount + self.greetz2_rotationAmount + (math.fabs(math.sin(self.rotationAmountModifierInput + 0.5)))
        self.greetz02sprite._set_rotation(self.greetz2_rotationAmount)      
        self.greetz02sprite.draw() 
        
        self.greetz3_rotationAmount = self.baseRotationAmount + self.greetz3_rotationAmount + (math.fabs(math.sin(self.rotationAmountModifierInput + 0.5)))
        self.greetz03sprite._set_rotation(self.greetz3_rotationAmount)      
        self.greetz03sprite.draw() 
        
        self.greetz4_rotationAmount = self.baseRotationAmount + self.greetz4_rotationAmount + (math.fabs(math.sin(self.rotationAmountModifierInput + 0.5)))
        self.greetz04sprite._set_rotation(self.greetz4_rotationAmount)      
        self.greetz04sprite.draw() 
    
 
class Loading(object):  #demofiller
    
    def __init__(self, winWidthHeight):
        
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
        

        self.winWidthHeight = winWidthHeight
        self.loadingimg = pyglet.image.load('data/loading.png')
        self.loadingimg.anchor_x = self.loadingimg.width // 2
        self.loadingimg.anchor_y = self.loadingimg.height // 2
        self.loadingSprite = pyglet.sprite.Sprite(self.loadingimg)
        
        self.loadingSprite._set_scale(0.50)
        self.loadingSprite.set_position(0,0)
               
        
    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        glClearColor(0, 0, 0, 0) #black background color
        glMatrixMode(GL_PROJECTION)
        glTranslatef(0.0,0.0,0.0)
                
        self.loadingSprite.draw()   


class Beginning(object):  #starting creditz etc.
    
    def __init__(self, winWidthHeight):
        
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
        

        self.winWidthHeight = winWidthHeight
        self.manifestoimg = pyglet.image.load('data/ragemanifesto.png')
        self.manifestoimg.anchor_x = self.manifestoimg.width // 2
        self.manifestoimg.anchor_y = self.manifestoimg.height // 2
        self.manifestoSprite = pyglet.sprite.Sprite(self.manifestoimg)
        
        self.manifestoSprite._set_scale(0.50)
        self.manifestoSprite.set_position(0,0)
                           
        
    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        glClearColor(0, 0, 0, 0) #black background color
        glMatrixMode(GL_PROJECTION)
        glTranslatef(0.0,0.0,0.0)
             
        self.manifestoSprite.draw()   
       

class Title(object):  #starting startingtitles
    
    def __init__(self, winWidthHeight):
        
        self.spriteScale = 0.4
        
        self.titleStartingTime = time.time()
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
        

        self.winWidthHeight = winWidthHeight
        self.title00img = pyglet.image.load('data/mogyloori00.png')
        self.title00img.anchor_x = self.title00img.width // 2
        self.title00img.anchor_y = self.title00img.height // 2
        self.title00Sprite = pyglet.sprite.Sprite(self.title00img)       
        self.title00Sprite._set_scale(self.spriteScale)
        self.title00Sprite.set_position(0,0)
        
        self.title01img = pyglet.image.load('data/mogyloori01.png')
        self.title01img.anchor_x = self.title01img.width // 2
        self.title01img.anchor_y = self.title01img.height // 2
        self.title01Sprite = pyglet.sprite.Sprite(self.title01img)       
        self.title01Sprite._set_scale(self.spriteScale)
        self.title01Sprite.set_position(0,0)
        
        self.title02img = pyglet.image.load('data/mogyloori02.png')
        self.title02img.anchor_x = self.title02img.width // 2
        self.title02img.anchor_y = self.title02img.height // 2
        self.title02Sprite = pyglet.sprite.Sprite(self.title02img)       
        self.title02Sprite._set_scale(self.spriteScale)
        self.title02Sprite.set_position(0,0)
        
        self.title03img = pyglet.image.load('data/mogyloori03.png')
        self.title03img.anchor_x = self.title03img.width // 2
        self.title03img.anchor_y = self.title03img.height // 2
        self.title03Sprite = pyglet.sprite.Sprite(self.title03img)       
        self.title03Sprite._set_scale(self.spriteScale)
        self.title03Sprite.set_position(0,0)
        
        self.title04img = pyglet.image.load('data/mogyloori04.png')
        self.title04img.anchor_x = self.title04img.width // 2
        self.title04img.anchor_y = self.title04img.height // 2
        self.title04Sprite = pyglet.sprite.Sprite(self.title04img)       
        self.title04Sprite._set_scale(self.spriteScale)
        self.title04Sprite.set_position(0,0)
        
        self.titleSpritet = (self.title00Sprite, self.title01Sprite, self.title02Sprite, self.title03Sprite, self.title04Sprite)
        self.aktiivinenSprite = None                
        
    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        glClearColor(0, 0, 0, 0) #black background color
        glMatrixMode(GL_PROJECTION)
        glTranslatef(0.0,0.0,0.0)
             
        if ( self.titleStartingTime + 8 <= time.time() ):             
            self.aktiivinenSprite = self.titleSpritet[0]
            
        if ( self.titleStartingTime + 10 <= time.time() ):
            self.aktiivinenSprite = self.titleSpritet[1]
            
        if ( self.titleStartingTime + 12 <= time.time() ):
            self.aktiivinenSprite = self.titleSpritet[2] 
            
        if ( self.titleStartingTime + 13 <= time.time()  ):
            self.aktiivinenSprite = self.titleSpritet[3]
            
        if ( self.titleStartingTime + 14 <= time.time()  ):
            self.aktiivinenSprite = self.titleSpritet[4]
            
             
        self.aktiivinenSprite.draw()
             
             

class Lighthouse(object):  #starting startingtitles
    
    def __init__(self, winWidthHeight):
        
        self.spriteScale = 0.4
        
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
        

        self.winWidthHeight = winWidthHeight
        self.frame01img = pyglet.image.load('data/trollLighthouse003_frame0.png')
        self.frame01img.anchor_x = self.frame01img.width // 2
        self.frame01img.anchor_y = self.frame01img.height // 2
        self.frame01Sprite = pyglet.sprite.Sprite(self.frame01img)       
        self.frame01Sprite._set_scale(self.spriteScale)
        self.frame01Sprite.set_position(0,0)
        
        self.frame02img = pyglet.image.load('data/trollLighthouse003_frame1.png')
        self.frame02img.anchor_x = self.frame02img.width // 2
        self.frame02img.anchor_y = self.frame02img.height // 2
        self.frame02Sprite = pyglet.sprite.Sprite(self.frame02img)       
        self.frame02Sprite._set_scale(self.spriteScale)
        self.frame02Sprite.set_position(0,0)
        
   
        self.a = 1
        self.a_addition = 1
        
        self.lights = MuutaValot()
     
        
    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        glClearColor(0, 0, 0, 0) #black background color
        glMatrixMode(GL_PROJECTION)
        glTranslatef(0.0,0.0,0.0)
             
             
        if (self.a <= -14):
            self.a_addition = 1
            self.lights.update()
            
            
        if (self.a >= 14):
            self.a_addition = -1
            self.lights.update()
            
            
        if (self.a <= 0 & self.a > -15 ):
            self.frame01Sprite.draw()
            
        if ( self.a >= 0 & self.a <= 15 ):
            self.frame02Sprite.draw()
            
        self.a = self.a + self.a_addition
                         
            
             
        
             
             





class Beginning2(object):  #starting creditz etc.
    
    def __init__(self, winWidthHeight):
        
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)
        

        self.winWidthHeight = winWidthHeight
        self.techimg = pyglet.image.load('data/demotechniques.png')
        self.techimg.anchor_x = self.techimg.width // 2
        self.techimg.anchor_y = self.techimg.height // 2
        self.techSprite = pyglet.sprite.Sprite(self.techimg)
        
        self.scaleAmount = 0.40
        self.scaleModifierInput = 1
        
        self.techSprite._set_scale(self.scaleAmount)
        self.techSprite.set_position(0,0)
        
                           
        
    def draw(self):
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        glClearColor(0, 0, 0, 0) #black background color
        glMatrixMode(GL_PROJECTION)
        glTranslatef(0.0,0.0,0.0)
             
        self.scaleModifierInput += 0.05
        self.scaleAmount = self.scaleAmount + math.sin(self.scaleModifierInput)/40
             
        self.techSprite._set_scale(self.scaleAmount)
             
             
        self.techSprite.draw()   
       



class EffectWorld5(object):  #"Iris effect"
    
    def __init__(self, winWidthHeight):
        
        self.nextCircleId = 0
        self.circles_MAX = 1
              
        self.frameRateModifier = 0.5  # 1.0 for the default 30fps (limited)       
        self.winWidthHeight = winWidthHeight

        self.circles = {}
        #clock.schedule_interval(self.spawnCircle, 0.5)
        
        self.crotFunctionInput = 0
        self.crot = 0
        self.cpos_x = self.winWidthHeight[0] / 2
        self.cpos_y = self.winWidthHeight[1] / 2
        self.cmov_x = 0
        self.cmov_y = 0
        
        self.spawnerInt = 0

 
    def spawnCircle(self):
        self.crotFunctionInput += 0.5
        self.crot = math.fabs(math.sin(self.crotFunctionInput))
        self.ccolor_r = uniform(128,255)
        self.ccolor_g = uniform(128,255)
        self.ccolor_b = uniform(128,255)
        self.cpos_x = 0 + self.crot   
        self.cpos_y = 0 + self.crot  
        circ = SprCircle(self.crot, self.cpos_x, self.cpos_y, self.cmov_x, self.cmov_y, self.ccolor_r, self.ccolor_g, self.ccolor_b, self.winWidthHeight)        
        if (self.nextCircleId < self.circles_MAX):
            self.nextCircleId += 1
        if (self.nextCircleId == self.circles_MAX):
            self.nextCircleId = 0;
        
        self.circles[self.nextCircleId] = circ

        
    def draw(self):
        self.spawnerInt += 1
        
        if (self.spawnerInt == 100):
            self.spawnCircle()
            self.spawnerInt = 0
        
        glClearColor(0, 0, 0, 0) #black background color
        
        glMatrixMode(GL_PROJECTION)
        glTranslatef(0.0,0.0,0.0)
                
        for x in self.circles.values():
            if (x != None):
                x.draw()
            


class Cube(object):


    rotationRandomizer = 1.0

    def __init__(self, size, x, y, rot, winWidthHeight, xadd = 4.0, yadd = 5.0):
        self.size = size
        self.x = x
        self.y = y
        self.r = rot
        self.xAddition = xadd
        self.yAddition = yadd  
        self.winWidthHeight = winWidthHeight     
        self.x_maxDistanceFromEdge = winWidthHeight[0]/8 
        self.y_maxDistanceFromEdge = winWidthHeight[1]/8 
        
        
        
    def tick(self):
        
        self.x += self.xAddition
        
        if ( math.fabs(self.x) >= self.x_maxDistanceFromEdge ):
            self.xAddition = ( self.xAddition*-1 )
            self.rotationRandomizer = uniform(0.2, 5.0)
        
        self.y += self.yAddition
        
        if ( math.fabs(self.y) >= self.y_maxDistanceFromEdge ):
            self.yAddition = ( self.yAddition*-1 )
            self.rotationRandomizer = uniform(0.2, 5.0)
        
        
        dt = clock.tick()
        self.r = self.r + dt*90 * self.rotationRandomizer
        #print(self.r)
        
        if (self.r > 360):
            self.r = 0      
    

    def draw(self):
        
        self.tick()
        #glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        #glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        glMatrixMode(GL_MODELVIEW)
        glTranslatef(self.x, self.y, 1.0)
        #glRotatef(self.rot, 0, 0, 10)
        glScalef(self.size, self.size, 1.0)
        
        #Rotation
        glRotatef(self.r, 1, 0, 0)   # x_ang
        glRotatef(self.r, 0, 1, 0)   # y_ang
        glRotatef(self.r, 0, 0, 1)   # z_ang
        
        # Cube Coordinates
        glBegin(GL_QUADS)   # Draw The Cube Using quads
        glColor3f(0.0,1.0,0.0)      # Color Green
        glVertex3f( 1.0, 1.0,-1.0)
        glVertex3f(-1.0, 1.0,-1.0)
        glVertex3f(-1.0, 1.0, 1.0)
        glVertex3f( 1.0, 1.0, 1.0)
        glColor3f(1.0,0.5,0.0)
        glVertex3f( 1.0,-1.0, 1.0)
        glVertex3f(-1.0,-1.0, 1.0)
        glVertex3f(-1.0,-1.0,-1.0)
        glVertex3f( 1.0,-1.0,-1.0)
        glColor3f(1.0,0.0,0.0)      # Color Red
        glVertex3f( 1.0, 1.0, 1.0)
        glVertex3f(-1.0, 1.0, 1.0)
        glVertex3f(-1.0,-1.0, 1.0)
        glVertex3f( 1.0,-1.0, 1.0)
        glColor3f(1.0,1.0,0.0)
        glVertex3f( 1.0,-1.0,-1.0)
        glVertex3f(-1.0,-1.0,-1.0)
        glVertex3f(-1.0, 1.0,-1.0)
        glVertex3f( 1.0, 1.0,-1.0)
        glColor3f(0.0,0.0,1.0)      # Color Blue
        glVertex3f(-1.0, 1.0, 1.0)
        glVertex3f(-1.0, 1.0,-1.0)
        glVertex3f(-1.0,-1.0,-1.0)
        glVertex3f(-1.0,-1.0, 1.0)
        glColor3f(1.0,0.0,1.0)
        glVertex3f( 1.0, 1.0,-1.0)
        glVertex3f( 1.0, 1.0, 1.0)
        glVertex3f( 1.0,-1.0, 1.0)
        glVertex3f( 1.0,-1.0,-1.0)
        glEnd()                     # End Drawing The Cube


class EffectWorld4(object):  #glitchy cube

    maxNumberOfTriangles = 1
    beginTime = time.time()
    titleIndex = 0
    activeTitle = None

    def __init__(self, winWidthHeight):
        
        
        self.titleIndex = 0.0
        
        self.background_red_input = 0
        self.background_green_input = 0
        self.background_blue_input = 0
        
        self.background_red = 0
        self.background_green = 0
        self.background_blue = 0
        
        self.winWidthHeight = winWidthHeight
        self.cube = self.spawnGlitchCube()
        
        
        self.kuva_terrible0 = pyglet.image.load('data/empty.png')
        self.kuva_terrible0.anchor_x = self.kuva_terrible0.width // 2
        self.kuva_terrible0.anchor_y = self.kuva_terrible0.height // 2
        
        self.kuva_terrible1 = pyglet.image.load('data/megademo_terrible_raiskale01.png')
        self.kuva_terrible1.anchor_x = self.kuva_terrible1.width // 2
        self.kuva_terrible1.anchor_y = self.kuva_terrible1.height // 2
        
        self.kuva_terrible2 = pyglet.image.load('data/megademo_terrible_raiskale02.png')
        self.kuva_terrible2.anchor_x = self.kuva_terrible2.width // 2
        self.kuva_terrible2.anchor_y = self.kuva_terrible2.height // 2
        
        self.kuva_terrible3 = pyglet.image.load('data/megademo_terrible_raiskale03.png')
        self.kuva_terrible3.anchor_x = self.kuva_terrible3.width // 2
        self.kuva_terrible3.anchor_y = self.kuva_terrible3.height // 2
        
        self.kuva_terrible4 = pyglet.image.load('data/megademo_terrible_raiskale04.png')
        self.kuva_terrible4.anchor_x = self.kuva_terrible4.width // 2
        self.kuva_terrible4.anchor_y = self.kuva_terrible4.height // 2

             
        self.raiskale_sprite0 = pyglet.sprite.Sprite(self.kuva_terrible0)
        self.raiskale_sprite0._set_scale(0.50)
        self.raiskale_sprite0.set_position(self.winWidthHeight[0]/-16, self.winWidthHeight[1]/14)               
        
        self.raiskale_sprite1 = pyglet.sprite.Sprite(self.kuva_terrible1)
        self.raiskale_sprite1._set_scale(0.50)
        self.raiskale_sprite1.set_position(self.winWidthHeight[0]/-16, self.winWidthHeight[1]/14)
        
        self.raiskale_sprite2 = pyglet.sprite.Sprite(self.kuva_terrible2)
        self.raiskale_sprite2._set_scale(0.50)
        self.raiskale_sprite2.set_position(self.winWidthHeight[0]/16, self.winWidthHeight[1]/14)
        
        self.raiskale_sprite3 = pyglet.sprite.Sprite(self.kuva_terrible3)
        self.raiskale_sprite3._set_scale(0.50)
        self.raiskale_sprite3.set_position(self.winWidthHeight[0]/16, self.winWidthHeight[1]/-14)
        
        self.raiskale_sprite4 = pyglet.sprite.Sprite(self.kuva_terrible4)
        self.raiskale_sprite4._set_scale(0.50)
        self.raiskale_sprite4.set_position(0,0)
        
        
    def spawnGlitchCube(self):
        
        size = uniform(25.0, 25.0)
        x = uniform(-20.0, 20.0)
        y = uniform(-20.0, 20.0)
        rot = uniform(0.0, 360.0)
        ent = Cube(size, x, y, rot, self.winWidthHeight)

        return ent


    def draw(self):   
        
        self.background_red_input += 0.03
        self.background_green_input += 0.015
        self.background_blue_input += 0.02
        
        self.background_red = math.fabs(math.sin(self.background_red_input))
        self.background_green = math.fabs(math.sin(self.background_green_input))
        self.background_blue = math.fabs(math.sin(self.background_blue_input))
        
               
          
        glClear(GL_COLOR_BUFFER_BIT)
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glPushMatrix(); #to start the current object transformations
        
        # Background Color
        glClearColor(self.background_red, self.background_green, self.background_blue, 1)
        #glClearColor(0, 0, 0, 0)   # Black
        
        self.cube.draw()
        
        glPopMatrix(); # to end the current object transformations
        
        self.titleIndex += 0.01
        
        if ( self.titleIndex >= 0.0 ):
            self.activeTitle = self.raiskale_sprite0
        if ( self.titleIndex >= 0.9 ):
            self.activeTitle = self.raiskale_sprite0        
        if ( self.titleIndex >= 1.0 ):
            self.activeTitle = self.raiskale_sprite1
        if ( self.titleIndex >= 1.9 ):
            self.activeTitle = self.raiskale_sprite0 
        if ( self.titleIndex >= 2.0 ):
            self.activeTitle = self.raiskale_sprite2
        if ( self.titleIndex >= 2.9 ):
            self.activeTitle = self.raiskale_sprite0 
        if ( self.titleIndex >= 3.0 ):
            self.activeTitle = self.raiskale_sprite3
        if ( self.titleIndex >= 3.9 ):
            self.activeTitle = self.raiskale_sprite0 
        if ( self.titleIndex >= 4.0 ):
            self.activeTitle = self.raiskale_sprite4 
        if ( self.titleIndex >= 5.5 ):
            self.activeTitle = self.raiskale_sprite0 

        self.activeTitle.draw()


class Camera(object):

    def __init__(self, win, x=0.0, y=0.0, rot=0.0, zoom=1.0):
        self.win = win
        self.x = x
        self.y = y
        self.rot = rot
        self.zoom = zoom

    def worldProjection(self):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        widthRatio = self.win.width / self.win.height
        gluOrtho2D(
            -self.zoom * widthRatio,
            self.zoom * widthRatio,
            -self.zoom,
            self.zoom)

    def hudProjection(self):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluOrtho2D(0, self.win.width, 0, self.win.height)


class Hud(object):

    def __init__(self, win):
        
        self.win = win   #Contains reference to the window where all the text is to be printed    
        self.fps = clock.ClockDisplay() #Initialize fps counter
        
        
    def tick(self, win):
               
        self.text = font.Text(
            self.fontHelvetica,
            self.texts['hello'],
            x=self.win.width / 2,
            y=self.win.height / 2,
            halign=font.Text.CENTER,
            valign=font.Text.CENTER,
            color=(1, 1, 1, 0.7),
        )
                                     

    def draw(self):
        #self.tick(self.win)
        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();
        #self.text.draw()
        #self.fps.draw()  #Show FPS counter


class AudioPlayer(object):
    
    def __init__(self):
        #pyglet.options['audio'] = ('alsa', 'silent')
        self.player = pyglet.media.Player()
        
    def addItem(self, itemPath):
        addition = pyglet.media.load(itemPath, streaming=False)
        self.player.queue(addition)
        
    def play(self):
        self.player.play()
        
    def nextItem(self):
        self.player.next()


class StroboVilkutin:

    #addr = ("127.0.0.1", 9909)
    addr = ("192.168.1.40", 9909)
    UDPSock = socket(AF_INET,SOCK_DGRAM)
    
    
    

    i = 0
    r = 0
    g = 0
    b = 0
    
    a = 0



    def __init__(self):
        self.lightBlast = 0
            
    def update(self):
                
            if ( self.lightBlast == 0 ):
                            
                command_out_light0 = pack('>LLBBB',0,0,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light0, self.addr)
            
                command_out_light1 = pack('>LLBBB',0,1,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light1, self.addr)
            
                command_out_light2 = pack('>LLBBB',0,2,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light2, self.addr)
            
                command_out_light3 = pack('>LLBBB',0,3,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light3, self.addr)
            
                command_out_light4 = pack('>LLBBB',0,4,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light4, self.addr)
            
                command_out_light5 = pack('>LLBBB',0,5,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light5, self.addr)
            
                command_out_light6 = pack('>LLBBB',0,6,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light6, self.addr)
            
                command_out_light7 = pack('>LLBBB',0,7,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light7, self.addr)  
                
                self.lightBlast = 255            
                    
            
            if ( self.lightBlast == 255 ):
                            
                command_out_light0 = pack('>LLBBB',0,0,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light0, self.addr)
            
                command_out_light1 = pack('>LLBBB',0,1,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light1, self.addr)
            
                command_out_light2 = pack('>LLBBB',0,2,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light2, self.addr)
            
                command_out_light3 = pack('>LLBBB',0,3,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light3, self.addr)
            
                command_out_light4 = pack('>LLBBB',0,4,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light4, self.addr)
            
                command_out_light5 = pack('>LLBBB',0,5,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light5, self.addr)
            
                command_out_light6 = pack('>LLBBB',0,6,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light6, self.addr)
            
                command_out_light7 = pack('>LLBBB',0,7,self.lightBlast,self.lightBlast,self.lightBlast)
                self.UDPSock.sendto(command_out_light7, self.addr)  
                
                self.lightBlast = 0   
            
            
    def TurnLightsOff(self):                       
                                    
        command_out_end = pack('>LLBBB',0,0,0,0,0)
        self.UDPSock.sendto(command_out_end, self.addr)
            


class MuutaValot:

    #addr = ("127.0.0.1", 9909)
    addr = ("192.168.1.40", 9909)
    UDPSock = socket(AF_INET,SOCK_DGRAM)
    
    
    

    i = 0
    r = 0
    g = 0
    b = 0
    
    a = 0



    def __init__(self):
        self.r = 0
            
    def update(self):
                
            self.r = uniform(20,255)
            self.g = uniform(20,255)
            self.b = uniform(5,255)
            
                                        
            command_out_light0 = pack('>LLBBB',0,0,self.r,self.g,self.b)
            self.UDPSock.sendto(command_out_light0, self.addr)
            
            command_out_light1 = pack('>LLBBB',0,1,self.r,self.g,self.b)
            self.UDPSock.sendto(command_out_light1, self.addr)
            
            command_out_light2 = pack('>LLBBB',0,2,self.r,self.g,self.b)
            self.UDPSock.sendto(command_out_light2, self.addr)
            
            command_out_light3 = pack('>LLBBB',0,3,self.r,self.g,self.b)
            self.UDPSock.sendto(command_out_light3, self.addr)
            
            command_out_light4 = pack('>LLBBB',0,4,self.r,self.g,self.b)
            self.UDPSock.sendto(command_out_light4, self.addr)
            
            command_out_light5 = pack('>LLBBB',0,5,self.r,self.g,self.b)
            self.UDPSock.sendto(command_out_light5, self.addr)
            
            command_out_light6 = pack('>LLBBB',0,6,self.r,self.g,self.b)
            self.UDPSock.sendto(command_out_light6, self.addr)
            
            command_out_light7 = pack('>LLBBB',0,7,self.r,self.g,self.b)
            self.UDPSock.sendto(command_out_light7, self.addr)  
                       
                    
            
            
    def TurnLightsOff(self):                       
                                    
        command_out_end = pack('>LLBBB',0,0,0,0,0)
        self.UDPSock.sendto(command_out_end, self.addr)
            





class Mainloop(object):

    oneTimeSwitch = 0
    effectRunning = -7
    startingTime = time.time()
    timeCheck = time.time()
    

    def __init__(self):
        self.win = window.Window(fullscreen=True , vsync=True, resizable=True)
        #self.win.set_size(1024, 768)
        self.winWidthHeight = []
        self.winWidthHeight.append(self.win.width)
        self.winWidthHeight.append(self.win.height)
        self.world1 = EffectWorld1(self.winWidthHeight)
        self.world2 = EffectWorld2(self.winWidthHeight, 'data/helloworld.png')
        #self.world3 = EffectWorld3(self.winWidthHeight)
        self.world4 = EffectWorld4(self.winWidthHeight)
        self.world5 = EffectWorld5(self.winWidthHeight)
        self.world6 = EffectWorld6(self.winWidthHeight)
        self.world222 = EffectWorld2(self.winWidthHeight, 'data/creditz.png')
        self.loading = Loading(self.winWidthHeight)
        self.title = Title(self.winWidthHeight)
        self.beginning = Beginning(self.winWidthHeight)
        self.beginning2 = Beginning2(self.winWidthHeight)
        self.lighthouse = Lighthouse(self.winWidthHeight)
        print("width" + str(self.winWidthHeight[0]))
        print("height" + str(self.winWidthHeight[1]))
        
        self.strobo = StroboVilkutin()
        
        self.camera = Camera(self.win, zoom=100.0)
        self.hud = Hud(self.win)
        clock.set_fps_limit(60)       
        
        self.startSoundTrack()

        
    def startSoundTrack(self):
        
        self.soundtrackPlayer = AudioPlayer()
        self.soundtrackPlayer.addItem('data/ragemanifestopresents.wav')
        self.soundtrackPlayer.addItem('data/mogyloori.wav')
        self.soundtrackPlayer.addItem('data/uviiuu.wav')
        self.soundtrackPlayer.addItem('data/epicness.wav')
        self.soundtrackPlayer.addItem('data/dakkan_tsakkan.wav')
        self.soundtrackPlayer.addItem('data/atss_atss.wav')
        self.soundtrackPlayer.addItem('data/viulua.wav')
        self.soundtrackPlayer.addItem('data/encore.wav')
        
        


    def run(self):

        while not self.win.has_exit:
            self.win.dispatch_events()
            self.camera.worldProjection()         


            #Demosequence:
            #Beginning (RageManifesto)
            #Beginning2 (techniques)
            #World2 (helloworld)
            #World1 (triangles)
            #World5 (iris)
            #World4 (cube)
            #World6 (greets)
            #World6 (greets)
            ###################
            #World1 (triangles)
            #World4 (cube)
            #World5 (iris)
            #World7 (credits)
            #World8 (trollLighthouse)
            #World2 (helloworld)





            #Tears effect down
            if ( -7 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect1 stopped') 
                self.strobo.update()
                self.loading.draw()            
                if ( time.time() > self.timeCheck+5 ):
                    self.effectRunning = -6
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) 
                    #self.strobo.TurnLightsOff()



            #Launches effect
            if ( -6 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('beginning starting') #Console printing for debugging purposes
                    self.soundtrackPlayer.play() 
                    self.strobo.TurnLightsOff()
                self.beginning.draw() #Call for the draw routine for looping  #BEGINNING
                if ( time.time() > self.timeCheck+4 ): #When the time's up...
                    self.effectRunning = -5 #...set the main sequence switch to the next phase
              
              
            #Tears effect down
            if ( -5 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect1 stopped')  
                self.strobo.update()  
                self.loading.draw()                
                if ( time.time() > self.timeCheck+0.5 ):
                    self.effectRunning = -4   
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff()        
            
            #Launches effect
            if ( -4 == self.effectRunning ):
                if ( self.oneTimeSwitch == 0 ):                    
                    self.oneTimeSwitch = 1
                    print('effect2 starting')
                    self.strobo.TurnLightsOff()
                    self.soundtrackPlayer.nextItem()
                self.title.draw()
                if ( time.time() > self.timeCheck+10 ):
                    self.effectRunning = -3
              
              
            #Tears effect down
            if ( -3 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect1 stopped')    
                self.loading.draw()                
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = -2
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) 
                    self.strobo.TurnLightsOff()


            #Launches effect
            if ( -2 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('beginnig starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                    self.soundtrackPlayer.nextItem()
                self.beginning2.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+10 ): #When the time's up...
                    self.effectRunning = -1 #...set the main sequence switch to the next phase
              
            #Tears effect down
            if ( -1 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect1 stopped') 
                self.strobo.update()   
                self.loading.draw()                
                if ( time.time() > self.timeCheck+2 ):
                    self.effectRunning = 0  
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) 
                    self.strobo.TurnLightsOff()

          
            #Launches effect
            if ( 0 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect1 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                self.world1.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+14 ): #When the time's up...
                    self.effectRunning = 1 #...set the main sequence switch to the next phase
              
            #Tears effect down
            if ( 1 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect1 stopped')  
                self.strobo.update()  
                self.loading.draw()                
                if ( time.time() > self.timeCheck+2 ):
                    self.effectRunning = 2   
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff()        
            
            #Launches effect
            if ( 2 == self.effectRunning ):
                if ( self.oneTimeSwitch == 0 ):                    
                    self.oneTimeSwitch = 1
                    print('effect2 starting')
                    self.strobo.TurnLightsOff()
                self.world2.draw()
                if ( time.time() > self.timeCheck+15 ):
                    self.effectRunning = 3
                    
            #Tears effect down
            if ( 3 == self.effectRunning ):
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect 2 stopped')
                self.strobo.update()
                self.loading.draw()
                if ( time.time() > self.timeCheck+2 ):
                    self.effectRunning = 4 
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff()      
                    
                    
            #Launches effect
            if ( 4 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect4 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                    self.soundtrackPlayer.nextItem()
                self.world5.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+20 ): #When the time's up...
                    self.effectRunning = 5 #...set the main sequence switch to the next phase
              
            #Tears effect down
            if ( 5 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect4 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 6
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff()         
                    
            #Launches effect
            if ( 6 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect5 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                    self.soundtrackPlayer.nextItem()
                self.world4.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+25 ): #When the time's up...
                    self.effectRunning = 7 #...set the main sequence switch to the next phase
              
            #Tears effect down
            if ( 7 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect5 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 8
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff()       
                    
                    
            #Launches effect
            if ( 8 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect6 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                    self.soundtrackPlayer.nextItem()
                self.world6.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+30 ): #When the time's up...
                    self.effectRunning = 9 #...set the main sequence switch to the next phase
              
            #Tears effect down
            if ( 9 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect6 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 10
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) 
                    self.strobo.TurnLightsOff()


          
            #######REPETITION BEGINS##############           
                    
            #Launches effect
            if ( 10 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect6 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                    self.soundtrackPlayer.nextItem()
                self.world1.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+10 ): #When the time's up...
                    self.effectRunning = 11 #...set the main sequence switch to the next phase
              
              
            #Tears effect down
            if ( 11 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect6 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 12
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff()   
                    
                    
            #Launches effect
            if ( 12 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect6 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                self.world4.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+10 ): #When the time's up...
                    self.effectRunning = 13 #...set the main sequence switch to the next phase
              
              
            #Tears effect down
            if ( 13 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect6 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 14
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff()   
                    
                    
            #Launches effect
            if ( 14 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect6 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                    
                self.world6.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+10 ): #When the time's up...
                    self.effectRunning = 15 #...set the main sequence switch to the next phase
              
              
            #Tears effect down
            if ( 15 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect6 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 16
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff()  
                    
                    
                    
            #Launches effect
            if ( 16 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect6 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                self.world5.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+10 ): #When the time's up...
                    self.effectRunning = 17 #...set the main sequence switch to the next phase
              
              
            #Tears effect down
            if ( 17 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect6 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 18
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff() 
                    
            #Launches effect
            if ( 18 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect6 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                self.world222.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+16 ): #When the time's up...
                    self.effectRunning = 19 #...set the main sequence switch to the next phase
                    
                    
            #Tears effect down
            if ( 19 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect6 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 20
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff() 
                    
            #Launches effect
            if ( 20 == self.effectRunning ): #The main sequence switch check
                if ( self.oneTimeSwitch == 0 ): #Switch for phase initialization. For launching, is 0. For tearing down, 1.
                    self.oneTimeSwitch = 1 #When launching an effect, set to 1. When tearing down, set to 0.
                    self.timeCheck = time.time() #Save the starting time of this sequence phase
                    print('effect6 starting') #Console printing for debugging purposes
                    self.strobo.TurnLightsOff()
                self.lighthouse.draw() #Call for the draw routine for looping
                if ( time.time() > self.timeCheck+1000 ): #When the time's up...
                    self.effectRunning = 21 #...set the main sequence switch to the next phase
              
              
            #Tears effect down
            if ( 21 == self.effectRunning ):                
                if ( self.oneTimeSwitch == 1 ):
                    self.oneTimeSwitch = 0
                    self.win.clear()
                    self.win.dispatch_events()
                    self.timeCheck = time.time()
                    print('effect6 stopped')
                self.strobo.update() 
                self.loading.draw()                   
                if ( time.time() > self.timeCheck+1 ):
                    self.effectRunning = 0
                    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
                    self.strobo.TurnLightsOff() 
                    
                            
            
            self.camera.hudProjection()
            self.hud.draw()

            clock.tick()
            self.win.flip()                 

if __name__ == "__main__":
    megademo = Mainloop()
    megademo.run()
    