#version 120

uniform sampler2D tex0;
uniform vec2 size_r;
uniform vec4 color;

void main(){
    vec4 sample0 = vec4(color.xyz, texture2D(tex0, gl_TexCoord[0].xy).r * color.a);

    vec4 sample1 = vec4(0.0, 0.0, 0.0, (texture2D(tex0, gl_TexCoord[0].xy-size_r*vec2(1.1,1.1)).r
                                     + texture2D(tex0, gl_TexCoord[0].xy-size_r*vec2(1.1,-0.1)).r
                                     + texture2D(tex0, gl_TexCoord[0].xy-size_r*vec2(-0.1,1.1)).r
                                     + texture2D(tex0, gl_TexCoord[0].xy-size_r*vec2(-0.1,-0.1)).r) * color.a);

    gl_FragColor = mix(sample0, sample1, (1.0-sample0.a)*(1.0-sample0.a));
}
