#version 120

attribute vec4 tangent;
attribute vec3 bitangent;

varying vec4 pos;
varying vec3 lnor, ltan, ltan2;

uniform float time;

void main(){
    lnor = normalize(gl_NormalMatrix * gl_Normal);
    ltan = normalize(gl_NormalMatrix * tangent.xyz);
    ltan2 = normalize(gl_NormalMatrix * bitangent);

    pos = gl_ProjectionMatrix * gl_ModelViewMatrix
        * (gl_Vertex + vec4(sin(time), cos(time), 0.0, 0.0)
          * length(gl_Vertex) * 0.1);
    gl_Position = pos;
    gl_TexCoord[0] = gl_MultiTexCoord0;
}
