/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import java.util.Vector;
import vitamin.VTexture;
import vitamin.math.Vector4;
import vitamin.scenesimple.Material;

public class StandardMaterial
extends Material {
    public boolean _doubleSided;
    public float _opacity;
    public float _specularLevel;
    public float _glossiness;
    Vector4 _ambient;
    Vector4 _diffuse;
    Vector4 _specular;
    Vector4 _emissive;
    int _numOfTextures;
    Vector<String> _texNames;
    Vector<VTexture> _texList;

    public StandardMaterial() {
        this._name = "StandardMat_" + Math.random() * 1000.0;
        this._type = 0;
        this._emissive = new Vector4(0.0f, 0.0f, 0.0f, 1.0f);
        this._ambient = new Vector4(0.0f, 0.0f, 0.0f, 1.0f);
        this._diffuse = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
        this._specular = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
        this._doubleSided = false;
        this._opacity = 1.0f;
        this._specularLevel = 16.0f;
        this._glossiness = 1.0f;
        this._numOfTextures = 0;
        this._texNames = new Vector();
        this._texList = new Vector();
    }

    public StandardMaterial(String name) {
        this._name = name;
        this._type = 0;
        this._emissive = new Vector4(0.0f, 0.0f, 0.0f, 1.0f);
        this._ambient = new Vector4(0.0f, 0.0f, 0.0f, 1.0f);
        this._diffuse = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
        this._specular = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);
        this._doubleSided = false;
        this._opacity = 1.0f;
        this._specularLevel = 16.0f;
        this._glossiness = 1.0f;
        this._numOfTextures = 0;
        this._texNames = new Vector();
        this._texList = new Vector();
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setEmissive(float r, float g, float b, float a) {
        this._emissive.set(r, g, b, a);
    }

    public void setAmbient(float r, float g, float b, float a) {
        this._ambient.set(r, g, b, a);
    }

    public void setDiffuse(float r, float g, float b, float a) {
        this._diffuse.set(r, g, b, a);
    }

    public void setSpecular(float r, float g, float b, float a) {
        this._specular.set(r, g, b, a);
    }

    public void setShininess(float s) {
        this._specularLevel = s;
    }

    public void addTexture(String texName, VTexture tex) {
        this._texNames.add(texName);
        this._texList.add(tex);
        ++this._numOfTextures;
    }

    public VTexture getTexture(int idx) {
        if (this._texList == null) {
            return null;
        }
        if (idx < 0 || idx >= this._texList.size()) {
            return null;
        }
        return this._texList.get(idx);
    }

    public VTexture getTextureByName(String name) {
        if (this._texList == null) {
            return null;
        }
        for (VTexture t : this._texList) {
            if (!t._name.equals(name)) continue;
            return t;
        }
        return null;
    }
}

