/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import java.util.ArrayList;
import vitamin.math.Vector3;
import vitamin.scenesimple.Mesh;
import vitamin.scenesimple.Triangle;
import vitamin.scenesimple.Vertex;

public class MeshCylinder
extends Mesh {
    float _uMulti;
    float _vMulti;
    Vector3 _center;
    int _rings;
    int _segments;
    float _length;
    float _radius;

    public MeshCylinder(String name, Vector3 center, float r, float len, int detail) {
        this._name = name;
        this._vertexList = new ArrayList();
        this._triangleList = new ArrayList();
        this._vMulti = 1.0f;
        this._uMulti = 1.0f;
        this._hasTriStrip = false;
        this.setCenter(center);
        this.setRadius(r);
        this.setLength(len);
        this.setDetail(detail, detail);
    }

    public void setUVMultiplier(float um, float vm) {
        this._uMulti = um;
        this._vMulti = vm;
    }

    public void setRadius(float r) {
        this._radius = r;
    }

    public void setCenter(Vector3 center) {
        this._center = center;
    }

    public void setDetail(int rings, int segments) {
        this._rings = rings;
        this._segments = segments;
    }

    public void setLength(float len) {
        this._length = len;
    }

    public boolean generate() {
        if (this._triStripList != null) {
            return false;
        }
        this._triStripList = new int[this._rings * (this._segments + 1) * 2];
        float fDeltaSegAngle = (float)(Math.PI * 2 / (double)this._segments);
        int index = 0;
        int ring = 0;
        while (ring < this._rings) {
            float y0 = (float)(ring + 0) / (float)this._rings * this._length;
            float y1 = (float)(ring + 1) / (float)this._rings * this._length;
            float per0 = 1.0f;
            float per1 = 1.0f;
            int seg = 0;
            while (seg < this._segments + 1) {
                float x0 = (float)Math.sin((float)seg * fDeltaSegAngle) * per0;
                float z0 = (float)Math.cos((float)seg * fDeltaSegAngle) * per0;
                float x1 = (float)Math.sin((float)seg * fDeltaSegAngle) * per1;
                float z1 = (float)Math.cos((float)seg * fDeltaSegAngle) * per1;
                Vertex v1 = new Vertex();
                v1._position.set(x0 * this._radius, y0, z0 * this._radius);
                v1._position.add(this._center);
                v1._normal.set(x0, 0.0f, z0);
                v1._normal.normalize();
                v1._texCoord.x = (float)seg / (float)this._segments * this._uMulti;
                v1._texCoord.y = (float)ring / (float)this._rings * this._vMulti;
                this._vertexList.add(v1);
                this._triStripList[index] = index;
                ++index;
                Vertex v2 = new Vertex();
                v2._position.set(x1 * this._radius, y1, z1 * this._radius);
                v2._position.add(this._center);
                v2._normal.set(x1, 0.0f, z1);
                v2._normal.normalize();
                v2._texCoord.x = (float)seg / (float)this._segments * this._uMulti;
                v2._texCoord.y = (float)(ring + 1) / (float)this._rings * this._vMulti;
                this._vertexList.add(v2);
                this._triStripList[index] = index;
                ++index;
                ++seg;
            }
            ++ring;
        }
        int i = 2;
        while (i < this._triStripList.length) {
            Triangle tri = new Triangle();
            if (i % 2 == 0) {
                tri._a = this._triStripList[i - 2];
                tri._b = this._triStripList[i - 1];
                tri._c = this._triStripList[i - 0];
                this._triangleList.add(tri);
            } else {
                tri._a = this._triStripList[i - 0];
                tri._b = this._triStripList[i - 1];
                tri._c = this._triStripList[i - 2];
                this._triangleList.add(tri);
            }
            ++i;
        }
        return true;
    }
}

