/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import com.sun.opengl.util.BufferUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import vitamin.Shader;

public class ShaderGLSL
extends Shader {
    private int _glslProgram;
    private int _vertexShaderId;
    private int _fragmentShaderId;
    private int _geometryShaderId;
    private int _primitiveInputType;
    private int _primitiveOutputType;

    public ShaderGLSL(GL gl, String name) {
        this._gl = gl;
        this._type = 3;
        this._name = name;
    }

    public int getProgram() {
        return this._glslProgram;
    }

    public void load(String vfile, String ffile) {
        if (vfile != null) {
            this.loadVertexShader(vfile);
        }
        if (ffile != null) {
            this.loadFragmentShader(ffile);
        }
        this.compile();
    }

    public void load(String vfile, String ffile, String gfile, int inputType, int outputType) {
        if (vfile != null) {
            this.loadVertexShader(vfile);
        }
        if (gfile != null) {
            this.loadGeometryShader(gfile);
        }
        if (ffile != null) {
            this.loadFragmentShader(ffile);
        }
        this._primitiveInputType = inputType;
        this._primitiveOutputType = outputType;
        this.compile();
    }

    public void loadVertexShader(String filename) {
        this._vertexShaderId = this._gl.glCreateShader(35633);
        FileReader fr = null;
        try {
            fr = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            System.err.println("(ShaderGLSL)  Vertex: '" + filename + "' not found!" + e);
        }
        System.out.println("(ShaderGLSL)  Loading GLSL vertex shader: " + filename);
        BufferedReader brv = new BufferedReader(fr);
        String source = "";
        String line = null;
        try {
            line = brv.readLine();
        }
        catch (IOException e) {
            System.err.println("(ShaderGLSL)  Failed reading fragment shader source!" + e);
        }
        while (line != null) {
            source = String.valueOf(source) + line + "\n";
            try {
                line = brv.readLine();
            }
            catch (IOException e) {
                System.err.println("(ShaderGLSL)  Failed reading fragment shader source!" + e);
            }
        }
        this._gl.glShaderSource(this._vertexShaderId, 1, new String[]{source}, null, 0);
        this._vertexShaderEnabled = true;
    }

    public void loadFragmentShader(String filename) {
        this._fragmentShaderId = this._gl.glCreateShader(35632);
        FileReader fr = null;
        try {
            fr = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            System.err.println("(ShaderGLSL)  Fragment: '" + filename + "' not found!" + e);
        }
        System.out.println("(ShaderGLSL)  Loading GLSL fragment shader: " + filename);
        BufferedReader brv = new BufferedReader(fr);
        String source = "";
        String line = null;
        try {
            line = brv.readLine();
        }
        catch (IOException e) {
            System.err.println("(ShaderGLSL)  Failed reading fragment shader source!" + e);
        }
        while (line != null) {
            source = String.valueOf(source) + line + "\n";
            try {
                line = brv.readLine();
            }
            catch (IOException e) {
                System.err.println("(ShaderGLSL)  Failed reading fragment shader source!" + e);
            }
        }
        this._gl.glShaderSource(this._fragmentShaderId, 1, new String[]{source}, null, 0);
        this._fragmentShaderEnabled = true;
    }

    public void loadGeometryShader(String filename) {
        this._geometryShaderId = this._gl.glCreateShader(36313);
        FileReader fr = null;
        try {
            fr = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            System.err.println("(ShaderGLSL)  GeometryShader: '" + filename + "' not found!" + e);
        }
        System.out.println("(ShaderGLSL)  Loading GLSL geometry shader: " + filename);
        BufferedReader brv = new BufferedReader(fr);
        String source = "";
        String line = null;
        try {
            line = brv.readLine();
        }
        catch (IOException e) {
            System.err.println("(ShaderGLSL)  Failed reading geometry shader source!" + e);
        }
        while (line != null) {
            source = String.valueOf(source) + line + "\n";
            try {
                line = brv.readLine();
            }
            catch (IOException e) {
                System.err.println("(ShaderGLSL)  Failed reading geometry shader source!" + e);
            }
        }
        this._gl.glShaderSource(this._geometryShaderId, 1, new String[]{source}, null, 0);
        this._geometryShaderEnabled = true;
    }

    public void compile() {
        this._glslProgram = this._gl.glCreateProgramObjectARB();
        if (this._vertexShaderEnabled) {
            this._gl.glCompileShader(this._vertexShaderId);
            this.checkStatus("(VERTEX) CompileStatus:", 35713, this._vertexShaderId);
            this._gl.glAttachShader(this._glslProgram, this._vertexShaderId);
            this.checkStatus("(VERTEX) ObjectInfo:", 35716, this._vertexShaderId);
        }
        if (this._geometryShaderEnabled) {
            this._gl.glCompileShader(this._geometryShaderId);
            this.checkStatus("(GEOMETRY) CompileStatus:", 35713, this._geometryShaderId);
            this._gl.glProgramParameteriEXT(this._glslProgram, 36315, this._primitiveInputType);
            this._gl.glProgramParameteriEXT(this._glslProgram, 36316, this._primitiveOutputType);
            int[] n = new int[1];
            this._gl.glGetIntegerv(36320, n, 0);
            this._gl.glProgramParameteriEXT(this._glslProgram, 36314, n[0]);
            this._gl.glAttachShader(this._glslProgram, this._geometryShaderId);
            this.checkStatus("(GEOMETRY) ObjectInfo:", 35716, this._geometryShaderId);
        }
        if (this._fragmentShaderEnabled) {
            this._gl.glCompileShader(this._fragmentShaderId);
            this.checkStatus("(FRAGMENT) CompileStatus:", 35713, this._fragmentShaderId);
            this._gl.glAttachShader(this._glslProgram, this._fragmentShaderId);
            this.checkStatus("(FRAGMENT) ObjectInfo:", 35716, this._fragmentShaderId);
        }
        this._gl.glLinkProgram(this._glslProgram);
        this._gl.glValidateProgram(this._glslProgram);
        this.checkStatus("(GLSL PROGRAM)  ValidationStatus: ", 35715, this._glslProgram);
    }

    public void enable() {
        this._gl.glUseProgram(this._glslProgram);
    }

    public void disable() {
        this._gl.glUseProgram(0);
    }

    public void setTextureParameter(String param, int texUnit) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1i(location, texUnit);
    }

    public void setParameter1d(String param, double x) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1f(location, (float)x);
    }

    public void setParameter1f(String param, float x) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1f(location, x);
    }

    public void setParameter1i(String param, int x) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1i(location, x);
    }

    public void setParameter1fv(String param, float[] v) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1fv(location, 3, v, 0);
    }

    public void setParameter2f(String param, float x, float y) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform2f(location, x, y);
    }

    public void setParameter2i(String param, int x, int y) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform2i(location, x, y);
    }

    public void setParameter3f(String param, float x, float y, float z) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform3f(location, x, y, z);
    }

    public void setParameter3fv(String param, float[] v) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform3fv(location, 3, v, 0);
    }

    public void setParameter4f(String param, float x, float y, float z, float w) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform4f(location, x, y, z, w);
    }

    public void setParameter4fv(String param, float[] v) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform4fvARB(location, 4, v, 0);
    }

    public void setMatrixParameterSemantic(String param, int matrix, int matrixType) {
    }

    public void setMatrixParameterSemantic(String param, float[] v) {
    }

    public void setParameterSemantic(String param, float x) {
    }

    public void setParameterSemantic(String param, float x, float y) {
    }

    public void setParameterSemantic(String param, float x, float y, float z) {
    }

    public void setParameterSemantic(String param, float x, float y, float z, float w) {
    }

    public void setParameter4x4d(String param, double[] v) {
        System.err.println("(ShaderGLSL)  setParameter4x4d: function not implemented");
    }

    public void setParameter4x4f(String param, float[] v) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniformMatrix4fv(location, 16, false, v, 0);
    }

    public void setParameter4x4f(String semanticName, int matrix, int matrixType) {
        System.err.println("(ShaderGLSL)  This function isn't supported for GLSL shaders.");
    }

    public void setParameter4x4fBySemantic(String semanticName, int matrix, int matrixType) {
        System.err.println("(ShaderGLSL)  This function isn't supported for GLSL shaders.");
    }

    protected void checkStatus(String title, int status, int obj) {
        IntBuffer iVal = BufferUtil.newIntBuffer((int)1);
        this._gl.glGetObjectParameterivARB(obj, status, iVal);
        int length = iVal.get();
        if (length < 1) {
            System.err.println("(ShaderGLSL)  Error occured with object parameter.");
            return;
        }
        ByteBuffer infoLog = BufferUtil.newByteBuffer((int)length);
        iVal.flip();
        this._gl.glGetInfoLogARB(obj, length, iVal, infoLog);
        byte[] infoBytes = new byte[length];
        infoLog.get(infoBytes);
        String msg = new String(infoBytes);
        if (msg.length() > 1) {
            System.err.println("(ShaderGLSL)  " + title + " : " + msg);
            return;
        }
        try {
            int err = this._gl.glGetError();
            if (err != 0) {
                System.err.println("(ShaderGLSL) OpenGL Error ID: " + err);
            }
        }
        catch (GLException e) {
            System.err.println("(ShaderGLSL) GLException: " + (Object)((Object)e));
        }
        if (status == 35713) {
            if (length == 0) {
                System.err.println("(ShaderGLSL)  There was a problem compiling the shader: " + obj);
                return;
            }
            System.out.println("(ShaderGLSL)  [" + title + "] Shader was compiled sucessfully! " + obj);
            return;
        }
    }
}

