/*
 * Decompiled with CFR 0.152.
 */
package crayolon.portamod;

import crayolon.portamod.CellContent;
import crayolon.portamod.Channel;
import crayolon.portamod.CurrentPattern;
import crayolon.portamod.DataCell;
import crayolon.portamod.FastTracker2;
import crayolon.portamod.IBXM;
import crayolon.portamod.Instrument;
import crayolon.portamod.NoteData;
import crayolon.portamod.Player;
import crayolon.portamod.ProTracker;
import crayolon.portamod.Sample;
import crayolon.portamod.ScreamTracker3;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.FloatControl;
import processing.core.PApplet;

public class PortaMod {
    PApplet p;
    Method noteArrived;
    String modpath = "";
    boolean keydown = false;
    boolean overridetempo = false;
    public String filepath;
    public int sequencecounter = 0;
    public int interpolation = 0;
    int[][][] current_row_notes;
    int currentrowcount;
    CurrentPattern temppattern;
    int pausedseq;
    int pausedrow;
    int specheight;
    int tempovalue;
    int seconds;
    int buffersize;
    int pausedpos = 0;
    int playpos = 0;
    int volvalue = 127;
    public boolean paused = false;
    int posvalue = 0;
    public int loadSuccess = 0;
    int modseparation;
    int s3mpanning;
    public byte[] mod_header;
    public byte[] localmod_header;
    boolean fastforwardrow = false;
    boolean rewindrow = false;
    public boolean looping = false;
    public int transpose = 0;
    float volumelocal = 0.0f;
    int channels = 0;
    int currentsong = 0;
    int totalrows;
    int endcount = 0;
    float spectrumBars = 32.0f;
    float loopcount;
    float minVol = -40.0f;
    float maxVol = 6.02f;
    public boolean playing = false;
    public boolean muted = false;
    public long songStart;
    public long songLength;
    public long songPosition;
    String tunepath;
    String title;
    public int numchannels = 0;
    public int numinstruments = 0;
    public int bpmvalue = 0;
    float panning = 0.0f;
    int initialtempo;
    public int numpatterns = 0;
    String[] infotext;
    FileInputStream file_input_stream;
    public FloatControl volCtrl;
    public Player player;
    InputStream mymod;
    DataCell[] cells;
    BooleanControl muteCtrl;
    public NoteData localnotes;
    public NoteData thisrow;
    ArrayList<CurrentPattern> positions = new ArrayList();
    public ArrayList<CurrentPattern>[] currentpatternrows;
    public ArrayList<Instrument> oldsamples = new ArrayList();
    public CellContent[] cellcontent;
    public CellContent[] content;
    public String modtype;
    public final String VERSION = "0.1.0";

    public PortaMod(PApplet p) {
        this.p = p;
        IBXM.SetMC(this);
        try {
            this.noteArrived = p.getClass().getMethod("grabNewdata", PortaMod.class);
        }
        catch (Exception e) {
            PApplet.println((String)e.getMessage());
        }
    }

    private void makeEvent() {
        if (this.noteArrived != null) {
            try {
                this.noteArrived.invoke((Object)this.p, this);
            }
            catch (Exception e) {
                System.err.println("Disabling fancyEvent() for  because of an error.");
                e.printStackTrace();
                this.noteArrived = null;
            }
        }
    }

    public String version() {
        return "0.1.0";
    }

    public void play() {
        if (this.paused) {
            this.player.play();
            this.paused = false;
        } else {
            this.player.play();
            this.songStart = this.p.millis();
        }
    }

    public void pause() {
        if (!this.paused) {
            this.player.stop();
            this.paused = true;
        }
    }

    public void vol(float newvol) {
        if (newvol > -40.0f && newvol < 6.02f) {
            try {
                this.volCtrl.setValue(newvol);
            }
            catch (Exception e) {
                PApplet.println((String)e.getMessage());
            }
        } else {
            PApplet.println((String)"Error - volume out of range. Must be between -40.0f and 6.020f!");
        }
    }

    public void mute() {
        if (!this.muted) {
            try {
                this.muteCtrl.setValue(true);
                this.muted = true;
            }
            catch (Exception e) {
                PApplet.println((String)e.getMessage());
            }
        } else {
            try {
                this.muteCtrl.setValue(false);
                this.muted = false;
            }
            catch (Exception e) {
                PApplet.println((String)e.getMessage());
            }
        }
    }

    public void transpose(int trans) {
        if (trans > -12 && trans < 12) {
            Channel.transposer = this.transpose = trans;
        }
    }

    public void bpm(int tempo) {
        if (tempo > 32 && tempo < 255) {
            this.player.set_tempo(tempo);
            this.bpmvalue = tempo;
        }
    }

    public void pan(float panval) {
        if (panval > -1.0f && panval < 1.0f) {
            try {
                FloatControl panctrl = (FloatControl)this.player.output_line.getControl(FloatControl.Type.BALANCE);
                panctrl.setValue(panval);
                this.panning = panval;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void chanMute(int chan) {
        if (chan < this.player.get_num_channels()) {
            this.player.ibxm.chanmute[chan] = !this.player.ibxm.chanmute[chan];
        }
    }

    public void next(int behaviour) {
        if (behaviour == 0) {
            this.player.ibxm.next_sequence_index = this.player.ibxm.current_sequence_index + 1;
        }
        if (behaviour == 1) {
            this.player.ibxm.next_sequence_index = this.player.ibxm.current_sequence_index + 1;
            this.player.ibxm.next_row = 0;
        }
    }

    public void prev(int behaviour) {
        if (behaviour == 0) {
            this.player.ibxm.next_sequence_index = this.player.ibxm.current_sequence_index - 1;
        }
        if (behaviour == 1) {
            this.player.ibxm.next_sequence_index = this.player.ibxm.current_sequence_index - 1;
            this.player.ibxm.next_row = 0;
        }
    }

    public void loopSong() {
        if (!this.looping) {
            this.looping = true;
            this.player.loop = true;
        } else {
            this.looping = false;
            this.player.loop = false;
        }
    }

    public void setPosition(int newpatt) {
        if (newpatt < this.player.get_sequence_length()) {
            this.player.ibxm.next_sequence_index = newpatt;
        }
    }

    public int getPosition() {
        return this.player.ibxm.current_sequence_index;
    }

    public void jump(int newpatt, int newrow) {
        if (newpatt < this.player.get_sequence_length() && newrow < this.player.ibxm.total_rows) {
            this.player.ibxm.next_sequence_index = newpatt;
            this.player.ibxm.next_row = newrow;
        }
    }

    public void chanVol(int chan, int vol) {
        this.player.ibxm.channels[chan].chanvol_override = vol;
    }

    public void stereoSeparation(int percentage) {
        int spread = (int)PApplet.map((float)percentage, (float)0.0f, (float)100.0f, (float)0.0f, (float)128.0f);
        if (this.modtype == "MOD") {
            this.player.ibxm.channels[0].set_panning(128 - spread);
            this.player.ibxm.channels[1].set_panning(128 + spread);
            this.player.ibxm.channels[2].set_panning(128 + spread);
            this.player.ibxm.channels[3].set_panning(128 - spread);
            if (this.player.get_num_channels() > 4) {
                this.player.ibxm.channels[4].set_panning(128 - spread);
                this.player.ibxm.channels[5].set_panning(128 + spread);
                this.player.ibxm.channels[6].set_panning(128 + spread);
                this.player.ibxm.channels[7].set_panning(128 - spread);
            }
        }
    }

    public int getChanvol(int chan) {
        int chanvol = this.player.ibxm.channels[chan].chanvolfinal;
        return chanvol;
    }

    public void interpolation(int interp) {
        this.interpolation = interp;
    }

    public int getSeek() {
        this.songPosition = this.player.play_position / 48;
        return (int)this.songPosition;
    }

    public void setSeek(int newpos) {
        this.player.seek(newpos * 48);
    }

    public void overrideTempo() {
        if (!this.overridetempo) {
            this.overridetempo = true;
            this.player.ibxm.overridetempo = true;
        } else {
            this.overridetempo = false;
            this.player.ibxm.overridetempo = false;
        }
    }

    public void changeSample(int idx, String inputpath, int offset) {
        byte[] sampbytes = this.p.loadBytes(inputpath);
        try {
            Instrument tempinst = this.replace_instrument(sampbytes, idx, sampbytes, offset);
            this.set_instrument(idx, tempinst);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void restoreSample(int idx) {
        try {
            if (this.oldsamples.get(idx - 1) != null) {
                Instrument tempinst_old = this.oldsamples.get(idx - 1);
                this.set_instrument(idx, tempinst_old);
            } else {
                System.out.println("Sample hasn't been replaced, so can't be restored!");
            }
        }
        catch (Exception e) {
            System.out.println("Sample hasn't been replaced, so can't be restored!");
        }
    }

    public int doModLoad(String tune, boolean autostart, float startVol) {
        this.filepath = tune;
        this.headerCheck(tune);
        PApplet.println((String)("Header checked: " + this.modtype));
        if (this.loadSuccess > 0) {
            this.loadSuccess = 0;
        }
        InputStream file_input_stream = this.p.createInput(tune);
        try {
            if (this.playing) {
                this.player.stop();
                PApplet.println((String)"stopped");
            }
            this.player = new Player(this.interpolation);
            this.player.set_module(Player.load_module(file_input_stream));
            file_input_stream.close();
            this.player.set_loop(true);
            this.player.receivebuffer(this.buffersize);
            if (autostart) {
                this.player.play();
                this.songStart = this.p.millis();
            }
            PApplet.println((String)this.player.get_title());
            PApplet.println((int)this.player.song_duration);
            this.songLength = this.player.song_duration / 48000;
            String[] infotext = new String[this.player.get_num_instruments() - 1];
            int i = 0;
            while (i < this.player.get_num_instruments() - 1) {
                Instrument tempinst_old = this.player.module.instruments[i];
                this.oldsamples.add(i, tempinst_old);
                if (this.player.ins_name(i) != null) {
                    PApplet.println((String)this.player.ins_name(i));
                    infotext[i] = this.player.ins_name(i);
                }
                ++i;
            }
            PApplet.println((String)("Channels:" + this.player.get_num_channels()));
            PApplet.println((Object)this.player.output_line.getControls());
            try {
                this.volCtrl = (FloatControl)this.player.output_line.getControl(FloatControl.Type.MASTER_GAIN);
                this.volCtrl.setValue(startVol);
            }
            catch (Exception e) {
                PApplet.println((String)("Volume ARGH!" + e.getMessage()));
            }
            try {
                this.muteCtrl = (BooleanControl)this.player.output_line.getControl(BooleanControl.Type.MUTE);
            }
            catch (Exception e) {
                PApplet.println((String)e.getMessage());
            }
        }
        catch (Exception e) {
            PApplet.println((String)e.getMessage());
            PApplet.println((String)"Printing stack trace... ");
            e.printStackTrace();
        }
        this.title = this.player.get_title();
        this.numchannels = this.player.get_num_channels();
        this.numinstruments = this.player.get_num_instruments();
        this.numpatterns = this.player.ibxm.module.get_sequence_length();
        this.playing = true;
        this.loadSuccess = 1;
        this.initialtempo = this.player.get_bpm();
        this.bpmvalue = this.player.get_bpm();
        this.currentrowcount = this.player.ibxm.total_rows;
        this.endcount = 0;
        return this.loadSuccess;
    }

    public void doIt(IBXM instance, NoteData notedata) {
        this.localnotes = notedata;
        try {
            this.makeEvent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sequencecounter = this.localnotes.currentseq;
        if (this.localnotes.channel == this.player.get_num_channels() - 1 && this.localnotes.currentseq == this.player.get_sequence_length() - 1 && this.localnotes.currentrow / this.player.get_num_channels() == this.localnotes.seqlength - 1) {
            ++this.endcount;
            this.songStart = this.p.millis();
        }
    }

    public String noteConvert(int noteval) {
        String note = "";
        switch (noteval) {
            case 0: {
                note = "- -";
                break;
            }
            case 1: {
                note = "C-0";
                break;
            }
            case 2: {
                note = "C#0";
                break;
            }
            case 3: {
                note = "D-0";
                break;
            }
            case 4: {
                note = "D#0";
                break;
            }
            case 5: {
                note = "E-0";
                break;
            }
            case 6: {
                note = "F-0";
                break;
            }
            case 7: {
                note = "F#0";
                break;
            }
            case 8: {
                note = "G-0";
                break;
            }
            case 9: {
                note = "G#0";
                break;
            }
            case 10: {
                note = "A-0";
                break;
            }
            case 11: {
                note = "A#0";
                break;
            }
            case 12: {
                note = "B-0";
                break;
            }
            case 13: {
                note = "C-1";
                break;
            }
            case 14: {
                note = "C#1";
                break;
            }
            case 15: {
                note = "D-1";
                break;
            }
            case 16: {
                note = "D#1";
                break;
            }
            case 17: {
                note = "E-1";
                break;
            }
            case 18: {
                note = "F-1";
                break;
            }
            case 19: {
                note = "F#1";
                break;
            }
            case 20: {
                note = "G-1";
                break;
            }
            case 21: {
                note = "G#1";
                break;
            }
            case 22: {
                note = "A-1";
                break;
            }
            case 23: {
                note = "A#1";
                break;
            }
            case 24: {
                note = "B-1";
                break;
            }
            case 25: {
                note = "C-2";
                break;
            }
            case 26: {
                note = "C#2";
                break;
            }
            case 27: {
                note = "D-2";
                break;
            }
            case 28: {
                note = "D#2";
                break;
            }
            case 29: {
                note = "E-2";
                break;
            }
            case 30: {
                note = "F-2";
                break;
            }
            case 31: {
                note = "F#2";
                break;
            }
            case 32: {
                note = "G-2";
                break;
            }
            case 33: {
                note = "G#2";
                break;
            }
            case 34: {
                note = "A-2";
                break;
            }
            case 35: {
                note = "A#2";
                break;
            }
            case 36: {
                note = "B-2";
                break;
            }
            case 37: {
                note = "C-3";
                break;
            }
            case 38: {
                note = "C#3";
                break;
            }
            case 39: {
                note = "D-3";
                break;
            }
            case 40: {
                note = "D#3";
                break;
            }
            case 41: {
                note = "E-3";
                break;
            }
            case 42: {
                note = "E#3";
                break;
            }
            case 43: {
                note = "F-3";
                break;
            }
            case 44: {
                note = "G-3";
                break;
            }
            case 45: {
                note = "G#3";
                break;
            }
            case 46: {
                note = "A-3";
                break;
            }
            case 47: {
                note = "A#3";
                break;
            }
            case 48: {
                note = "B-3";
                break;
            }
            case 49: {
                note = "C-4";
                break;
            }
            case 50: {
                note = "C#4";
                break;
            }
            case 51: {
                note = "D-4";
                break;
            }
            case 52: {
                note = "D#4";
                break;
            }
            case 53: {
                note = "E-4";
                break;
            }
            case 54: {
                note = "F-4";
                break;
            }
            case 55: {
                note = "F#4";
                break;
            }
            case 56: {
                note = "G-4";
                break;
            }
            case 57: {
                note = "G#4";
                break;
            }
            case 58: {
                note = "A-4";
                break;
            }
            case 59: {
                note = "A#4";
                break;
            }
            case 60: {
                note = "B-4";
                break;
            }
            case 61: {
                note = "C-5";
                break;
            }
            case 62: {
                note = "C#5";
                break;
            }
            case 63: {
                note = "D-5";
                break;
            }
            case 64: {
                note = "D#5";
                break;
            }
            case 65: {
                note = "E-5";
                break;
            }
            case 66: {
                note = "F-5";
                break;
            }
            case 67: {
                note = "F#5";
                break;
            }
            case 68: {
                note = "G-5";
                break;
            }
            case 69: {
                note = "G#5";
                break;
            }
            case 70: {
                note = "A-5";
                break;
            }
            case 71: {
                note = "A#5";
                break;
            }
            case 72: {
                note = "B-5";
                break;
            }
            case 73: {
                note = "C-6";
                break;
            }
            case 74: {
                note = "C#6";
                break;
            }
            case 75: {
                note = "D-6";
                break;
            }
            case 76: {
                note = "D#6";
                break;
            }
            case 77: {
                note = "E-6";
                break;
            }
            case 78: {
                note = "F-6";
                break;
            }
            case 79: {
                note = "F#6";
                break;
            }
            case 80: {
                note = "G-6";
                break;
            }
            case 81: {
                note = "G#6";
                break;
            }
            case 82: {
                note = "A-6";
                break;
            }
            case 83: {
                note = "A#6";
                break;
            }
            case 84: {
                note = "B-6";
                break;
            }
            case 85: {
                note = "C-7";
                break;
            }
            case 86: {
                note = "C#7";
                break;
            }
            case 87: {
                note = "D-7";
                break;
            }
            case 88: {
                note = "D#7";
                break;
            }
            case 89: {
                note = "E-7";
                break;
            }
            case 90: {
                note = "F-7";
                break;
            }
            case 91: {
                note = "F#7";
                break;
            }
            case 92: {
                note = "G-7";
                break;
            }
            case 93: {
                note = "G#7";
                break;
            }
            case 94: {
                note = "A-7";
                break;
            }
            case 95: {
                note = "A#7";
                break;
            }
            case 96: {
                note = "B-7";
                break;
            }
            case 97: {
                note = "=";
            }
        }
        return note;
    }

    boolean headerCheck(String tune) {
        InputStream file_input_stream = this.p.createInput(tune);
        String headercheck = "unknown";
        boolean valid = false;
        DataInputStream data_input_stream = new DataInputStream(file_input_stream);
        byte[] xm_header = new byte[60];
        try {
            data_input_stream.readFully(xm_header);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String xm_identifier = FastTracker2.ascii_text(xm_header, 0, 17);
        if (xm_identifier.equals("Extended Module: ")) {
            headercheck = "xm";
            this.modtype = "XM";
        }
        byte[] s3m_header = new byte[96];
        System.arraycopy(xm_header, 0, s3m_header, 0, 60);
        try {
            data_input_stream.readFully(s3m_header, 60, 36);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ScreamTracker3.is_s3m(s3m_header)) {
            headercheck = "s3m";
            this.modtype = "S3M";
        }
        this.mod_header = new byte[1084];
        System.arraycopy(s3m_header, 0, this.mod_header, 0, 96);
        try {
            data_input_stream.readFully(this.mod_header, 96, 988);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.localmod_header = this.mod_header;
        if (ProTracker.is_mod(this.mod_header)) {
            headercheck = "mod";
            this.modtype = "MOD";
        }
        valid = headercheck == "xm" || headercheck == "s3m" || headercheck == "mod";
        return valid;
    }

    Instrument replace_instrument(byte[] mod_header, int idx, byte[] data_input, int replacetranspose) throws IOException {
        int header_offset = (idx - 1) * 30 + 20;
        Instrument instrument = new Instrument();
        Sample sample = new Sample();
        int sample_data_length = data_input.length;
        System.out.println("Sampledata bytes: " + sample_data_length);
        int fine_tune = mod_header[header_offset + 24] & 0xF;
        if (fine_tune > 7) {
            fine_tune -= 16;
        }
        sample.transpose = (fine_tune + replacetranspose * 10 << 15) / 96;
        sample.volume = mod_header[header_offset + 25] & 0x7F;
        int loop_start = PortaMod.unsigned_short_be(mod_header, header_offset + 26) << 1;
        int loop_length = PortaMod.unsigned_short_be(mod_header, header_offset + 28) << 1;
        if (loop_length < 4) {
            loop_length = 0;
        }
        short[] sample_data = new short[sample_data_length];
        int sample_idx = 0;
        while (sample_idx < data_input.length) {
            sample_data[sample_idx] = (short)(data_input[sample_idx] << 8);
            ++sample_idx;
        }
        sample.set_sample_data(sample_data, loop_start, loop_length, false);
        instrument.set_num_samples(1);
        instrument.set_sample(0, sample);
        return instrument;
    }

    void set_instrument(int instrument_index, Instrument instrument) {
        if (instrument_index > 0 && instrument_index <= this.player.module.instruments.length) {
            this.player.module.instruments[instrument_index - 1] = instrument;
        }
    }

    private static int unsigned_short_be(byte[] buf, int offset) {
        int value = (buf[offset] & 0xFF) << 8;
        return value |= buf[offset + 1] & 0xFF;
    }
}

