/*
 * Decompiled with CFR 0.152.
 */
import com.sun.opengl.util.FPSAnimator;
import crayolon.portamod.PortaMod;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import processing.core.PApplet;
import processing.core.PImage;
import vitamin.VCamera;
import vitamin.VGL;
import vitamin.VTextRenderer;
import vitamin.VTexture2D;
import vitamin.VTimer;
import vitamin.fx.Effect;
import vitamin.fx.EffectManager;
import vitamin.interpolation.Elastic;
import vitamin.math.Color4;
import vitamin.math.MathUtils;
import vitamin.math.Vector3;
import vitamin.utils.BufferUtils;

public class SunflowerSeeds2
extends PApplet {
    boolean USE_PROCESSING = false;
    boolean isFullScreen = true;
    int NUM_SAMPLES = 8;
    int WIDTH = 800;
    int HEIGHT = 450;
    float aspectRatio = (float)this.WIDTH / (float)this.HEIGHT;
    Frame deepFrame;
    GLCapabilities deepCaps;
    GLCanvas deepCanvas;
    GLRenderer deepListener;
    FPSAnimator __animator;
    boolean renderToVideo = false;
    int frameCounter = 0;
    PortaMod mymod;
    PImage p;
    PImage pflip;
    VTimer timer;
    VGL vgl;
    EffectManager fxMan;
    CustomScene scene;
    VCamera cam;
    VTextRenderer textRender;
    String[] textStrings;
    ArrayList _colors;
    Color4 currActiveColor;

    public void setup() {
        if (this.USE_PROCESSING) {
            this.size(this.WIDTH, this.HEIGHT, "processing.opengl.PGraphicsOpenGL");
            this.hint(2);
        }
        this.frameRate(1000.0f);
        this.randomSeed(this.millis());
        if (!this.USE_PROCESSING) {
            this.noLoop();
        }
        if (!this.USE_PROCESSING) {
            SunflowerSeeds2.println((String)"Init window (demo)");
            this.initDemo();
        } else {
            this.initApp();
        }
    }

    public void initApp() {
        this.aspectRatio = (float)this.WIDTH / (float)this.HEIGHT;
        if (this.USE_PROCESSING) {
            this.vgl = new VGL((PApplet)this);
            this.vgl.setVSync(true);
        }
        this.mymod = new PortaMod((PApplet)this);
        this.mymod.doModLoad("ne7-yes_mama.xm", false, 6.02f);
        SunflowerSeeds2.println((String)("looping: " + this.mymod.looping));
        this.cam = new VCamera((PApplet)this, 0.0f, 100.0f, 200.0f, 0.0f, 100.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.textRender = new VTextRenderer(this.WIDTH, this.HEIGHT, "Arial Bold", 32, true, true);
        this.textRender.setColor(1.0f, 1.0f, 1.0f, 0.75f);
        this.textStrings = this.loadStrings("text.txt");
        this.textStrings[0] = " ";
        this.scene = new CustomScene();
        this.scene.Init(this.vgl.gl());
        float f = 0.003921569f;
        this._colors = new ArrayList();
        this._colors.add(new Color4(1.0f, 1.0f, 1.0f, 1.0f));
        this._colors.add(new Color4(226.0f * f, 223.0f * f, 154.0f * f, 1.0f));
        this._colors.add(new Color4(235.0f * f, 229.0f * f, 77.0f * f, 1.0f));
        this._colors.add(new Color4(117.0f * f, 116.0f * f, 73.0f * f, 1.0f));
        this._colors.add(new Color4(255.0f * f, 0.0f * f, 81.0f * f, 1.0f));
        this.currActiveColor = (Color4)this._colors.get(0);
        if (!this.renderToVideo) {
            this.mymod.play();
        }
        if (this.renderToVideo) {
            this.p = new PImage();
            this.p = this.createImage(this.WIDTH, this.HEIGHT, 1);
            this.pflip = new PImage();
            this.pflip = this.createImage(this.WIDTH, this.HEIGHT, 1);
        }
        this.timer = this.renderToVideo ? new VTimer(VTimer.OFFLINE) : new VTimer();
        this.timer.start();
    }

    public void draw() {
        if (this.USE_PROCESSING) {
            this.drawP5();
        }
    }

    public void drawP5() {
        float f = this.timer.getCurrTime();
        this.timer.update();
        this.vgl.begin();
        this.vgl.background(0.85f);
        this.scene.Render(f);
        this.scene.Update(f);
        this.vgl.ortho((float)this.WIDTH, (float)this.HEIGHT);
        this.vgl.enableTexture(false);
        float f2 = 85.0f;
        if (f < f2) {
            this.vgl.fill(0.0f, 1.0f - MathUtils.clamp((float)(f * 0.2f), (float)0.0f, (float)1.0f));
        } else {
            this.vgl.fill(0.0f, MathUtils.clamp((float)(f - f2), (float)0.0f, (float)1.0f));
        }
        this.vgl.rectTopLeft((float)this.WIDTH, (float)this.HEIGHT);
        this.vgl.end();
        if (this.renderToVideo) {
            this.p.pixels = this.vgl.readPixels(0, 0, this.WIDTH, this.HEIGHT, 5);
            this.p = this.flipImageVertical(this.p);
            this.p.save(this.sketchPath("SEQ/frame" + SunflowerSeeds2.nf((int)this.frameCounter, (int)7) + ".png"));
            ++this.frameCounter;
            if (this.frameCounter % 30 == 0) {
                SunflowerSeeds2.println((String)("count: " + this.frameCounter));
            }
            if (f > 92.0f) {
                System.exit(0);
            }
        }
        if (!this.renderToVideo && !this.mymod.playing) {
            System.exit(0);
        }
    }

    public PImage flipImageVertical(PImage pImage) {
        int n = pImage.width;
        int n2 = pImage.height;
        PImage pImage2 = new PImage();
        pImage2 = this.createImage(n, n2, 1);
        int[] nArray = new int[n * n2];
        System.arraycopy(pImage.pixels, 0, nArray, 0, n * n2);
        pImage2.loadPixels();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                pImage2.pixels[n4 + n3 * n] = nArray[n4 + (n2 - 1 - n3) * n];
                ++n4;
            }
            ++n3;
        }
        pImage2.updatePixels();
        return pImage2;
    }

    public void stop() {
        super.stop();
    }

    public void initDemo() {
        Cloneable cloneable;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (this.isFullScreen) {
            cloneable = Toolkit.getDefaultToolkit().getScreenSize();
            this.WIDTH = cloneable.width;
            this.HEIGHT = cloneable.height;
            this.aspectRatio = (float)this.WIDTH / (float)this.HEIGHT;
        }
        this.deepListener = new GLRenderer();
        this.deepFrame = new Frame("GilVicente");
        this.deepCaps = new GLCapabilities();
        this.deepCaps.setHardwareAccelerated(true);
        this.deepCaps.setDoubleBuffered(true);
        if (this.NUM_SAMPLES > 0) {
            this.deepCaps.setSampleBuffers(true);
            this.deepCaps.setNumSamples(this.NUM_SAMPLES);
        } else {
            this.deepCaps.setSampleBuffers(false);
        }
        this.deepCanvas = new GLCanvas(this.deepCaps);
        this.deepCanvas.addGLEventListener((GLEventListener)this.deepListener);
        this.deepCanvas.addKeyListener((KeyListener)this.deepListener);
        this.deepFrame.add((Component)this.deepCanvas);
        this.deepFrame.setSize(this.WIDTH, this.HEIGHT);
        this.deepFrame.setResizable(false);
        if (this.isFullScreen) {
            this.deepFrame.setAlwaysOnTop(true);
        }
        this.deepFrame.setUndecorated(true);
        graphicsEnvironment.getDefaultScreenDevice();
        cloneable = graphicsEnvironment.getCenterPoint();
        this.deepFrame.setLocation(((Point)cloneable).x - this.WIDTH / 2, ((Point)cloneable).y - this.HEIGHT / 2);
        if (this.isFullScreen) {
            int[] nArray = new int[256];
            Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, nArray, 0, 16));
            Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
            this.deepCanvas.setCursor(cursor);
        }
        this.deepFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SunflowerSeeds2.this.stopDemo();
                System.exit(0);
            }
        });
        this.deepFrame.show();
        this.deepCanvas.requestFocusInWindow();
        this.__animator = new FPSAnimator((GLAutoDrawable)this.deepCanvas, 120);
        this.__animator.setRunAsFastAsPossible(true);
        this.__animator.start();
    }

    public void stopDemo() {
        this.deepCanvas.removeGLEventListener((GLEventListener)this.deepListener);
        this.scene.Release();
        this.vgl.release();
        this.vgl = null;
        this.__animator.stop();
        this.deepFrame.setVisible(false);
        this.deepFrame.dispose();
        this.deepFrame = null;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "SunflowerSeeds2"});
    }

    class CustomScene
    extends Effect {
        boolean _doUpdate;
        boolean _showCenter;
        VTexture2D _bgTex;
        VTexture2D _centerTex;
        ArrayList _seeds;
        int _stringIndex;
        float _seedInitialVelocity;
        int blackOrWhite;
        Vector3 _center;
        Vector3 _radarPos;
        float _angle;
        float _angleStep;
        float _lastAngleTarget;
        float _angleTarget;
        float _radius;
        float _maxRadius;
        Vector3 _constAccel;
        ParticleSystem _pSystem;
        GL _gl;

        CustomScene() {
        }

        public boolean Init(GL gL) {
            this._gl = gL;
            this._doUpdate = true;
            this._showCenter = true;
            SunflowerSeeds2.println((String)"create particle system");
            this._pSystem = new ParticleSystem(null);
            this._stringIndex = 0;
            this._seeds = new ArrayList();
            this._seedInitialVelocity = 15.0f;
            this._center = new Vector3(0.0f, 0.0f, 0.0f);
            this._radarPos = new Vector3();
            this._angle = 0.0f;
            this._angleStep = 0.5f;
            this._lastAngleTarget = this._angleTarget = 360.0f / (float)SunflowerSeeds2.this.textStrings.length;
            this._radius = 400.0f;
            this._maxRadius = 200.0f;
            this._gl.glLineWidth(1.0f);
            return true;
        }

        public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, int n) {
            float f7 = f6 / (float)n;
            float f8 = f + SunflowerSeeds2.sin((float)(f5 += 1.5707964f)) * f3;
            float f9 = f2 + SunflowerSeeds2.cos((float)f5) * f4;
            SunflowerSeeds2.this.vgl.beginShape(1);
            SunflowerSeeds2.this.vgl.color4(1.0f, 1.0f, 1.0f, 1.0f);
            SunflowerSeeds2.this.vgl.vertex(f8, f9, 0.0f);
            int n2 = 1;
            while (n2 <= n) {
                float f10 = f5 + (float)n2 * f7;
                f8 = f + SunflowerSeeds2.sin((float)f10) * f3;
                f9 = f2 + SunflowerSeeds2.cos((float)f10) * f4;
                SunflowerSeeds2.this.vgl.vertex(f8, f9, 0.0f);
                ++n2;
            }
            SunflowerSeeds2.this.vgl.endShape();
        }

        public void Render(float f) {
            this.RenderScene(f);
        }

        public void RenderScene(float f) {
            float f2 = 0.003921569f;
            SunflowerSeeds2.this.vgl.setDepthWrite(false);
            SunflowerSeeds2.this.vgl.ortho((float)SunflowerSeeds2.this.WIDTH, (float)SunflowerSeeds2.this.HEIGHT);
            SunflowerSeeds2.this.vgl.beginShape(3);
            SunflowerSeeds2.this.vgl.color4(217.0f * f2, 161.0f * f2, 68.0f * f2, 1.0f);
            SunflowerSeeds2.this.vgl.vertex(0.0f, 0.0f, 0.0f);
            SunflowerSeeds2.this.vgl.color4(245.0f * f2, 233.0f * f2, 211.0f * f2, 1.0f);
            SunflowerSeeds2.this.vgl.vertex((float)SunflowerSeeds2.this.WIDTH, 0.0f, 0.0f);
            SunflowerSeeds2.this.vgl.color4(245.0f * f2, 233.0f * f2, 211.0f * f2, 1.0f);
            SunflowerSeeds2.this.vgl.vertex((float)SunflowerSeeds2.this.WIDTH, (float)SunflowerSeeds2.this.HEIGHT, 0.0f);
            SunflowerSeeds2.this.vgl.color4(0.3f, 0.3f, 0.3f, 1.0f);
            SunflowerSeeds2.this.vgl.vertex(0.0f, (float)SunflowerSeeds2.this.HEIGHT, 0.0f);
            SunflowerSeeds2.this.vgl.endShape();
            SunflowerSeeds2.this.vgl.perspective(45.0f, SunflowerSeeds2.this.aspectRatio, 1.0f, 1000.0f);
            SunflowerSeeds2.this.vgl.camera(0.0f, 0.0f, 400.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            SunflowerSeeds2.this.vgl.setDepthWrite(false);
            this._gl.glLineWidth(1.0f);
            this._pSystem.render();
            SunflowerSeeds2.this.vgl.rotateZ(-f * 45.0f * 0.25f);
            float f3 = SunflowerSeeds2.radians((float)this._angle);
            float f4 = SunflowerSeeds2.cos((float)f3) * this._radius;
            float f5 = SunflowerSeeds2.sin((float)f3) * this._radius;
            this._radarPos.set(f4, f5, 0.0f);
            this._radarPos.add(this._center);
            SunflowerSeeds2.this.vgl.enableTexture(false);
            SunflowerSeeds2.this.vgl.setDepthMask(false);
            SunflowerSeeds2.this.vgl.setFlipV(true);
            SunflowerSeeds2.this.vgl.fill(1.0f);
            int n = 0;
            while (n < this._seeds.size()) {
                Seed seed = (Seed)this._seeds.get(n);
                seed.render(f);
                seed.update(f, this._maxRadius);
                ++n;
            }
            if (this._showCenter) {
                float f6 = 30.0f;
                SunflowerSeeds2.this.vgl.fill(0.0f, 0.5f);
                SunflowerSeeds2.this.vgl.ellipse(this._center.x + 2.0f, this._center.y - 2.0f, this._center.z, f6, f6, 40);
                int n2 = 1;
                Color4 color4 = (Color4)SunflowerSeeds2.this._colors.get(n2);
                SunflowerSeeds2.this.vgl.fill(color4.r, color4.g, color4.b, color4.a);
                SunflowerSeeds2.this.vgl.pushMatrix();
                SunflowerSeeds2.this.vgl.translate(this._center.x, this._center.y, this._center.z);
                SunflowerSeeds2.this.vgl.rotateZ(f * 20.0f);
                SunflowerSeeds2.this.vgl.ellipse(0.0f, 0.0f, 0.0f, f6, f6, 40);
                n2 = 2;
                color4 = (Color4)SunflowerSeeds2.this._colors.get(n2);
                SunflowerSeeds2.this.vgl.fill(color4.r, color4.g, color4.b, color4.a);
                SunflowerSeeds2.this.vgl.ellipse(0.0f, 0.0f, 0.0f, f6 * 0.9f, f6 * 0.9f, 40);
                SunflowerSeeds2.this.vgl.popMatrix();
            }
            float f7 = 0.07f;
            SunflowerSeeds2.this.vgl.fill(0.3f, 0.5f);
            SunflowerSeeds2.this.vgl.beginShape(1);
            SunflowerSeeds2.this.vgl.vertex(this._center.x, this._center.y, this._center.z);
            SunflowerSeeds2.this.vgl.vertex(this._radarPos.x * f7, this._radarPos.y * f7, this._radarPos.z * f7);
            SunflowerSeeds2.this.vgl.endShape();
            SunflowerSeeds2.this.vgl.fill(0.3f, 1.0f);
            SunflowerSeeds2.this.vgl.ellipse(0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
            SunflowerSeeds2.this.vgl.ellipse(this._radarPos.x * f7, this._radarPos.y * f7, this._radarPos.z * f7, 1.0f, 1.0f);
        }

        public void Update(float f) {
            this._pSystem.update(f);
            if (this._doUpdate) {
                this._angleStep = 0.625f;
                this._angle += this._angleStep;
                float f2 = this._angleStep * 1.0f;
                if (this._angle > this._angleTarget - f2 && this._angle < this._angleTarget + f2) {
                    this._lastAngleTarget = this._angleTarget;
                    this._angleTarget += 20.625f;
                    this.createNewSeed(f);
                    ++this._stringIndex;
                }
            }
            this.repelBodyParts();
        }

        public void Release() {
        }

        public void createNewSeed(float f) {
            Vector3 vector3 = new Vector3();
            vector3.x = SunflowerSeeds2.cos((float)SunflowerSeeds2.radians((float)this._lastAngleTarget)) * this._radius;
            vector3.y = SunflowerSeeds2.sin((float)SunflowerSeeds2.radians((float)this._lastAngleTarget)) * this._radius;
            vector3.add(this._center);
            float f2 = 1.5f;
            float f3 = (float)SunflowerSeeds2.this.HEIGHT / (float)SunflowerSeeds2.this.WIDTH * 10.0f;
            this._constAccel = Vector3.sub((Vector3)vector3, (Vector3)this._center);
            this._constAccel.normalize();
            this._constAccel.mul(f2);
            Seed seed = new Seed(this._center, this._constAccel, f3);
            ++this.blackOrWhite;
            this._seeds.add(seed);
        }

        public void repelBodyParts() {
            int n = 0;
            while (n < this._seeds.size()) {
                int n2 = n + 1;
                while (n2 < this._seeds.size()) {
                    Vector3 vector3;
                    float f;
                    Seed seed = (Seed)this._seeds.get(n2);
                    Seed seed2 = (Seed)this._seeds.get(n);
                    if (n2 != n && (f = (vector3 = Vector3.sub((Vector3)seed._pos, (Vector3)seed2._pos)).length()) < (seed._bodyRadius + seed2._bodyRadius) * 0.5f) {
                        seed2.applyRepulseForce();
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    class GLRenderer
    implements GLEventListener,
    KeyListener {
        GL _gl;

        GLRenderer() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            this._gl = gLAutoDrawable.getGL();
            this._gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            SunflowerSeeds2.this.vgl = new VGL(gLAutoDrawable.getGL(), new GLU(), SunflowerSeeds2.this.WIDTH, SunflowerSeeds2.this.HEIGHT);
            SunflowerSeeds2.this.vgl.setVSync(true);
            SunflowerSeeds2.println((String)"Init app (alloc everything)");
            SunflowerSeeds2.this.initApp();
            this._gl.glEnable(3042);
            SunflowerSeeds2.this.vgl.setAlphaBlend();
            this._gl.glHint(3152, 4354);
            SunflowerSeeds2.println((String)"init finished");
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            SunflowerSeeds2.this.drawP5();
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            SunflowerSeeds2.println((String)"reshape()");
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
            SunflowerSeeds2.println((String)"displayChanged()");
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                System.exit(0);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class Particle {
        int _index;
        float _startTime;
        float _speed;
        boolean _isDead;
        float _age;
        float _timeToLive;
        float _size;
        float _originSize;
        Vector3 _offset;
        Vector3 _origin;
        Vector3 _oldPos;
        Vector3 _pos;
        Vector3 _vel;
        int _tailRenderSegments;
        int _tailSize;
        ArrayList _tailList;
        Color4 _color;
        Color4 _originColor;

        Particle(int n, float f) {
            this._index = n;
            this.reset(f);
        }

        Particle(int n, Vector3 vector3, float f) {
            this._index = n;
            this.reset(vector3, f);
        }

        public void reset(float f) {
            this._age = 0.0f;
            this._timeToLive = f;
            this._originSize = this._size = SunflowerSeeds2.this.random(1.0f, 6.0f);
            this._speed = SunflowerSeeds2.this.random(1.0f, 6.0f);
            this._isDead = false;
            if (this._pos == null) {
                this._pos = new Vector3(SunflowerSeeds2.this.random(-300.0f, 300.0f), SunflowerSeeds2.this.random(0.0f, 50.0f), SunflowerSeeds2.this.random(-500.0f, 500.0f));
            } else {
                this._pos.set(SunflowerSeeds2.this.random(-300.0f, 300.0f), SunflowerSeeds2.this.random(-300.0f, 300.0f), SunflowerSeeds2.this.random(-300.0f, 300.0f));
            }
            this._oldPos = this._pos.copy();
            this._origin = this._pos.copy();
            if (this._vel == null) {
                this._vel = new Vector3();
            } else {
                this._vel.reset();
            }
            this._tailSize = 8;
            this._tailRenderSegments = 0;
            if (this._tailList == null) {
                this._tailList = new ArrayList();
            } else {
                this._tailList.clear();
            }
            this._tailList.add(this._pos);
            int n = 0;
            while (n < this._tailSize) {
                this._tailList.add(this._pos.copy());
                ++this._tailRenderSegments;
                ++n;
            }
            n = (int)SunflowerSeeds2.this.random(SunflowerSeeds2.this._colors.size());
            this._color = ((Color4)SunflowerSeeds2.this._colors.get(n)).copy();
            this._originColor = ((Color4)SunflowerSeeds2.this._colors.get(n)).copy();
            float f2 = 5.0f;
            float f3 = SunflowerSeeds2.this.random(0.0f, (float)Math.PI);
            float f4 = SunflowerSeeds2.this.random(0.0f, (float)Math.PI * 2);
            float f5 = SunflowerSeeds2.sin((float)f3) * SunflowerSeeds2.cos((float)f4);
            float f6 = SunflowerSeeds2.sin((float)f3) * SunflowerSeeds2.sin((float)f4);
            float f7 = SunflowerSeeds2.cos((float)f3);
            if (this._offset == null) {
                this._offset = new Vector3(f5 * f2, f6 * f2, f7 * f2);
            }
            this._offset.set(f5 * f2, f6 * f2, f7 * f2);
            this._vel.set(SunflowerSeeds2.this.random(-1.0f, 1.0f), SunflowerSeeds2.this.random(-1.0f, 1.0f), SunflowerSeeds2.this.random(-1.0f, 1.0f));
            this._vel.mul(this._speed * 0.02f);
            this._startTime = SunflowerSeeds2.this.timer.getCurrTime();
        }

        public void reset(Vector3 vector3, float f) {
            this._age = 0.0f;
            this._timeToLive = f;
            this._originSize = this._size = SunflowerSeeds2.this.random(1.0f, 6.0f);
            this._speed = SunflowerSeeds2.this.random(1.0f, 6.0f);
            this._isDead = false;
            this._pos = vector3.copy();
            this._oldPos = this._pos.copy();
            this._origin = this._pos.copy();
            if (this._vel == null) {
                this._vel = new Vector3();
            } else {
                this._vel.reset();
            }
            this._tailSize = 8;
            this._tailRenderSegments = 0;
            if (this._tailList == null) {
                this._tailList = new ArrayList();
            } else {
                this._tailList.clear();
            }
            this._tailList.add(this._pos);
            int n = 0;
            while (n < this._tailSize) {
                this._tailList.add(this._pos.copy());
                ++this._tailRenderSegments;
                ++n;
            }
            n = (int)SunflowerSeeds2.this.random(SunflowerSeeds2.this._colors.size());
            this._color = ((Color4)SunflowerSeeds2.this._colors.get(n)).copy();
            this._originColor = ((Color4)SunflowerSeeds2.this._colors.get(n)).copy();
            this._vel.set(0.0f, 1.0f, 0.0f);
            this._vel.mul(this._speed * 0.2f);
            this._startTime = SunflowerSeeds2.this.timer.getCurrTime();
        }

        public void update(float f) {
            float f2 = MathUtils.clamp((float)(f - this._startTime), (float)0.0f, (float)1.0f);
            this._size = this._originSize * f2;
            float f3 = 5.0f;
            if (this._age > this._timeToLive - f3) {
                this._color.a -= 1.0f / (60.0f * f3);
            }
            this._oldPos = this._pos.copy();
            this._pos.add(this._vel);
            if (this._age > this._timeToLive) {
                this._isDead = true;
            }
            this._age += 0.016666668f;
        }

        public boolean isDead() {
            return this._isDead;
        }

        public void constraintToFloor(float f) {
            if (this._pos.y < f) {
                this._pos.y = f;
            }
        }
    }

    class ParticleComparator
    implements Comparator {
        ParticleComparator() {
        }

        public final int compare(Object object, Object object2) {
            float f = ((Particle)object)._pos.z;
            float f2 = ((Particle)object2)._pos.z;
            if (f > f2) {
                return 1;
            }
            return -1;
        }
    }

    class ParticleSystem {
        int MAX_PARTICLES = 175;
        float particleAddTime;
        float particleCountTime;
        Vector3 _emitter;
        int _particleCount = 0;
        ArrayList _particleList;
        ParticleComparator _comparator;
        int[] _vboID;
        FloatBuffer _positionBuffer = BufferUtils.createFloatBuffer((int)(this.MAX_PARTICLES * 3 * 2));
        FloatBuffer _colorBuffer = BufferUtils.createFloatBuffer((int)(this.MAX_PARTICLES * 4 * 2));

        ParticleSystem(ArrayList arrayList) {
            this._particleList = new ArrayList();
            this._comparator = new ParticleComparator();
            this.particleAddTime = 0.5f;
            this.particleCountTime = 0.0f;
            this._emitter = new Vector3();
        }

        public void init() {
        }

        public void render() {
            this.renderVA();
        }

        public void renderVA() {
            SunflowerSeeds2.this.vgl.enableTexture(false);
            this.updateBuffers();
            this.renderBuffers();
        }

        public void renderImmediateMode() {
            SunflowerSeeds2.this.vgl.enableTexture(false);
            SunflowerSeeds2.this.vgl.beginShape(1);
            int n = 0;
            while (n < this._particleList.size()) {
                Particle particle = (Particle)this._particleList.get(n);
                if (particle._pos != null) {
                    SunflowerSeeds2.this.vgl.color4(particle._color.r, particle._color.g, particle._color.b, particle._color.a);
                    SunflowerSeeds2.this.vgl.vertex(particle._origin.x, particle._origin.y, particle._origin.z);
                    SunflowerSeeds2.this.vgl.vertex(particle._pos.x, particle._pos.y, particle._pos.z);
                }
                ++n;
            }
            SunflowerSeeds2.this.vgl.endShape();
        }

        public void update(float f) {
            Particle particle;
            this._emitter.set(SunflowerSeeds2.sin((float)(f * 0.52f)) * 200.0f, -200.0f, 0.0f);
            this._emitter.x += 250.0f * (2.0f * SunflowerSeeds2.this.noise(f * 0.001f, f * 0.001f + this._emitter.x * 0.003f, this._emitter.y * 1.0E-4f) - 1.0f);
            if (f - this.particleCountTime > this.particleAddTime && this._particleList.size() < this.MAX_PARTICLES) {
                this.particleCountTime = f;
                float f2 = 50.0f;
                particle = new Vector3(SunflowerSeeds2.this.random(-f2, f2), SunflowerSeeds2.this.random(-f2, f2), SunflowerSeeds2.this.random(-f2, f2));
                Vector3 vector3 = Vector3.add((Vector3)this._emitter, (Vector3)particle);
                int n = (int)SunflowerSeeds2.this.random(1.0f, 4.0f);
                int n2 = 0;
                while (n2 < n) {
                    Particle particle2 = new Particle(this._particleCount, vector3, SunflowerSeeds2.this.random(3.0f, 10.0f));
                    this._particleList.add(particle2);
                    ++this._particleCount;
                    ++n2;
                }
            }
            while (this._particleList.size() > this.MAX_PARTICLES) {
                this._particleList.remove(this._particleList.size() - 1);
            }
            int n = 0;
            while (n < this._particleList.size()) {
                particle = (Particle)this._particleList.get(n);
                particle.update(f);
                if (particle.isDead()) {
                    this._particleList.remove(particle);
                }
                ++n;
            }
            Collections.sort(this._particleList, this._comparator);
        }

        public void renderBuffers() {
            SunflowerSeeds2.this.vgl.gl().glEnableClientState(32884);
            SunflowerSeeds2.this.vgl.gl().glEnableClientState(32886);
            SunflowerSeeds2.this.vgl.gl().glVertexPointer(3, 5126, 0, (Buffer)this._positionBuffer);
            SunflowerSeeds2.this.vgl.gl().glColorPointer(4, 5126, 0, (Buffer)this._colorBuffer);
            SunflowerSeeds2.this.vgl.gl().glDrawArrays(1, 0, this._particleList.size() * 2);
            SunflowerSeeds2.this.vgl.gl().glDisableClientState(32884);
            SunflowerSeeds2.this.vgl.gl().glDisableClientState(32886);
        }

        public void updateBuffers() {
            this._positionBuffer.clear();
            this._colorBuffer.clear();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this._particleList.size()) {
                Particle particle = (Particle)this._particleList.get(n3);
                Color4 color4 = particle._color;
                Vector3 vector3 = particle._origin;
                Vector3 vector32 = particle._pos;
                this._positionBuffer.put(n++, vector3.x);
                this._positionBuffer.put(n++, vector3.y);
                this._positionBuffer.put(n++, vector3.z);
                this._positionBuffer.put(n++, vector32.x);
                this._positionBuffer.put(n++, vector32.y);
                this._positionBuffer.put(n++, vector32.z);
                this._colorBuffer.put(n2++, color4.r);
                this._colorBuffer.put(n2++, color4.g);
                this._colorBuffer.put(n2++, color4.b);
                this._colorBuffer.put(n2++, color4.a);
                this._colorBuffer.put(n2++, color4.r);
                this._colorBuffer.put(n2++, color4.g);
                this._colorBuffer.put(n2++, color4.b);
                this._colorBuffer.put(n2++, color4.a);
                ++n3;
            }
            this._positionBuffer.rewind();
            this._colorBuffer.rewind();
        }
    }

    class Seed {
        static final boolean renderText = true;
        float _startTime;
        int _texIndex;
        Color4 _color;
        int _textIndex;
        float _bodyRadius;
        float _angle;
        float _damp = 0.95f;
        Vector3 _repulseForce;
        Vector3 _center;
        Vector3 _accel;
        Vector3 _vel;
        Vector3 _pos;

        Seed(Vector3 vector3, Vector3 vector32, float f) {
            this._accel = vector32.copy();
            this._repulseForce = vector32.copy();
            this._repulseForce.normalize();
            this._vel = new Vector3();
            this._pos = new Vector3(0.0f, 0.0f, 0.0f);
            this._pos.add(vector3);
            this._center = vector3;
            this._bodyRadius = f;
            this._color = new Color4(1.0f, 1.0f, 1.0f, 1.0f);
            Vector3 vector33 = Vector3.sub((Vector3)vector3, (Vector3)this._accel);
            this._angle = SunflowerSeeds2.atan2((float)vector33.y, (float)vector33.x);
            int n = SunflowerSeeds2.this._colors.size();
            int n2 = 0;
            while (n2 < n + 1) {
                float f2 = (float)n2 / (float)n;
                float f3 = (float)(n2 + 1) / (float)n;
                float f4 = (float)Math.PI * 2 * f2;
                float f5 = (float)Math.PI * 2 * f3;
                if (this._angle + (float)Math.PI >= f4 && this._angle + (float)Math.PI < f5) {
                    this._color = ((Color4)SunflowerSeeds2.this._colors.get(n2 % SunflowerSeeds2.this._colors.size())).copy();
                }
                ++n2;
            }
            n2 = (int)SunflowerSeeds2.this.random(SunflowerSeeds2.this._colors.size());
            SunflowerSeeds2.this.currActiveColor = this._color = ((Color4)SunflowerSeeds2.this._colors.get(n2)).copy();
            this._textIndex = SunflowerSeeds2.this.scene._stringIndex;
            this._startTime = SunflowerSeeds2.this.timer.getCurrTime();
        }

        public void render(float f) {
            Vector3 vector3 = Vector3.sub((Vector3)this._center, (Vector3)this._pos);
            float f2 = vector3.length();
            float f3 = f2 / 200.0f;
            f3 = f3 * f3 * f3;
            float f4 = MathUtils.clamp((float)Elastic.easeOut((float)(f - this._startTime), (float)0.0f, (float)1.0f, (float)4.0f), (float)0.0f, (float)2.0f);
            float f5 = 1 + SunflowerSeeds2.this.textStrings[this._textIndex % SunflowerSeeds2.this.textStrings.length].length();
            SunflowerSeeds2.this.vgl.pushMatrix();
            SunflowerSeeds2.this.vgl.translate(Vector3.add((Vector3)this._pos, (Vector3)new Vector3(0.0f, -4.0f, 0.0f)));
            SunflowerSeeds2.this.vgl.rotateZ(180.0f + SunflowerSeeds2.degrees((float)this._angle));
            SunflowerSeeds2.this.vgl.fill(0.0f, 0.25f);
            SunflowerSeeds2.this.vgl.rectTopLeft(this._bodyRadius * f4 * f5, this._bodyRadius * 2.0f * f4);
            SunflowerSeeds2.this.vgl.popMatrix();
            SunflowerSeeds2.this.vgl.pushMatrix();
            SunflowerSeeds2.this.vgl.translate(this._pos);
            SunflowerSeeds2.this.vgl.rotateZ(180.0f + SunflowerSeeds2.degrees((float)this._angle));
            SunflowerSeeds2.this.vgl.fill(this._color.r, this._color.g, this._color.b, this._color.a);
            SunflowerSeeds2.this.vgl.rectTopLeft(this._bodyRadius * f4 * f5, this._bodyRadius * 2.0f * f4);
            boolean bl = false;
            if (this._color.r == 1.0f && this._color.g == 1.0f && this._color.b == 1.0f) {
                bl = true;
            }
            float f6 = MathUtils.clamp((float)((f - this._startTime) * 0.025f), (float)0.0f, (float)1.0f);
            if ((f6 *= f6) < 1.0f) {
                SunflowerSeeds2.this.vgl.translate(this._bodyRadius, this._bodyRadius * 0.5f, 0.0f);
                float f7 = (float)SunflowerSeeds2.this.HEIGHT / (float)SunflowerSeeds2.this.WIDTH * 15.0f * 10.0f;
                if (this._texIndex > 2 || bl) {
                    SunflowerSeeds2.this.textRender.setColor(0.0f, 0.0f, 0.0f, 1.0f - f6);
                } else {
                    SunflowerSeeds2.this.textRender.setColor(1.0f, 1.0f, 1.0f, 1.0f - f6);
                }
                SunflowerSeeds2.this.textRender.print(SunflowerSeeds2.this.textStrings[this._textIndex % SunflowerSeeds2.this.textStrings.length], 0.0f, 0.0f, 0.0f, (0.2f + this._bodyRadius / f7) * f4);
            }
            SunflowerSeeds2.this.vgl.popMatrix();
        }

        public void update(float f, float f2) {
            this._vel.add(this._accel);
            this._pos.add(this._vel);
            this._vel.mul(this._damp);
            this._accel.reset();
            this._color.a = MathUtils.clamp((float)(f - this._startTime), (float)0.0f, (float)1.0f);
        }

        public void applyRepulseForce() {
            this._vel = this._repulseForce.copy();
            this._vel.mul(1.0f - this._damp);
        }

        public void setColor() {
            this._color.r = SunflowerSeeds2.this.random(1.0f);
            this._color.g = SunflowerSeeds2.this.random(1.0f);
            this._color.b = SunflowerSeeds2.this.random(1.0f);
            this._color.a = 1.0f;
        }
    }
}

