
float4x4	gphProjectionModelViewMatrix;

struct VS_INPUT
{
	float3 pos		: POSITION;
	float3 nor		: NORMAL;
	float2 uv		: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 pos		: POSITION;
	float2 uv		: TEXCOORD2;
};

VS_OUTPUT gphMainVSH( VS_INPUT IN )
{
	VS_OUTPUT OUT;

	OUT.pos = mul(float4(IN.pos,1.0),gphProjectionModelViewMatrix);
	OUT.uv = IN.uv;

	return OUT;
}

sampler		gphTexture0:register(s0);
sampler		gphTexture1:register(s1);

uniform float4 off;

float4 gphMainFSH(VS_OUTPUT IN):COLOR
{
	float2 center = (IN.uv-float2(0.5,0.5))*2.0f;

	float factor = pow(length(center),3);

	float2 off_noisy = IN.uv + tex2D(gphTexture1,IN.uv+off.xy)*0.005*off.z;

	int2 ipos = (off_noisy)*32;
	float2 uvpos = ipos/32.0f;
	float4 col1 = tex2D(gphTexture0,off_noisy);
	float4 col2 = tex2D(gphTexture0,uvpos);
	
	return (col1*(1.0-factor) + col2*(factor));
}
