
// 
// Directional Abstract Blur Filter 
// by zeroshift
//

// Projection View Model Matrix
float4x4	gphPVMMatrix;

// Blur source texture
sampler		gphTexture0:register(s0);

// Blur filter configuration
// x,y - blur direction
// z - intensity
// w - pixel relative size to texture
float4 Settings;

// Pixel weights
float Weight[13];

// Vertex data structures
struct VS_INPUT
{
	float3 pos		: POSITION;
	float3 nor		: NORMAL;
	float2 uv		: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 pos		: POSITION;
	float2 uv		: TEXCOORD0;
};

// Vertex Shader
VS_OUTPUT gphMainVSH( VS_INPUT IN )
{
	VS_OUTPUT OUT;
	OUT.uv	= IN.uv;
	OUT.pos	= mul(float4(IN.pos.xyz,1.0),gphPVMMatrix);
	return OUT;
}

// Pixel Shader
float4 gphMainPSH( VS_OUTPUT IN ) : COLOR
{
	float4 col = float4(0,0,0,0);	
							
	for(float i = -6.0;i<=6.0;i+=1.0)
	{
		float off = i*Settings.w; 
		float wei = Weight[i+6];
		col	+=tex2D(gphTexture0,IN.uv +Settings.xy*off )* wei*Settings.z;
	}

	return col;
}

