/*
    Invtro for Inércia Demoparty 2010

    http://creativecommons.org/licenses/by-nc-sa/2.5/
    
    Victor Martins
    www.pixelnerve.com
    
    
    This class handles the java window for fullscreen mode. Processing is a bitch for fullscreen mode and pure JOGL calls.
    This is also not the best solution but it works just fine for our needs.
*/


import java.awt.event.*;
import javax.swing.*;
import javax.media.opengl.glu.*; 
import com.sun.opengl.util.*;
//import com.sun.opengl.util.FPSAnimator;     

// Globals
Frame deepFrame;
GLCapabilities deepCaps;
GLCanvas deepCanvas;
GLRenderer deepListener;
FPSAnimator deepAnimator; 


void initDemo()
{
  GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();

    if( isFullScreen ) 
    {
        // Get the size of the default screen
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        WIDTH = dim.width;
        HEIGHT = dim.height;
        aspectRatio = WIDTH / (float)HEIGHT;
    }

  deepListener = new GLRenderer();
  deepFrame = new Frame( "Float" );
  deepCaps = new GLCapabilities();
  deepCaps.setHardwareAccelerated( true );
  deepCaps.setDoubleBuffered( true );
  if( NUM_SAMPLES > 0 )
  {
    deepCaps.setSampleBuffers( true );
    deepCaps.setNumSamples( NUM_SAMPLES );
  }
  else
  {
    deepCaps.setSampleBuffers( false );
  }
  deepCanvas = new GLCanvas( deepCaps );
  deepCanvas.addGLEventListener( deepListener );
  deepCanvas.addKeyListener( deepListener );
  deepFrame.add( deepCanvas );
  deepFrame.setSize( WIDTH, HEIGHT );
  deepFrame.setResizable( false );
  if( isFullScreen ) deepFrame.setAlwaysOnTop( true );
  deepFrame.setUndecorated( true );


  GraphicsDevice displayDevice = ge.getDefaultScreenDevice();
  Point pp = ge.getCenterPoint();
  deepFrame.setLocation( pp.x-WIDTH/2, pp.y-HEIGHT/2 );
//  println("x: " + pp.x + " y: " + pp.y);
//  deepFrame.setLocation( 0, 0 );
//  println("x:" + pp.x + " y: " + pp.y);

    //
    // DEBUG
    //
//    println( "Available video memory (negative value means unlimited mem): " + displayDevice.getAvailableAcceleratedMemory() );
//    println( "Can Fullscreen: " + displayDevice.isFullScreenSupported() );
//    DisplayMode[] modes = displayDevice.getDisplayModes();
//    for( int i=0; i<modes.length; i++ )
//    {
//        println( modes[i].getWidth() + " x " + modes[i].getHeight() + " x " + modes[i].getBitDepth() + " x " + modes[i].getRefreshRate() + "hz" );
//    }

/*
  if( isFullScreen ) 
  {
    displayDevice.setFullScreenWindow( deepFrame );    
    DisplayMode dm = new DisplayMode( WIDTH, HEIGHT, 32, 60 );
    displayDevice.setDisplayMode( dm );
  }*/

  if( isFullScreen ) 
  {
    // Create transparent cursor and set it to our canvas  
    int[] pixels = new int[16*16];
    Image image = Toolkit.getDefaultToolkit().createImage( new MemoryImageSource(16, 16, pixels, 0, 16) );
    Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor( image, new Point(0, 0), "invisibleCursor" );
    deepCanvas.setCursor( transparentCursor );
  }

  deepFrame.addWindowListener( new WindowAdapter()
  {
    public void windowClosing( WindowEvent e )
    {
      stopDemo();
      System.exit( 0 );
    }
  } );


  deepFrame.show();
  deepCanvas.requestFocus();  
  deepAnimator = new FPSAnimator( deepCanvas, 60, true );
  deepAnimator.setRunAsFastAsPossible( true );
  deepAnimator.start();  
}




void stopDemo()
{
  deepCanvas.removeGLEventListener( deepListener );

    scene.Release();  

  vgl.release();
  vgl = null;

  deepAnimator.stop();
  deepFrame.setVisible( false );
  deepFrame.dispose();
  deepFrame = null;
}





class GLRenderer implements GLEventListener, KeyListener
{
  GL _gl;

  public void init( GLAutoDrawable drawable ) 
  {
    _gl = drawable.getGL();

    _gl.glClearColor( 0, 0, 0, 1 );

    vgl = new VGL( drawable.getGL(), new GLU(), WIDTH, HEIGHT );  // dont use processing, and set debug mode on
    vgl.setVSync( true );

    println( "Init app (alloc everything)" );
    initApp();

//    _gl.glEnable( GL.GL_NORMALIZE );
    _gl.glEnable( GL.GL_BLEND );
    vgl.setAlphaBlend();
    _gl.glHint( GL.GL_PERSPECTIVE_CORRECTION_HINT, GL.GL_NICEST ); 
//    _gl.glHint( GL.GL_FOG_HINT, GL.GL_NICEST ); 
        
    println( "init finished" );
  }


  public void display( GLAutoDrawable drawable )
  {
    vgl.setGL( drawable.getGL() );
    drawP5();
  }

  public void reshape( GLAutoDrawable drawable, int x, int y, int width, int height ) 
  {
        vgl.setGL( drawable.getGL() );
      println( "reshape()" );
  }

  public void displayChanged( GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged )
  {
        vgl.setGL( drawable.getGL() );
      println( "displayChanged()" );
  }
  
  public void keyPressed( KeyEvent e ) 
  {
    if( e.getKeyCode() == KeyEvent.VK_ESCAPE )
    {
      System.exit( 0 );
    }
  }
  
  public void keyReleased( KeyEvent e ) 
  {
  }
 
  public void keyTyped( KeyEvent e ) 
  {
  }
} 
