import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.imageio.*;
import javax.imageio.stream.*;
import javax.swing.*;


import java.nio.*;
import com.sun.opengl.util.texture.*;


/*final int[] targets = { GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_X, 
                        GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X, 
                        GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, 
                        GL.GL_TEXTURE_CUBE_MAP_POSITIVE_Y, 
                        GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z,
                        GL.GL_TEXTURE_CUBE_MAP_POSITIVE_Z };  */
final int[] targets = { GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X, 
                        GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_X, 
                        GL.GL_TEXTURE_CUBE_MAP_POSITIVE_Y, 
                        GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, 
                        GL.GL_TEXTURE_CUBE_MAP_POSITIVE_Z,
                        GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z };


static int GL_LUMINANCE = GL.GL_LUMINANCE;
static int GL_RGB = GL.GL_RGB;
static int GL_RGBA = GL.GL_RGBA;
static int GL_REPEAT = GL.GL_REPEAT;
static int GL_CLAMP = GL.GL_CLAMP;
static int GL_CLAMP_TO_EDGE = GL.GL_CLAMP_TO_EDGE;
static int GL_POINT = GL.GL_POINT;
static int GL_LINEAR = GL.GL_LINEAR;
static int GL_TEXTURE_CUBE_MAP = GL.GL_TEXTURE_CUBE_MAP;
static int GL_TEXTURE_3D = GL.GL_TEXTURE_3D;
static int GL_TEXTURE_2D = GL.GL_TEXTURE_2D;
static int GL_TEXTURE_1D = GL.GL_TEXTURE_1D;


class XTexture
{
  XTexture()
  {
    _tex = null;
    
    isLoaded = false;
    
    _texType = GL.GL_TEXTURE_2D;
  }

  XTexture( int type )
  {
    _tex = null;
    
    isLoaded = false;
    
    _texType = type;
  }


  XTexture( String fName )
  {
    fileName = fName;
    _tex = null;
    _buffer = null;
    _img = null;
    
    isLoaded = false;

    _texType = GL.GL_TEXTURE_2D;
    
    load( fName );
  }
  
  void bind()
  {
    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glActiveTexture( GL.GL_TEXTURE0 );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
    }
    if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glActiveTexture( GL.GL_TEXTURE0 );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
    }
  }

  void bind( int textureIndex )
  {
    switch( textureIndex )
    {
      case 0:
        vgl.gl().glActiveTexture( GL.GL_TEXTURE0 );
        break;
      case 1:
        vgl.gl().glActiveTexture( GL.GL_TEXTURE1 );
        break;
      case 2:
        vgl.gl().glActiveTexture( GL.GL_TEXTURE2 );
        break;
    }

    if( _texType == GL.GL_TEXTURE_2D )  vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )  vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
  }

  void enable()
  {
    bind( 0 );
    vgl.enableTexture( true );
    //_tex.enable();
  }

  void enable( int i )
  {
    bind( i );
    vgl.enableTexture( true );
    //_tex.enable();
  }

  void disable()
  {
    if( _texType == GL.GL_TEXTURE_2D )  vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, 0 );
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )  vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, 0 );

    vgl.enableTexture( false );
  }

  void disable( int texUnit )
  {
    switch( texUnit )
    {
      case 0:
        vgl.gl().glActiveTexture( GL.GL_TEXTURE0 );
        break;
      case 1:
        vgl.gl().glActiveTexture( GL.GL_TEXTURE1 );
        break;
      case 2:
        vgl.gl().glActiveTexture( GL.GL_TEXTURE2 );
        break;
    }

    if( _texType == GL.GL_TEXTURE_2D )  vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, 0 );
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )  vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, 0 );
    vgl.enableTexture( false );
  }


  void setWrap()
  {
    if( _tex != null )
    {
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
    }
    else
    {
      if( _texType == GL.GL_TEXTURE_2D )
      {
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
      }
      else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
      {
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
      }
      
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
    }
  }


  void setClamp()
  {
    if( _tex != null )
    {
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
    }
    else
    {
      if( _texType == GL.GL_TEXTURE_2D )
      {
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
      }
      else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
      {
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
      }
    }
  }


  void setClampToEdge()
  {
    if( _tex != null )
    {
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
    }
    else
    {
      if( _texType == GL.GL_TEXTURE_2D )
      {
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      }
      else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
      {
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
        vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      }
    }
  }


  // Sets a texture to be compared as a zbuffer
  // check shadow extension for more information
  void setToCompare()
  {
    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_COMPARE_MODE, GL.GL_COMPARE_R_TO_TEXTURE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_COMPARE_FUNC, GL.GL_LEQUAL );
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_COMPARE_MODE, GL.GL_COMPARE_R_TO_TEXTURE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_COMPARE_FUNC, GL.GL_LEQUAL );
    }
  }



  void createGL( int w, int h )
  {
     _width = w;
     _height = h;

     int[] id = { 0 };

    // Creating texture.
    vgl.gl().glGenTextures( 1, id, 0 );
    _id = id[0];
    println( "texture created: " + _id );

    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE ); // automatic mipmap generation included in OpenGL v1.4
      vgl.gl().glGenerateMipmapEXT( GL.GL_TEXTURE_2D );       
  //    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
  //    vgl._glu.gluBuild2DMipmaps( GL.GL_TEXTURE_2D, GL.GL_RGBA, _width, _height, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE ); // automatic mipmap generation included in OpenGL v1.4
      vgl.gl().glGenerateMipmapEXT( GL.GL_TEXTURE_RECTANGLE_ARB );
  //    vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
  //    vgl._glu.gluBuild2DMipmaps( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_RGBA, _width, _height, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );    
    }
  }

  void createGL16Bit( int w, int h )
  {
    _width = w;
    _height = h;

    int[] id = { 0 };

    // Creating texture.
    vgl.gl().glGenTextures( 1, id, 0 );
    _id = id[0];
    println( "texture created: " + _id );


    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE ); // automatic mipmap generation included in OpenGL v1.4
  //    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_LUMINANCE, GL.GL_FLOAT, null );
  //    vgl._glu.gluBuild2DMipmaps( GL.GL_TEXTURE_2D, GL.GL_RGBA, _width, _height, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE ); // automatic mipmap generation included in OpenGL v1.4
  //    vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, GL.GL_RGBA, _width, _height, 0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, GL.GL_LUMINANCE_ALPHA, _width, _height, 0, GL.GL_LUMINANCE, GL.GL_FLOAT, null );
  //    vgl._glu.gluBuild2DMipmaps( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_RGBA, _width, _height, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );    
    }
  }


  void createGLFloat( int internalFormat, int format, int w, int h )
  {
    _width = w;
    _height = h;

    int[] id = { 0 };

    // Creating texture.
    vgl.gl().glGenTextures( 1, id, 0 );
    _id = id[0];
    println( "texture created: " + _id );

    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_NEAREST );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_NEAREST );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, internalFormat, _width, _height, 0, format, GL.GL_FLOAT, null );
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_NEAREST );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_NEAREST );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, internalFormat, _width, _height, 0, format, GL.GL_FLOAT, null );
    }
  }

  void createGLFloat16Bit( int internalFormat, int format, int w, int h, float[] data )
  {
    _width = w;
    _height = h;

    int[] id = { 0 };

    // Creating texture.
    vgl.gl().glGenTextures( 1, id, 0 );
    _id = id[0];
    println( "texture created: " + _id );

    // Allow values different from the usual [-1..1]  
    vgl.gl().glClampColorARB( GL.GL_CLAMP_VERTEX_COLOR_ARB, GL.GL_FALSE );
    vgl.gl().glClampColorARB( GL.GL_CLAMP_FRAGMENT_COLOR_ARB, GL.GL_FALSE );
    vgl.gl().glClampColorARB( GL.GL_CLAMP_READ_COLOR_ARB, GL.GL_FALSE );  
    
    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, internalFormat, _width, _height, 0, format, GL.GL_FLOAT, FloatBuffer.wrap(data) );
//      vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, internalFormat, _width, _height, 0, format, GL.GL_HALF_FLOAT_ARB, FloatBuffer.wrap(data) );
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, internalFormat, _width, _height, 0, format, GL.GL_FLOAT, FloatBuffer.wrap(data) );
//      vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, internalFormat, _width, _height, 0, format, GL.GL_HALF_FLOAT_ARB, FloatBuffer.wrap(data) );
    }
    
    // Restore states
    vgl.gl().glClampColorARB( GL.GL_CLAMP_VERTEX_COLOR_ARB, GL.GL_TRUE );
    vgl.gl().glClampColorARB( GL.GL_CLAMP_FRAGMENT_COLOR_ARB, GL.GL_TRUE );
    vgl.gl().glClampColorARB( GL.GL_CLAMP_READ_COLOR_ARB, GL.GL_TRUE );          
  }



  boolean createCubemapFloat( int internalFormat, int format, int w, int h, float[][] data, boolean mipmap )
  {
    _width = w;
    _height = h;

    int[] texId = new int[1];
    vgl.gl().glGenTextures( 1, texId, 0 );
    _id = texId[0];

    vgl.gl().glEnable( GL.GL_TEXTURE_CUBE_MAP );
    vgl.gl().glBindTexture( GL.GL_TEXTURE_CUBE_MAP, _id );

    //enable filtering
//    vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
//    vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );
    vgl.gl().glTexParameterf( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
    vgl.gl().glTexParameterf( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
    vgl.gl().glTexParameterf( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_WRAP_R, GL.GL_CLAMP_TO_EDGE );
//    vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MAG_FILTER, GL.GL_NEAREST );
//    vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MIN_FILTER, GL.GL_NEAREST );
//    vgl.gl().glTexParameterf( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP );
//    vgl.gl().glTexParameterf( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );
//    vgl.gl().glTexParameterf( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_WRAP_R, GL.GL_CLAMP );


    if( mipmap )
    {
	        vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
	        vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );

	  	vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE );
  		vgl.gl().glGenerateMipmapEXT( GL.GL_TEXTURE_CUBE_MAP );
    }
    else            
    {
	        vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );
	        vgl.gl().glTexParameteri( GL.GL_TEXTURE_CUBE_MAP, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
    }

    for( int i=0; i<6; i++ ) 
    {
      vgl.gl().glTexImage2D( targets[i],
      0,
      internalFormat,
      _width,
      _height,
      0,
      GL.GL_RGB,
      format,
      FloatBuffer.wrap(data[i]) );
    }

    vgl.gl().glDisable( GL.GL_TEXTURE_CUBE_MAP );

    return true;
  } 
  

  void createDepthGL( int w, int h )
  {
     _width = w;
     _height = h;

     int[] id = { 0 };

    // Creating texture.
    vgl.gl().glGenTextures( 1, id, 0 );
    _id = id[0];
    println( "depth texture created: " + _id );

    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_NEAREST );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_NEAREST );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexEnvi( GL.GL_TEXTURE_ENV, GL.GL_TEXTURE_ENV_MODE, GL.GL_MODULATE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_COMPARE_FUNC, GL.GL_LEQUAL );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_DEPTH_TEXTURE_MODE, GL.GL_LUMINANCE ); //GL.GL_INTENSITY );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_COMPARE_MODE, GL.GL_COMPARE_R_TO_TEXTURE );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE ); // automatic mipmap generation included in OpenGL v1.4
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, GL.GL_DEPTH_COMPONENT24, _width, _height, 0, GL.GL_DEPTH_COMPONENT, GL.GL_FLOAT, null );
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_NEAREST );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_NEAREST );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
      vgl.gl().glTexEnvi( GL.GL_TEXTURE_ENV, GL.GL_TEXTURE_ENV_MODE, GL.GL_MODULATE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_COMPARE_FUNC, GL.GL_LEQUAL );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_DEPTH_TEXTURE_MODE, GL.GL_LUMINANCE ); //GL.GL_INTENSITY );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_COMPARE_MODE, GL.GL_COMPARE_R_TO_TEXTURE );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE ); // automatic mipmap generation included in OpenGL v1.4
      vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, GL.GL_DEPTH_COMPONENT24, _width, _height, 0, GL.GL_DEPTH_COMPONENT, GL.GL_FLOAT, null );
    }
  }

  void create( int w, int h )
  {
      _width = w;
      _height = h;
      _buffer = new BufferedImage( w, h, BufferedImage.TYPE_INT_ARGB );//_PRE );
      _tex = TextureIO.newTexture( _buffer, false );
      _id = _tex.getTextureObject();
      println( "texture created: " + _id );

//      _tex.setTexParameteri( GL.GL_TEXTURE_WRAP_R, GL.GL_REPEAT );
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );
      _tex.setTexParameterf( GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
      _tex.setTexParameterf( GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );
  }

  void load( String fName )//, boolean mipmap )  
  {   
    fileName = fName;
        
    try
    {
      //println( "LOAD TEXTURE START" );

      _tex = TextureIO.newTexture( new File(dataPath(fileName)), true );  //mipmap );
      //println( "AFTER TEX" );

      _id = _tex.getTextureObject();
      //println( "ID: " + _id );

      _width = _tex.getImageWidth();
      _height = _tex.getImageHeight();

      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT ); 
      _tex.setTexParameterf( GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );  
      //_tex.setTexParameteri( GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP ); 
      //_tex.setTexParameteri( GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP );  
      _tex.setTexParameteri( GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
      _tex.setTexParameteri( GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );//_MIPMAP_LINEAR );

      println("loading texture: " + fileName + " with id= " + _id );
      
      isLoaded = true;
    }
    catch( IOException e )
    {
      println( "*** texture error: " + e );
    }
    
    //println( "LOAD TEXTURE END" );
    
    //_id = _tex.getTarget();
    //println( "Texture: '" + fileName + "' with id: '" + _id + "'" );
    //println( "Estimated Memory Size: " + _tex.getEstimatedMemorySize() / 1024 + " KBytes" );

    //return tex;
  }

  void loadPImage( String fName )
  {
    fileName = fName;

    _img = loadImage( fName );
    if( _img == null )
    {
      println( "couldnt load texture: " + fileName );
      return;
    }

    _width = _img.width;
    _height = _img.height;

    //println( "copy buffer" );
    imgBuffer = new int[_width*_height];
    for( int j=0; j<_height; j++ )
    {
      for( int i=0; i<_width; i++ )
      {
        imgBuffer[i+j*_width] = (_img.pixels[i+j*_width]);
      }
    }

    int[] texId = new int[1];

    //println( "gen tex" );
    vgl.gl().glGenTextures( 1, texId, 0 );
    _id = texId[0];
    //println( "tex id: " + _id );

    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
  //    vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );  
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
  //    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, 4, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
      vgl.glu().gluBuild2DMipmaps( GL.GL_TEXTURE_2D, 4, _img.width, _img.height, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
  //    vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );  
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
  //    vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, 4, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
      vgl.glu().gluBuild2DMipmaps( GL.GL_TEXTURE_RECTANGLE_ARB, 4, _img.width, _img.height, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
    }

    isLoaded = true;
    println("loading texture: " + fileName + " with id= " + _id );
  }


  public ImageReader getReader(String suffix) throws IOException 
  {
    Iterator readers = ImageIO.getImageReadersBySuffix(suffix);
    if (readers.hasNext())
      return (ImageReader) readers.next();
    else
      throw new IOException("No readers for suffix: " + suffix);
  }
  
  public String getSuffix( File file ) throws IOException 
  {
    String filename = file.getName();
    int dotIndex = filename.lastIndexOf('.');
    if (dotIndex == -1)
      throw new IOException("No file suffix: " + filename);
    return filename.substring(1+dotIndex);
  }  
    
  void loadHDRImage( String filename )
  {
    File file = new File( filename );
    
    BufferedImage image;
    try
    {
      //image = ImageIO.read( file );
      ImageReader reader = getReader( getSuffix(file) );
      ImageInputStream in = ImageIO.createImageInputStream( file );
    } 
    catch( IOException e )
    {
      println( e );
    }
    
/*    File file = null;
    int    i_data = 0;
    double d_data = 0.0;

    // Get the file from the argument line.
    file = new File( filename );

    try 
    {
      // Wrap the FileInputStream with a DataInputStream
      FileInputStream file_input = new FileInputStream( file );
      DataInputStream data_in = new DataInputStream( file_input );
      
      String head = "#?RADIANCE\n";

      //
      // Read header
      //
      for( int i=0; i<11; i++ )
      {
        // Test header
        byte tmp = data_in.readByte();
        if( tmp != head.charAt(i) )
        {
          println( "This is not a valid HDR image" );
          return;
        }
      }
      
      //
      // Read informative area
      //
      String dump = "";
      String EOF = "\n";
      byte tmp = 0;
      int tmpi = 0;
      float tmpf = 0;
      
      // the series of programs/commands that generated the image
      tmp = data_in.readByte();          
      dump = "";
      while( tmp != EOF.charAt(0) )
      {
      //            println( byteToChar(tmp) );
        dump += byteToChar(tmp);
        tmp = data_in.readByte();          
      }
      println( dump );
      
      // FORMAT
      dump = "";
      tmp = data_in.readByte();          
      while( tmp != EOF.charAt(0) )
      {
      //            println( byteToChar(tmp) );
        dump += byteToChar(tmp);
        tmp = data_in.readByte();          
      }          
      println( dump );
      
      // EXPOSURE
      tmp = data_in.readByte();          
      dump = "";
      while( tmp != EOF.charAt(0) )
      {
      //            println( byteToChar(tmp) );
        dump += byteToChar(tmp);
        tmp = data_in.readByte();          
      }
      println( dump );
      
      
      // ????????
      dump = "";
      tmp = data_in.readByte();          
      while( tmp != EOF.charAt(0) )
      {
        dump += byteToChar(tmp);
        tmp = data_in.readByte();
      }
      println( dump );
      
      
      // Y   X
      tmp = data_in.readByte();          
      dump = "";
      while( tmp != EOF.charAt(0) )
      {
        dump += byteToChar(tmp);
        tmp = data_in.readByte();          
      }
      println( dump );


      try 
      {
        for( int i=0; i<900*900; i+=900 )
        {
//          tmp = data_in.readByte();
//          tmpi = data_in.readInt();
//          tmpf = data_in.readFloat();
          double tmpd = data_in.readDouble();
          println( tmpd );
        }
      }
      catch (EOFException eof) 
      {
        System.out.println ("End of File");
//          break;
      }
      
      data_in.close ();    
      
    } catch( IOException e ) {}
*/    
  } 

  char byteToChar( byte b )
  {
    //To Char
    return (char)(b & 0xFF);    
  }

  void loadPImageFromMemory( PImage img )
  {
    fileName = "__";

    _width = img.width;
    _height = img.height;

    int[] texId = new int[1];

    vgl.gl().glGenTextures( 1, texId, 0 );
    _id = texId[0];

    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
  //    vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );  
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_2D, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
  //    vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, 4, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
      vgl.glu().gluBuild2DMipmaps( GL.GL_TEXTURE_2D, 4, _img.width, _img.height, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(img.pixels) ); 
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
  //    vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
  //    vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_S, GL.GL_REPEAT );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_WRAP_T, GL.GL_REPEAT );  
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
      vgl.gl().glTexParameteri( GL.GL_TEXTURE_RECTANGLE_ARB, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
  //    vgl.gl().glTexImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, 4, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(_img.pixels) ); 
      vgl.glu().gluBuild2DMipmaps( GL.GL_TEXTURE_RECTANGLE_ARB, 4, _img.width, _img.height, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(img.pixels) ); 
    }


    isLoaded = true;
    println("loading texture: " + fileName + " with id= " + _id );
  }


  void update()
  {
//    if( _img != null );
//      _img.updatePixels();

//    vgl.gl().glPixelStorei(GL.GL_UNPACK_ROW_LENGTH, _width );
//    vgl.gl().glPixelStorei( GL.GL_UNPACK_SWAP_BYTES, 1 );
//    vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 4 );

    for( int j=0; j<_height; j++ )
    {
      for( int i=0; i<_width; i++ )
      {
        imgBuffer[i+j*_width] = (_img.pixels[i+j*_width]);
      }
    }

    if( _texType == GL.GL_TEXTURE_2D )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, _id );
      vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
      vgl.gl().glTexSubImage2D( GL.GL_TEXTURE_2D, 0, 0, 0, _width, _height, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(imgBuffer) ); //IntBuffer.wrap(_img.pixels) );
//      vgl.gl().glTexImage2D( GL.GL_TEXTURE_2D, 0, 4, _width, _height, 0, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(imgBuffer) ); //IntBuffer.wrap(_img.pixels) );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_2D, 0 );
    }
    else if( _texType == GL.GL_TEXTURE_RECTANGLE_ARB )
    {
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, _id );
      vgl.gl().glPixelStorei( GL.GL_UNPACK_ALIGNMENT, 1 );
      vgl.gl().glTexSubImage2D( GL.GL_TEXTURE_RECTANGLE_ARB, 0, 0, 0, _width, _height, GL.GL_BGRA, GL.GL_UNSIGNED_BYTE, IntBuffer.wrap(imgBuffer) );
      vgl.gl().glBindTexture( GL.GL_TEXTURE_RECTANGLE_ARB, 0 );
    }
    
    //println("updated, id= " + _id );
  }
  
  void delete()
  {
    int[] texId = { _id };
    try {
    vgl.gl().glDeleteTextures( 1, texId, 0 );
    } catch( GLException e )
    { 
      println( e );
    }
    
    _img = null;
    
    _id = 0;

    isLoaded = false;
  }
  
/*  int getTarget()
  {
    return _tex.getTarget();
  }*/

  int getId()
  {
    return _id;
  }

  int getWidth()
  {
    return _width;
  }

  int getHeight()
  {
    return _height;
  }


  //
  // Members
  //
  String fileName;
  Texture _tex;
  int    _id;

  int _width, _height;

  int _texType;

  PImage _img;
  int[] imgBuffer;

  BufferedImage  _buffer;
  
  boolean isLoaded;
};
