import javax.media.opengl.*;
import processing.opengl.*;
import vitamin.*;
import vitamin.math.*;
import vitamin.fx.*;


boolean USE_PROCESSING = true; 

boolean useBASS = false;
boolean doSound = true;
boolean offlineRenderSequence = true;


boolean isFullScreen = false;
int NUM_SAMPLES = 4; //int WIDTH = 1920/2;
//int HEIGHT = 1080/2;
int WIDTH = 1280;
int HEIGHT = 720;
float aspectRatio = WIDTH/(float)HEIGHT; 

VTimer timer;
VGL vgl;
//EffectManager fxMan;
CustomScene scene;
VCamera cam;
VTextRenderer textRender;

int currClick;
ArrayList clickList;

ArrayList _colors;   

Vector4 lightPos;

//VTexture2D overlayTex; 
//VTextureRECT rectTex; 

String cubemapPath = "IceRiver"; 


///___________________________________________________________
void setup()
{
    if( USE_PROCESSING )
    {   
        size( WIDTH, HEIGHT, OPENGL );
        hint( ENABLE_OPENGL_4X_SMOOTH ); 
      //hint( DISABLE_OPENGL_ERROR_REPORT ); 
    }
    
    if( !USE_PROCESSING ) noLoop(); 
    
  frameRate( 30 ); 

    // Init demo
    if( !USE_PROCESSING )
    {
        println( "Init window (demo)" );
        initDemo();     
    }
    else
    {
        initApp();
    } 
}


void initApp()
{
  aspectRatio = WIDTH / (float)HEIGHT; 

  randomSeed( 12345 );

    if( USE_PROCESSING )
    {
        vgl = new VGL( this );
        vgl.setVSync( true );
    } 

    textRender = new VTextRenderer( WIDTH, HEIGHT, "Verdana", 24 );
    
//  fxMan = new EffectManager( vgl.gl() );

  scene = new CustomScene();
  scene.Init( vgl.gl() );
//  fxMan.AddEffect( scene );

  // Process all effects now!
//  fxMan.process();

  lightPos = new Vector4( 0, 600, 0, 1 ); //200, 200, 200, 1 );

  cam = new VCamera( this, 0, 50, 300, 0, 0, 0, 0, 1, 0 );
  cam.setSensitivity( 0.05 );
  cam.setDamp( 0.95 ); 
//  cam.setToCenter();

//  overlayTex = new VTexture2D( vgl.gl() );
//  overlayTex.loadFromFile( dataPath("overlay2.png"), true );      
//  rectTex = new VTextureRECT( vgl.gl(), dataPath("overlay2.png") ); 



    currClick = 0;
    clickList = new ArrayList();
    readSynchList( dataPath("analysis.txt"), clickList );
    println( "ClickList size: " + clickList.size() );


    float r = 1.0 / 255.0;
    _colors = new ArrayList();
    _colors.add( new Color4(1, 1, 1, 1) );

    _colors.add( new Color4(175*r, 90*r, 113*r, 1) );
    _colors.add( new Color4(253*r, 135*r, 159*r, 1) );
    _colors.add( new Color4(40*r, 54*r, 54*r, 1) );
    _colors.add( new Color4(29*r, 22*r, 64*r, 1) );
    _colors.add( new Color4(255*r, 213*r, 221*r, 1) );
/*    _colors.add( new Color4(226*r, 223*r, 154*r, 1) );
    _colors.add( new Color4(235*r, 229*r, 77*r, 1) );
    _colors.add( new Color4(117*r, 116*r, 73*r, 1) );
    _colors.add( new Color4(75*r, 73*r, 11*r, 1) );
    _colors.add( new Color4(255*r, 0*r, 81*r, 1) );  */


  // when rendering offline, make sure bass is disabled
  if( offlineRenderSequence ) useBASS = false;
  
  if( doSound )
  {
      if( useBASS )
      {
          //
          // HELPER
          // 
          ffthelper = new FFTHelper( spectrumLength, numOfBands, false );
          ffthelper.setMaxLimits( 200, 2000 );
          damperval = 0.2f;
          ffthelper.setDamper( damperval );

          fftbuffer = new float[spectrumLength];
          
          initBass();
          runBass();
          playFile( dataPath("03 A Glacier.mp3") );
      }
      else
      {
        init_sound( spectrumLength, dataPath("03 A Glacier.mp3") );
        if( !offlineRenderSequence ) chn.play();
      }
  }

  if( !offlineRenderSequence ) timer = new VTimer();
  else timer = new VTimer( VTimer.OFFLINE );
  timer.start();
}



void draw()
{
    if( USE_PROCESSING ) drawP5();
}


///___________________________________________________________
void drawP5()
{
  float time = timer.getCurrTime();
  timer.update();
//  if( frameCount%60 == 0 ) println( frameRate );
  
  
  vgl.begin();
  
//  vgl.background( 0.025, 0.0025, 0.0025, 1.0 );
  vgl.background( (8/255.0), (7/255.0), (7/255.0) );
//  vgl.background( 0.9, 0.0, 0.0, 1.0 );

  
  scene.Render( time );
  scene.Update( time );
  
  vgl.setDepthWrite( false );
  vgl.setAlphaBlend();
  vgl.enableTexture( false );
  vgl.ortho();
  if( time < 5.0 )
  {
      float alph = 1-(time*0.2);
      if( alph < 0.0 ) alph = 0.0;
      vgl.fill( 0, alph );
      vgl.rect( 1, 1 );
  }
  float FadeOutTime = (3*60)+16;
  if( time >= FadeOutTime )
  {
      float alph = MathUtils.clamp( (time-FadeOutTime), 0, 1 );
      vgl.fill( 0, alph );
      vgl.rect( 1, 1 );

      vgl.ortho( WIDTH, HEIGHT );  
      textRender.setColor( 1, 1, 1, MathUtils.clamp( (time-FadeOutTime), 0, 1 ) );
      textRender.print( "V*", WIDTH-70, HEIGHT-30 );
  }
  
  float EndTime = (3*60)+17;
  if( time >= EndTime )
  {
      stop();
      System.exit( 0 );
  }


/*
  vgl.ortho( WIDTH, HEIGHT );

    vgl.enableTexture( false );
    vgl.fill( 1 );
    int idx = 0;
    for( int i=0; i<spectrumLength; i+=4 )
    {
        vgl.line( 30+idx, (HEIGHT-20), 0, 30+idx, (HEIGHT-30)-fftbuffer[i]*100, 0 );
        idx++;
    }
    
    for( int i=0; i<ffthelper.band.length; i++ )
    {
        vgl.line( 530+idx*5, (HEIGHT-20), 0, 530+idx*5, (HEIGHT-30)-ffthelper.bandmax[i]*1000, 0 );
        idx++;
    }
*/


  vgl.end();




  if( doSound )
  {
      analyze( frequencyScale, offlineRenderSequence );
  }


  //
  // Update camera
  //
  
//  if( !offlineRenderSequence ) updateCamera( 3 );
  if( mousePressed ) updateCamera( 3 );
  
  
  
  //
  // Offline rendering
  //
  if( offlineRenderSequence )
  {
    store( "suexmasgift", "SEQ", "png" );
    advance(); 
    // exit after 3.15 minutes
//    if( time >= 3.15*60 )
//      System.exit( 0 );     
      
//    save( sketchPath("SEQ/frame"+nf(frameCount,7)+".png") );
//    if( frameCount%30 == 0 ) println( "count: " + frameCount );
//    if( time > 20.0 ) System.exit( 0 );
  }
}



void updateCamera( float speed )
{
  // Get input
  if( keyPressed && keyCode == LEFT )
    cam.strafe( -speed );
  else if( keyPressed && keyCode == RIGHT )
    cam.strafe( speed );
  if( keyPressed && keyCode == UP )
    cam.move( speed );
  else if( keyPressed && keyCode == DOWN )
    cam.move( -speed );
  if( keyPressed && key == 'q' )
    cam.lift( speed );
  else if( keyPressed && key == 'a' )
    cam.lift( -speed );

  cam.rotateByMouse();
  
//  println( cam.getPosition().toString() + " -- " + cam.getTarget().toString() );
}  



void keyPressed()
{
  if( key == 's' )
  {
    save( "shot_"+frameCount+".png" );
  }
  
  scene.keyPressed();
}

///___________________________________________________________
void stop()
{
    if( useBASS )
    {
        stopBass();
    }
      
  scene.Release();
  vgl.release();
  
  super.stop();
}
