class RenderTargetCubeMap
{
	final static int CUBE_FACE_POSITIVE_X = 0;
	final static int CUBE_FACE_NEGATIVE_X = 1;
	final static int CUBE_FACE_POSITIVE_Y = 2;
	final static int CUBE_FACE_NEGATIVE_Y = 3;
	final static int CUBE_FACE_POSITIVE_Z = 4;
	final static int CUBE_FACE_NEGATIVE_Z = 5;

	final int[] _targets = { 
/*            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X+0,
            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X+1,
            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X+2,
            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X+3,
            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X+4,
            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X+5,*/

            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_X,
            GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_X,
            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_Y,
            GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y,
            GL.GL_TEXTURE_CUBE_MAP_POSITIVE_Z,
            GL.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
        }; 




  GL _gl;
  
  int _id;
  int _fboID;
  int _colorID;
  int _depthID;
  
  int _width, _height;
  
  int _targetID;
  
  
  RenderTargetCubeMap( GL gl )
  {
    _gl = gl;
    
    _targetID = GL.GL_TEXTURE_CUBE_MAP;
  }


	public void createCubeMap( int width, int height, boolean mipmap )  
	{
            _width = width;
	    _height = height;
		
	     int[] id = { 0 }; 		
            _gl.glGenTextures( 1, id, 0 ); 	
	    _colorID = id[0];
	    
	    _gl.glBindTexture( _targetID, _colorID );
	    _gl.glTexParameteri( _targetID, GL.GL_TEXTURE_WRAP_S, GL.GL_CLAMP_TO_EDGE );
	    _gl.glTexParameteri( _targetID, GL.GL_TEXTURE_WRAP_T, GL.GL_CLAMP_TO_EDGE );
	    _gl.glTexParameteri( _targetID, GL.GL_TEXTURE_WRAP_R, GL.GL_CLAMP_TO_EDGE );

            if( mipmap )
            {
    	        _gl.glTexParameteri( _targetID, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR_MIPMAP_LINEAR );
    	        _gl.glTexParameteri( _targetID, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
    
	  	_gl.glTexParameteri( _targetID, GL.GL_GENERATE_MIPMAP, GL.GL_TRUE );
  		_gl.glGenerateMipmapEXT( _targetID );
            }
            else            
            {
    	        _gl.glTexParameteri( _targetID, GL.GL_TEXTURE_MIN_FILTER, GL.GL_LINEAR );
    	        _gl.glTexParameteri( _targetID, GL.GL_TEXTURE_MAG_FILTER, GL.GL_LINEAR );
            }
            
       	    for( int face=0; face<6; face++ ) 
   	    {
   	        _gl.glTexImage2D( _targets[face], 0, GL.GL_RGBA, _width, _height, 0, GL.GL_RGBA, GL.GL_UNSIGNED_BYTE, null );
   	    }
   
   
            //-------------------------
            int[] fboid = {0};
             _gl.glGenFramebuffersEXT( 1, fboid, 0 );
             _fboID = id[0];

             //bind();
             _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, _fboID );
             errcheck();              

             //Attach one of the faces of the Cubemap texture to this FBO
             _gl.glFramebufferTexture2DEXT( GL.GL_FRAMEBUFFER_EXT, GL.GL_COLOR_ATTACHMENT0_EXT, _targets[0], _colorID, 0 );
              errcheck();              
              
             //-------------------------
             int[] depthid = {0};
             _gl.glGenRenderbuffersEXT( 1, depthid, 0 );
             _depthID = depthid[0];

             _gl.glBindRenderbufferEXT( GL.GL_RENDERBUFFER_EXT, _depthID );
             _gl.glRenderbufferStorageEXT( GL.GL_RENDERBUFFER_EXT, GL.GL_DEPTH_COMPONENT24, _width, _height );
              errcheck();              
             //-------------------------
             //Attach depth buffer to FBO
             _gl.glFramebufferRenderbufferEXT( GL.GL_FRAMEBUFFER_EXT, GL.GL_DEPTH_ATTACHMENT_EXT, GL.GL_RENDERBUFFER_EXT, _depthID );
             errcheck(); 

             _gl.glDrawBuffer( GL.GL_COLOR_ATTACHMENT0_EXT );

             validate();              

             unbind();
  	}




  void bindFace( int idx )
  {
    //Attach one of the faces of the Cubemap texture to this FBO
    _gl.glFramebufferTexture2DEXT( GL.GL_FRAMEBUFFER_EXT, GL.GL_COLOR_ATTACHMENT0_EXT, _targets[idx], _colorID, 0 );
    errcheck();              
    _gl.glDrawBuffer( GL.GL_COLOR_ATTACHMENT0_EXT );
    errcheck();              
  }

  void bind()
  { 
    _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, _fboID );
    errcheck();
  }

  void unbind()
  {
    _gl.glBindFramebufferEXT( GL.GL_FRAMEBUFFER_EXT, 0 );
    errcheck();
  } 
  
  
  void enableTexture()
  {
    _gl.glBindTexture( _targetID, _colorID );
  }


  void disableTexture()
  {
    _gl.glBindTexture( _targetID, 0 );
  }


  int getID()
  {
    return _colorID;
  }


  void validate()
  {
    int stat = _gl.glCheckFramebufferStatusEXT( GL.GL_FRAMEBUFFER_EXT );
    switch( stat )
    {
      case GL.GL_FRAMEBUFFER_COMPLETE_EXT:
        println( "GL_FRAMEBUFFER_COMPLETE_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT:
        println( "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT" );
        break;
      case GL.GL_FRAMEBUFFER_UNSUPPORTED_EXT:
        println( "GL_FRAMEBUFFER_UNSUPPORTED_EXT" );
        break;
      default:
        println( "Unknown" );
        break;
    }
    
    println( "FBO created: " + _width + " x " + _height );
  } 
  
  
  void errcheck()
  {
    int errCode = vgl.gl().glGetError();
    if( errCode != GL.GL_NO_ERROR ) 
    {
      String errString = vgl.glu().gluErrorString( errCode );
      //fprintf (stderr, "OpenGL Error: %s\n", errString);
      println( errString );
      exit();
    }
  } 
}
